/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.walkways;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_4538;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import rbasamoyai.escalated.index.EscalatedBlockPartials;
import rbasamoyai.escalated.index.EscalatedBlocks;
import rbasamoyai.escalated.walkways.WalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayBlockEntity;
import rbasamoyai.escalated.walkways.WalkwaySlope;
import rbasamoyai.escalated.walkways.WideEscalatorSideBlock;
import rbasamoyai.escalated.walkways.WideWalkwaySideBlock;

public class WalkwayRenderer
extends KineticBlockEntityRenderer<WalkwayBlockEntity> {
    public WalkwayRenderer(class_5614.class_5615 context) {
        super(context);
    }

    protected void renderSafe(WalkwayBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        if (Backend.canUseInstancing((class_1937)be.method_10997())) {
            return;
        }
        class_2680 state = this.getRenderedBlockState(be);
        KineticBlock kinetic = (KineticBlock)state.method_26204();
        WalkwayBlock walkway = (WalkwayBlock)state.method_26204();
        class_2350 facing = walkway.getFacing(state);
        class_1937 level = be.method_10997();
        class_2338 pos = be.method_11016();
        class_1921 type = this.getRenderType(be, state);
        if (type != null) {
            class_4588 cons = buffer.getBuffer(type);
            if (kinetic.hasShaftTowards((class_4538)level, pos, state, class_2350.field_11033)) {
                WalkwayRenderer.kineticRotationTransform((SuperByteBuffer)this.getHalfShaftRotatedModel(be, state, class_2350.field_11033), (KineticBlockEntity)be, (class_2350.class_2351)class_2350.class_2351.field_11052, (float)WalkwayRenderer.getAngleForTe((KineticBlockEntity)be, (class_2338)be.method_11016(), (class_2350.class_2351)class_2350.class_2351.field_11052), (int)light).renderInto(ms, cons);
            }
            class_2350 left = class_2350.method_10169((class_2350.class_2351)kinetic.getRotationAxis(state), (class_2350.class_2352)class_2350.class_2352.field_11056);
            class_2350 right = left.method_10153();
            if (kinetic.hasShaftTowards((class_4538)level, pos, state, left)) {
                WalkwayRenderer.renderRotatingBuffer((KineticBlockEntity)be, (SuperByteBuffer)this.getHalfShaftRotatedModel(be, state, left), (class_4587)ms, (class_4588)cons, (int)light);
            }
            if (kinetic.hasShaftTowards((class_4538)level, pos, state, right)) {
                WalkwayRenderer.renderRotatingBuffer((KineticBlockEntity)be, (SuperByteBuffer)this.getHalfShaftRotatedModel(be, state, right), (class_4587)ms, (class_4588)cons, (int)light);
            }
            boolean isTerminal = walkway.getWalkwaySlope(state) == WalkwaySlope.TERMINAL;
            boolean flag = facing == class_2350.field_11043 || facing == class_2350.field_11034;
            boolean isController = be.isController();
            class_2350 stepFacing = isTerminal && isController ? facing.method_10153() : facing;
            PartialModel stepModel = this.getStepModel(be);
            SuperByteBuffer buf = CachedBufferer.partialFacing((PartialModel)stepModel, (class_2680)state, (class_2350)stepFacing);
            if (!isTerminal || flag) {
                ((SuperByteBuffer)buf.light(light).translate(WalkwayRenderer.getStepOffset(be, stepFacing, class_2338.field_10980, false))).renderInto(ms, cons);
            }
            if (!isTerminal || !flag) {
                ((SuperByteBuffer)buf.light(light).translate(WalkwayRenderer.getStepOffset(be, stepFacing, class_2338.field_10980, true))).renderInto(ms, cons);
            }
        }
    }

    protected SuperByteBuffer getHalfShaftRotatedModel(KineticBlockEntity be, class_2680 state, class_2350 dir) {
        return CachedBufferer.partialFacing((PartialModel)AllPartialModels.SHAFT_HALF, (class_2680)state, (class_2350)dir);
    }

    protected PartialModel getStepModel(WalkwayBlockEntity be) {
        return WalkwayRenderer.baseGetStepModel(be);
    }

    public static Vector3f getStepOffset(WalkwayBlockEntity be, class_2350 facing, class_2338 pos, boolean frontStep) {
        class_2350 originalFacing = facing;
        class_2350.class_2352 axisDir = facing.method_10166() == class_2350.class_2351.field_11048 ? class_2350.class_2352.field_11060 : class_2350.class_2352.field_11056;
        facing = class_2350.method_10169((class_2350.class_2351)facing.method_10166(), (class_2350.class_2352)axisDir);
        class_2680 state = be.method_11010();
        WalkwayBlock walkway = (WalkwayBlock)state.method_26204();
        WalkwaySlope slope = walkway.getWalkwaySlope(state);
        Vector3f offset = new Vector3f((float)pos.method_10263(), (float)pos.method_10264() + 0.96875f, (float)pos.method_10260());
        float partialTick = be.getSpeed() == 0.0f ? 0.0f : AnimationTickHolder.getPartialTicks((class_1936)be.method_10997());
        float stepOffset = be.getVisualProgress() + (partialTick - 1.0f) * be.getWalkwayMovementSpeed();
        if (Math.abs(stepOffset) > 0.5f) {
            stepOffset = Math.signum(stepOffset) * (Math.abs(stepOffset) - 0.5f);
        }
        if (frontStep) {
            stepOffset += 0.5f;
        }
        offset.add((Vector3fc)facing.method_23955().mul(stepOffset -= 0.25f));
        if (slope == WalkwaySlope.TOP || slope == WalkwaySlope.MIDDLE || slope == WalkwaySlope.BOTTOM) {
            float f = stepOffset - 0.25f;
            if (originalFacing == class_2350.field_11043 || originalFacing == class_2350.field_11034) {
                f *= -1.0f;
                f -= 0.5f;
            }
            if (slope == WalkwaySlope.TOP) {
                f = Math.min(f, 0.0f);
            }
            if (slope == WalkwaySlope.BOTTOM) {
                f = Math.max(f, 0.0f);
            }
            offset.add(0.0f, f, 0.0f);
        }
        return offset;
    }

    public static PartialModel baseGetStepModel(WalkwayBlockEntity be) {
        class_2350 facing;
        class_1767 color = be.getColor();
        class_2680 state = be.method_11010();
        class_1937 level = be.method_10997();
        class_2338 pos = be.method_11016();
        boolean terminal = false;
        if (EscalatedBlocks.METAL_WALKWAY_TERMINAL.has(state)) {
            facing = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
            state = level.method_8320(pos.method_10093(facing));
            terminal = true;
        }
        if (EscalatedBlocks.METAL_NARROW_WALKWAY.has(state)) {
            return EscalatedBlockPartials.DYED_METAL_WALKWAY_STEPS.getOrDefault(color, EscalatedBlockPartials.METAL_WALKWAY_STEP);
        }
        if (EscalatedBlocks.METAL_WIDE_WALKWAY_SIDE.has(state)) {
            boolean left = (Boolean)state.method_11654((class_2769)WideWalkwaySideBlock.LEFT);
            return left ? EscalatedBlockPartials.DYED_METAL_WALKWAY_STEPS_RIGHT.getOrDefault(color, EscalatedBlockPartials.METAL_WALKWAY_STEP_RIGHT) : EscalatedBlockPartials.DYED_METAL_WALKWAY_STEPS_LEFT.getOrDefault(color, EscalatedBlockPartials.METAL_WALKWAY_STEP_LEFT);
        }
        if (EscalatedBlocks.METAL_WIDE_WALKWAY_CENTER.has(state)) {
            return EscalatedBlockPartials.DYED_METAL_WALKWAY_STEPS_CENTER.getOrDefault(color, EscalatedBlockPartials.METAL_WALKWAY_STEP_CENTER);
        }
        if (EscalatedBlocks.METAL_NARROW_ESCALATOR.has(state)) {
            return EscalatedBlockPartials.DYED_METAL_ESCALATOR_STEPS.getOrDefault(color, EscalatedBlockPartials.METAL_ESCALATOR_STEP);
        }
        if (EscalatedBlocks.METAL_WIDE_ESCALATOR_SIDE.has(state)) {
            boolean left = (Boolean)state.method_11654((class_2769)WideEscalatorSideBlock.LEFT);
            return left ? EscalatedBlockPartials.DYED_METAL_ESCALATOR_STEPS_RIGHT.getOrDefault(color, EscalatedBlockPartials.METAL_ESCALATOR_STEP_RIGHT) : EscalatedBlockPartials.DYED_METAL_ESCALATOR_STEPS_LEFT.getOrDefault(color, EscalatedBlockPartials.METAL_ESCALATOR_STEP_LEFT);
        }
        if (EscalatedBlocks.METAL_WIDE_ESCALATOR_CENTER.has(state)) {
            return EscalatedBlockPartials.DYED_METAL_ESCALATOR_STEPS_CENTER.getOrDefault(color, EscalatedBlockPartials.METAL_ESCALATOR_STEP_CENTER);
        }
        if (EscalatedBlocks.WOODEN_WALKWAY_TERMINAL.has(state)) {
            facing = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
            state = level.method_8320(pos.method_10093(facing));
            terminal = true;
        }
        if (EscalatedBlocks.WOODEN_NARROW_WALKWAY.has(state)) {
            return EscalatedBlockPartials.DYED_WOODEN_WALKWAY_STEPS.getOrDefault(color, EscalatedBlockPartials.WOODEN_WALKWAY_STEP);
        }
        if (EscalatedBlocks.WOODEN_WIDE_WALKWAY_SIDE.has(state)) {
            boolean left = (Boolean)state.method_11654((class_2769)WideWalkwaySideBlock.LEFT);
            return left ? EscalatedBlockPartials.DYED_WOODEN_WALKWAY_STEPS_RIGHT.getOrDefault(color, EscalatedBlockPartials.WOODEN_WALKWAY_STEP_RIGHT) : EscalatedBlockPartials.DYED_WOODEN_WALKWAY_STEPS_LEFT.getOrDefault(color, EscalatedBlockPartials.WOODEN_WALKWAY_STEP_LEFT);
        }
        if (EscalatedBlocks.WOODEN_WIDE_WALKWAY_CENTER.has(state)) {
            return EscalatedBlockPartials.DYED_WOODEN_WALKWAY_STEPS_CENTER.getOrDefault(color, EscalatedBlockPartials.WOODEN_WALKWAY_STEP_CENTER);
        }
        if (EscalatedBlocks.WOODEN_NARROW_ESCALATOR.has(state)) {
            return EscalatedBlockPartials.DYED_WOODEN_ESCALATOR_STEPS.getOrDefault(color, EscalatedBlockPartials.WOODEN_ESCALATOR_STEP);
        }
        if (EscalatedBlocks.WOODEN_WIDE_ESCALATOR_SIDE.has(state)) {
            boolean left = (Boolean)state.method_11654((class_2769)WideEscalatorSideBlock.LEFT);
            return left ? EscalatedBlockPartials.DYED_WOODEN_ESCALATOR_STEPS_RIGHT.getOrDefault(color, EscalatedBlockPartials.WOODEN_ESCALATOR_STEP_RIGHT) : EscalatedBlockPartials.DYED_WOODEN_ESCALATOR_STEPS_LEFT.getOrDefault(color, EscalatedBlockPartials.WOODEN_ESCALATOR_STEP_LEFT);
        }
        if (EscalatedBlocks.WOODEN_WIDE_ESCALATOR_CENTER.has(state)) {
            return EscalatedBlockPartials.DYED_WOODEN_ESCALATOR_STEPS_CENTER.getOrDefault(color, EscalatedBlockPartials.WOODEN_ESCALATOR_STEP_CENTER);
        }
        if (terminal && Backend.canUseInstancing((class_1937)level)) {
            be.lazyResetClientRender = true;
        }
        return EscalatedBlockPartials.DYED_METAL_WALKWAY_STEPS.get(class_1767.field_7964);
    }
}

