/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.tile;

import com.tom.storagemod.Config;
import com.tom.storagemod.Content;
import com.tom.storagemod.block.AbstractStorageTerminalBlock;
import com.tom.storagemod.gui.StorageTerminalMenu;
import com.tom.storagemod.item.WirelessTerminal;
import com.tom.storagemod.tile.InventoryCableConnectorBlockEntity;
import com.tom.storagemod.util.PlayerInvUtil;
import com.tom.storagemod.util.StoredItemStack;
import com.tom.storagemod.util.TickerUtil;
import com.tom.storagemod.util.Util;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2614;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3908;

public class StorageTerminalBlockEntity
extends class_2586
implements class_3908,
TickerUtil.TickableServer {
    private Storage<ItemVariant> itemHandler;
    private Map<StoredItemStack, Long> items = new HashMap<StoredItemStack, Long>();
    private int sort;
    private String lastSearch = "";
    private boolean updateItems;
    private int beaconLevel;

    public StorageTerminalBlockEntity(class_2338 pos, class_2680 state) {
        super(Content.terminalTile.get(), pos, state);
    }

    public StorageTerminalBlockEntity(class_2591<?> tileEntityTypeIn, class_2338 pos, class_2680 state) {
        super(tileEntityTypeIn, pos, state);
    }

    public class_1703 createMenu(int id, class_1661 plInv, class_1657 arg2) {
        return new StorageTerminalMenu(id, plInv, this);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"ts.storage_terminal");
    }

    public Map<StoredItemStack, Long> getStacks() {
        this.updateItems = true;
        return this.items;
    }

    public StoredItemStack pullStack(StoredItemStack stack, long max) {
        class_1799 st = stack.getStack();
        if (this.itemHandler == null) {
            return null;
        }
        try (Transaction transaction = Transaction.openOuter();){
            long ext = this.itemHandler.extract((Object)ItemVariant.of((class_1799)stack.getStack()), max, (TransactionContext)transaction);
            if (ext > 0L) {
                transaction.commit();
                StoredItemStack storedItemStack = new StoredItemStack(st, ext);
                return storedItemStack;
            }
        }
        return null;
    }

    public StoredItemStack pullStackFuzzy(StoredItemStack stack, long max) {
        return this.pullStack(stack, max);
    }

    public StoredItemStack pushStack(StoredItemStack stack) {
        if (stack != null && this.itemHandler != null) {
            try (Transaction transaction = Transaction.openOuter();){
                long ins = this.itemHandler.insert((Object)ItemVariant.of((class_1799)stack.getStack()), stack.getQuantity(), (TransactionContext)transaction);
                if (ins == 0L) {
                    StoredItemStack storedItemStack = stack;
                    return storedItemStack;
                }
                transaction.commit();
                if (ins == stack.getQuantity()) {
                    StoredItemStack storedItemStack = null;
                    return storedItemStack;
                }
                StoredItemStack storedItemStack = new StoredItemStack(stack.getStack(), stack.getQuantity() - ins);
                return storedItemStack;
            }
        }
        return stack;
    }

    public class_1799 pushStack(class_1799 itemstack) {
        StoredItemStack is = this.pushStack(new StoredItemStack(itemstack));
        return is == null ? class_1799.field_8037 : is.getActualStack();
    }

    public void pushOrDrop(class_1799 st) {
        if (st.method_7960()) {
            return;
        }
        StoredItemStack st0 = this.pushStack(new StoredItemStack(st));
        if (st0 != null) {
            this.dropItem(st0.getActualStack());
        }
    }

    public void dropItem(class_1799 stack) {
        class_1264.method_5449((class_1937)this.field_11863, (double)((float)this.field_11867.method_10263() + 0.5f), (double)((float)this.field_11867.method_10264() + 0.5f), (double)((float)this.field_11867.method_10260() + 0.5f), (class_1799)stack);
    }

    @Override
    public void updateServer() {
        if (this.updateItems) {
            class_1263 inv;
            class_2680 st = this.field_11863.method_8320(this.field_11867);
            class_2350 d = (class_2350)st.method_11654((class_2769)AbstractStorageTerminalBlock.FACING);
            AbstractStorageTerminalBlock.TerminalPos p2 = (AbstractStorageTerminalBlock.TerminalPos)((Object)st.method_11654(AbstractStorageTerminalBlock.TERMINAL_POS));
            if (p2 == AbstractStorageTerminalBlock.TerminalPos.UP) {
                d = class_2350.field_11036;
            }
            if (p2 == AbstractStorageTerminalBlock.TerminalPos.DOWN) {
                d = class_2350.field_11033;
            }
            this.items.clear();
            this.itemHandler = (Storage)ItemStorage.SIDED.find(this.field_11863, this.field_11867.method_10093(d), (Object)d.method_10153());
            if (this.itemHandler == null && (inv = class_2614.method_11250((class_1937)this.field_11863, (class_2338)this.field_11867.method_10093(d))) != null) {
                this.itemHandler = InventoryStorage.of((class_1263)inv, (class_2350)d.method_10153());
            }
            if (this.itemHandler != null) {
                Util.stream(this.itemHandler.iterator()).filter(s -> !s.isResourceBlank()).distinct().map(s -> new StoredItemStack(((ItemVariant)s.getResource()).toStack(), s.getAmount())).forEach(s -> this.items.merge((StoredItemStack)s, s.getQuantity(), (a, b) -> a + b));
            }
            this.updateItems = false;
        }
        if (this.field_11863.method_8510() % 40L == 5L) {
            this.beaconLevel = class_2338.method_29715((class_238)new class_238(this.field_11867).method_1014(8.0)).mapToInt(p -> {
                class_2680 st;
                if (this.field_11863.method_8477(p) && (st = this.field_11863.method_8320(p)).method_27852(class_2246.field_10327)) {
                    return InventoryCableConnectorBlockEntity.calcBeaconLevel(this.field_11863, p.method_10263(), p.method_10264(), p.method_10260());
                }
                return 0;
            }).max().orElse(0);
        }
    }

    public boolean canInteractWith(class_1657 player) {
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        int d = 4;
        int termReach = PlayerInvUtil.findItem(player, i -> i.method_7909() instanceof WirelessTerminal, 0, i -> ((WirelessTerminal)i.method_7909()).getRange(player, (class_1799)i));
        if (Config.get().wirelessTermBeaconLvl != -1 && this.beaconLevel >= Config.get().wirelessTermBeaconLvl && termReach > 0) {
            if (Config.get().wirelessTermBeaconLvlDim != -1 && this.beaconLevel >= Config.get().wirelessTermBeaconLvlDim) {
                return true;
            }
            return player.method_37908() == this.field_11863;
        }
        d = Math.max(d, termReach);
        return player.method_37908() == this.field_11863 && !(player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) > (double)(d * 2 * d * 2));
    }

    public int getSorting() {
        return this.sort;
    }

    public void setSorting(int newC) {
        this.sort = newC;
    }

    public void method_11007(class_2487 compound) {
        compound.method_10569("sort", this.sort);
    }

    public void method_11014(class_2487 compound) {
        this.sort = compound.method_10550("sort");
        super.method_11014(compound);
    }

    public String getLastSearch() {
        return this.lastSearch;
    }

    public void setLastSearch(String string) {
        this.lastSearch = string;
    }

    public int getBeaconLevel() {
        return this.beaconLevel;
    }
}

