/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.util;

import com.tom.storagemod.gui.StorageTerminalMenu;
import com.tom.storagemod.network.NetworkHandler;
import com.tom.storagemod.platform.Platform;
import com.tom.storagemod.util.StoredItemStack;
import com.tom.storagemod.util.TerminalCraftingFiller;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1662;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2359;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class TerminalSyncManager {
    private static final int MAX_PACKET_SIZE = 64000;
    private Object2IntMap<StoredItemStack> idMap = new Object2IntOpenHashMap();
    private Int2ObjectMap<StoredItemStack> idMap2 = new Int2ObjectArrayMap();
    private Object2LongMap<StoredItemStack> items = new Object2LongOpenHashMap();
    private Map<StoredItemStack, StoredItemStack> itemList = new HashMap<StoredItemStack, StoredItemStack>();
    private int lastId = 1;
    private class_2540 workBuf = new class_2540(Unpooled.buffer((int)64000, (int)128000));

    private void write(class_2540 buf, StoredItemStack stack) {
        class_1799 st = stack.getStack();
        class_1792 item = st.method_7909();
        class_2487 compoundtag = Platform.getSyncTag(st);
        byte flags = (byte)((stack.getQuantity() == 0L ? 1 : 0) | (compoundtag != null ? 2 : 0));
        boolean wr = true;
        int id = this.idMap.getInt((Object)stack);
        if (id != 0) {
            flags = (byte)(flags | 4);
            wr = false;
        }
        buf.writeByte((int)flags);
        buf.method_10804(this.idMap.computeIfAbsent((Object)stack, s -> {
            int i = this.lastId++;
            this.idMap2.put(i, (Object)((StoredItemStack)s));
            return i;
        }));
        if (wr) {
            buf.method_42065((class_2359)class_7923.field_41178, (Object)item);
        }
        if (stack.getQuantity() != 0L) {
            buf.method_10791(stack.getQuantity());
        }
        if (wr && compoundtag != null) {
            buf.method_10794(compoundtag);
        }
    }

    private void writeMiniStack(class_2540 buf, StoredItemStack stack) {
        int id = this.idMap.getInt((Object)stack);
        byte flags = (byte)((stack.getQuantity() == 0L ? 1 : 0) | 2);
        buf.writeByte((int)flags);
        buf.method_10804(id);
        buf.method_42065((class_2359)class_7923.field_41178, (Object)stack.getStack().method_7909());
        if (stack.getQuantity() != 0L) {
            buf.method_10791(stack.getQuantity());
        }
        class_2487 tag = new class_2487();
        class_2487 d = new class_2487();
        tag.method_10566("display", (class_2520)d);
        class_2499 lore = new class_2499();
        d.method_10566("Lore", (class_2520)lore);
        lore.add((Object)class_2519.method_23256((String)"{\"translate\":\"tooltip.toms_storage.nbt_overflow\",\"color\":\"red\"}"));
        tag.method_10569("uid", id);
        buf.method_10794(tag);
    }

    private StoredItemStack read(class_2540 buf) {
        byte flags = buf.readByte();
        int id = buf.method_10816();
        boolean rd = (flags & 4) == 0;
        StoredItemStack stack = rd ? new StoredItemStack(new class_1799((class_1935)buf.method_42064((class_2359)class_7923.field_41178))) : new StoredItemStack(((StoredItemStack)this.idMap2.get(id)).getStack());
        long count = (flags & 1) != 0 ? 0L : buf.method_10792();
        stack.setCount(count);
        if (rd && (flags & 2) != 0) {
            stack.getStack().method_7980(buf.method_10798());
        }
        this.idMap.put((Object)stack, id);
        this.idMap2.put(id, (Object)stack);
        return stack;
    }

    public void update(Map<StoredItemStack, Long> items, class_3222 player, Consumer<class_2487> extraSync) {
        ArrayList toWrite = new ArrayList();
        HashSet found = new HashSet();
        items.forEach((s, c) -> {
            long pc = this.items.getLong(s);
            if (pc != 0L) {
                found.add(s);
            }
            if (pc != c) {
                toWrite.add(new StoredItemStack(s.getStack(), (long)c));
            }
        });
        this.items.forEach((s, c) -> {
            if (!found.contains(s)) {
                toWrite.add(new StoredItemStack(s.getStack(), 0L));
            }
        });
        this.items.clear();
        this.items.putAll(items);
        if (!toWrite.isEmpty()) {
            this.workBuf.writerIndex(0);
            int j = 0;
            int i = 0;
            while (i < toWrite.size()) {
                StoredItemStack stack = (StoredItemStack)toWrite.get(i);
                int li = this.workBuf.writerIndex();
                try {
                    this.write(this.workBuf, stack);
                }
                catch (IndexOutOfBoundsException e) {
                    this.workBuf.writerIndex(li);
                    this.writeMiniStack(this.workBuf, stack);
                }
                int s2 = this.workBuf.writerIndex();
                if ((s2 > 64000 || j > 32000) && j > 1) {
                    class_2487 t = this.writeBuf("d", this.workBuf, li);
                    t.method_10575("l", (short)j);
                    NetworkHandler.sendTo(player, t);
                    j = 0;
                    this.workBuf.writerIndex(0);
                    if (s2 - li > 64000) {
                        this.writeMiniStack(this.workBuf, stack);
                    } else {
                        this.workBuf.writeBytes((ByteBuf)this.workBuf, li, s2 - li);
                    }
                }
                ++i;
                ++j;
            }
            if (j > 0 || extraSync != null) {
                class_2487 t;
                if (j > 0) {
                    t = this.writeBuf("d", this.workBuf, this.workBuf.writerIndex());
                    t.method_10575("l", (short)j);
                } else {
                    t = new class_2487();
                }
                if (extraSync != null) {
                    extraSync.accept(t);
                }
                NetworkHandler.sendTo(player, t);
            }
        } else if (extraSync != null) {
            class_2487 t = new class_2487();
            extraSync.accept(t);
            NetworkHandler.sendTo(player, t);
        }
    }

    public boolean receiveUpdate(class_2487 tag) {
        if (tag.method_10545("d")) {
            class_2540 buf = new class_2540(Unpooled.wrappedBuffer((byte[])tag.method_10547("d")));
            ArrayList<StoredItemStack> in = new ArrayList<StoredItemStack>();
            int len = tag.method_10568("l");
            for (int i = 0; i < len; ++i) {
                in.add(this.read(buf));
            }
            in.forEach(s -> {
                if (s.getQuantity() == 0L) {
                    this.itemList.remove(s);
                } else {
                    this.itemList.put((StoredItemStack)s, (StoredItemStack)s);
                }
            });
            return true;
        }
        return false;
    }

    public void sendInteract(StoredItemStack intStack, StorageTerminalMenu.SlotAction action, boolean mod) {
        int flags;
        class_2540 buf = new class_2540(Unpooled.buffer());
        int n = flags = mod ? 1 : 0;
        if (intStack == null) {
            buf.writeByte(flags | 2);
        } else {
            buf.writeByte(flags);
            buf.method_10804(this.idMap.getInt((Object)intStack));
            buf.method_10791(intStack.getQuantity());
        }
        buf.method_10817((Enum)action);
        NetworkHandler.sendDataToServer(this.writeBuf("a", buf, buf.writerIndex()));
    }

    private class_2487 writeBuf(String id, class_2540 buf, int len) {
        byte[] data = new byte[len];
        buf.getBytes(0, data);
        class_2487 tag = new class_2487();
        tag.method_10570(id, data);
        return tag;
    }

    public void receiveInteract(class_2487 tag, InteractHandler handler) {
        if (tag.method_10545("a")) {
            StoredItemStack stack;
            class_2540 buf = new class_2540(Unpooled.wrappedBuffer((byte[])tag.method_10547("a")));
            byte flags = buf.readByte();
            if ((flags & 2) != 0) {
                stack = null;
            } else {
                stack = new StoredItemStack(((StoredItemStack)this.idMap2.get(buf.method_10816())).getStack());
                long count = buf.method_10792();
                stack.setCount(count);
            }
            handler.onInteract(stack, (StorageTerminalMenu.SlotAction)buf.method_10818(StorageTerminalMenu.SlotAction.class), (flags & 1) != 0);
        }
    }

    public List<StoredItemStack> getAsList() {
        return new ArrayList<StoredItemStack>(this.itemList.values());
    }

    public void fillStackedContents(class_1662 stc) {
        this.items.forEach((s, c) -> {
            class_1799 st = s.getActualStack();
            st.method_7939(c.intValue());
            stc.method_7404(st);
        });
    }

    public long getAmount(StoredItemStack stack) {
        StoredItemStack s = this.itemList.get(stack);
        return s != null ? s.getQuantity() : 0L;
    }

    public void fillCraftingFiller(TerminalCraftingFiller terminalCraftingFiller) {
        this.items.forEach((s, c) -> {
            class_1799 st = s.getActualStack();
            st.method_7939(c.intValue());
            terminalCraftingFiller.accountStack(st);
        });
    }

    public static interface InteractHandler {
        public void onInteract(StoredItemStack var1, StorageTerminalMenu.SlotAction var2, boolean var3);
    }
}

