/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor;

import com.google.common.collect.ImmutableMap;
import com.mojang.authlib.GameProfile;
import com.railwayteam.railways.content.conductor.ClientHandler;
import com.railwayteam.railways.content.conductor.ConductorCapItem;
import com.railwayteam.railways.content.conductor.ConductorPossessionController;
import com.railwayteam.railways.content.conductor.toolbox.MountedToolbox;
import com.railwayteam.railways.content.conductor.vent.VentBlock;
import com.railwayteam.railways.content.switches.TrackSwitchBlock;
import com.railwayteam.railways.multiloader.S2CPacket;
import com.railwayteam.railways.registry.CREntities;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.registry.CRTags;
import com.railwayteam.railways.util.EntityUtils;
import com.railwayteam.railways.util.ItemUtils;
import com.railwayteam.railways.util.Utils;
import com.railwayteam.railways.util.packet.CameraMovePacket;
import com.railwayteam.railways.util.packet.SetCameraViewPacket;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.equipment.toolbox.ToolboxBlock;
import com.simibubi.create.content.redstone.link.IRedstoneLinkable;
import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.simibubi.create.content.redstone.link.controller.LinkedControllerItem;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.ScheduleRuntime;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.WorldAttached;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_14;
import net.minecraft.class_1427;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2401;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2828;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4076;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5568;
import net.minecraft.class_591;
import org.jetbrains.annotations.NotNull;

public class ConductorEntity
extends class_1427 {
    public static final GameProfile FAKE_PLAYER_PROFILE = new GameProfile(UUID.fromString("B0FADEE5-4411-3475-ADD0-C4EA7E30D050"), "[Conductor]");
    private final FrequencyHolder frequencies = new FrequencyHolder();
    public static final WorldAttached<Set<ConductorEntity>> WITH_TOOLBOXES = new WorldAttached(w -> new HashSet());
    public static final class_2940<Byte> COLOR = class_2945.method_12791(ConductorEntity.class, (class_2941)class_2943.field_13319);
    public static final class_2940<class_2338> BLOCK = class_2945.method_12791(ConductorEntity.class, (class_2941)class_2943.field_13324);
    public static final class_2940<Integer> JOB = class_2945.method_12791(ConductorEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> HOLDING_SCHEDULES = class_2945.method_12791(ConductorEntity.class, (class_2941)class_2943.field_13323);
    public static final Map<String, Couple<class_2940<class_1799>>> FREQUENCY_DATA = new HashMap<String, Couple<class_2940<class_1799>>>();
    private static final class_2382 REACH;
    private class_3222 fakePlayer = null;
    MountedToolbox toolbox = null;
    private List<class_1799> heldSchedules;
    public double firstGoodX;
    public double firstGoodY;
    public double firstGoodZ;
    public double lastGoodX;
    public double lastGoodY;
    public double lastGoodZ;
    public int receivedMovePacketCount;
    public int knownMovePacketCount;
    public double xLast;
    public double yLast;
    public double zLast;
    public double xRotLast;
    public double yRotLast;
    public int ventCooldown = 0;
    public static final List<class_1657> RECENTLY_DISMOUNTED_PLAYERS;
    @NotNull
    private WeakReference<class_3222> currentlyViewing = new WeakReference<Object>(null);
    private int initialChunkLoadingDistance = 0;
    private boolean hasSentChunks = false;
    public class_4076 oldSectionPos = null;
    public float oBob;
    public float bob;
    @Environment(value=EnvType.CLIENT)
    public class_591<?> visualBaseModel;
    @Environment(value=EnvType.CLIENT)
    public class_1657 visualBaseEntity;
    private boolean rotateAnyway = false;
    private Float flyingSpeedOverride = null;
    protected FrequencyListener forwardListener;
    protected FrequencyListener backwardListener;
    protected FrequencyListener leftListener;
    protected FrequencyListener rightListener;
    protected FrequencyListener jumpListener;
    protected FrequencyListener sneakListener;

    public static boolean isPlayerDisguised(class_1657 player) {
        if (player.method_31548() == null) {
            return false;
        }
        class_1799 headStack = player.method_6118(class_1304.field_6169);
        if (headStack.method_7960()) {
            return false;
        }
        if (!CRTags.AllItemTags.CONDUCTOR_CAPS.matches(headStack)) {
            return false;
        }
        String hoverName = headStack.method_7964().getString();
        return hoverName.startsWith("[sus]") || hoverName.equals("sus");
    }

    public static boolean canSpyInteract(class_2680 blockState) {
        class_2248 block = blockState.method_26204();
        return blockState.method_26164(class_3481.field_15493) || blockState.method_26164(class_3481.field_15487) || block instanceof class_2401 || block instanceof VentBlock || CRTags.AllBlockTags.CONDUCTOR_SPY_USABLE.matches(blockState);
    }

    public class_1799 getSecondaryHeadStack() {
        return class_1799.field_8037;
    }

    private void resetPosition() {
        this.firstGoodX = this.lastGoodX = this.method_23317();
        this.firstGoodY = this.lastGoodY = this.method_23318();
        this.firstGoodZ = this.lastGoodZ = this.method_23321();
        this.knownMovePacketCount = this.receivedMovePacketCount;
    }

    public void doCheckFallDamage(double y, boolean onGround) {
        if (this.method_33724()) {
            return;
        }
        class_2338 blockPos = this.method_23312();
        super.method_5623(y, onGround, this.field_6002.method_8320(blockPos), blockPos);
    }

    public void method_6043() {
        super.method_6043();
    }

    public void teleportToForce(double x, double y, double z) {
        class_3222 player;
        this.method_5641(x, y, z, this.method_36454(), this.method_36455());
        this.method_24204().forEach(entity -> {
            for (class_1297 entity2 : entity.method_5685()) {
                entity.method_24201(entity2);
            }
        });
        class_1937 class_19372 = this.field_6002;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_14178().method_17297(class_3230.field_19347, new class_1923(this.method_24515()), 5, (Object)this.method_5628());
        }
        this.firstGoodX = x;
        this.firstGoodY = y;
        this.firstGoodZ = z;
        this.lastGoodX = x;
        this.lastGoodY = y;
        this.lastGoodZ = z;
        if (this.isPossessed() && (player = (class_3222)this.currentlyViewing.get()) != null) {
            CRPackets.PACKETS.sendTo(player, (S2CPacket)new CameraMovePacket(this, new class_2828.class_2830(x, y, z, this.method_36454(), this.method_36455(), this.method_24828())));
        }
    }

    public void setChunkLoadingDistance(int chunkLoadingDistance) {
        this.initialChunkLoadingDistance = chunkLoadingDistance;
    }

    public boolean hasSentChunks() {
        return this.hasSentChunks;
    }

    public void setHasSentChunks(boolean hasSentChunks) {
        this.hasSentChunks = hasSentChunks;
    }

    public static boolean hasRecentlyDismounted(class_1657 player) {
        return RECENTLY_DISMOUNTED_PLAYERS.remove(player);
    }

    public boolean startViewing(class_3222 player) {
        class_3222 current = (class_3222)this.currentlyViewing.get();
        if (current != null && current.method_14242() == this && current.method_5805() && current != player) {
            return false;
        }
        class_3218 serverLevel = player.method_51469();
        if (serverLevel != this.field_6002) {
            return false;
        }
        this.currentlyViewing = new WeakReference<class_3222>(player);
        this.oldSectionPos = null;
        class_4076 chunkPos = class_4076.method_18682((class_2338)this.method_24515());
        int viewDistance = player.field_13995.method_3760().method_14568();
        class_1297 class_12972 = player.method_14242();
        if (class_12972 instanceof ConductorEntity) {
            ConductorEntity conductor = (ConductorEntity)class_12972;
            conductor.stopViewing(player);
        }
        this.setChunkLoadingDistance(viewDistance);
        player.field_13984 = this;
        CRPackets.PACKETS.sendTo(player, (S2CPacket)new SetCameraViewPacket((class_1297)this));
        this.resetPosition();
        return true;
    }

    public void stopViewing(class_3222 player) {
        if (!this.field_6002.field_9236) {
            this.currentlyViewing.clear();
            player.field_13984 = player;
            CRPackets.PACKETS.sendTo(player, (S2CPacket)new SetCameraViewPacket((class_1297)player));
            RECENTLY_DISMOUNTED_PLAYERS.add((class_1657)player);
        }
    }

    public void onSpyInteract(class_2338 pos) {
        class_2680 state;
        if (this.canReach((class_2382)pos) && ConductorEntity.canSpyInteract(state = this.field_6002.method_8320(pos)) && this.fakePlayer != null) {
            boolean canUse;
            class_3959 context = new class_3959(this.method_33571(), new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5), class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)this.fakePlayer);
            class_3965 hitResult = this.field_6002.method_17742(context);
            if (!pos.equals((Object)hitResult.method_17777())) {
                return;
            }
            boolean bl = canUse = state.method_26218((class_1922)this.field_6002, pos).method_1110() || EntityUtils.handleUseEvent((class_1657)this.fakePlayer, class_1268.field_5808, hitResult);
            if (canUse) {
                class_2248 class_22482 = state.method_26204();
                if (class_22482 instanceof VentBlock) {
                    VentBlock ventBlock = (VentBlock)class_22482;
                    ventBlock.teleportConductor(this.field_6002, pos, (class_1297)this, hitResult.method_17780().method_10153());
                } else {
                    state.method_26174(this.field_6002, (class_1657)this.fakePlayer, class_1268.field_5808, hitResult);
                }
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public float method_5695(float partialTicks) {
        if (ClientHandler.isPossessed(this)) {
            return this.method_36455();
        }
        return super.method_5695(partialTicks);
    }

    public boolean method_18276() {
        return this.field_6002.field_9236 ? (this.visualBaseEntity != null ? this.visualBaseEntity.method_18276() : super.method_18276()) : super.method_18276();
    }

    @Environment(value=EnvType.CLIENT)
    public void method_5729(int flag, boolean set) {
        super.method_5729(flag, set);
    }

    public boolean isPossessed() {
        return this.field_6002.field_9236 ? ClientHandler.isPossessed(this) : this.currentlyViewing.get() != null;
    }

    public boolean isPossessedAndClient() {
        return this.field_6002.field_9236 && this.isPossessed();
    }

    public void turnView(double yRot, double xRot) {
        float f = (float)xRot * 0.15f;
        float g = (float)yRot * 0.15f;
        this.rotateAnyway = true;
        this.method_36457(this.method_36455() + f);
        this.method_36456(this.method_36454() + g);
        this.rotateAnyway = true;
        this.method_36457(class_3532.method_15363((float)this.method_36455(), (float)-90.0f, (float)90.0f));
        this.field_6004 += f;
        this.field_5982 += g;
        this.field_6004 = class_3532.method_15363((float)this.field_6004, (float)-90.0f, (float)90.0f);
        if (this.method_5854() != null) {
            this.method_5854().method_5644((class_1297)this);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public float method_5705(float partialTick) {
        return this.method_5765() || !this.isPossessed() ? super.method_5705(partialTick) : this.method_36454();
    }

    private boolean consumeRotateAnyway() {
        if (this.rotateAnyway) {
            this.rotateAnyway = false;
            return true;
        }
        return false;
    }

    public void method_36457(float xRot) {
        if (this.isPossessedAndClient() && !this.consumeRotateAnyway()) {
            return;
        }
        super.method_36457(xRot);
    }

    protected boolean method_39759(@NotNull class_243 deltaMovement) {
        if (!this.isPossessedAndClient()) {
            return super.method_39759(deltaMovement);
        }
        float f = this.method_36454() * ((float)Math.PI / 180);
        double d0 = class_3532.method_15374((float)f);
        double d1 = class_3532.method_15362((float)f);
        double d2 = (double)this.field_6212 * d1 - (double)this.field_6250 * d0;
        double d3 = (double)this.field_6250 * d1 + (double)this.field_6212 * d0;
        double d4 = class_3532.method_33723((double)d2) + class_3532.method_33723((double)d3);
        double d5 = class_3532.method_33723((double)deltaMovement.field_1352) + class_3532.method_33723((double)deltaMovement.field_1350);
        if (!(d4 < (double)1.0E-5f) && !(d5 < (double)1.0E-5f)) {
            double d6 = d2 * deltaMovement.field_1352 + d3 * deltaMovement.field_1350;
            double d7 = Math.acos(d6 / Math.sqrt(d4 * d5));
            return d7 < 0.13962633907794952;
        }
        return false;
    }

    public void updatePossessionInputs() {
        if (this.isPossessedAndClient()) {
            this._updatePossessionInputs();
        }
    }

    private static float calculateImpulse(boolean input, boolean otherInput) {
        if (input == otherInput) {
            return 0.0f;
        }
        return input ? 1.0f : -1.0f;
    }

    @Environment(value=EnvType.CLIENT)
    private void _updatePossessionInputs() {
        this.method_6125((float)this.method_26825(class_5134.field_23719));
        this.field_6250 = ConductorEntity.calculateImpulse(ConductorPossessionController.wasUpPressed(), ConductorPossessionController.wasDownPressed());
        this.field_6212 = ConductorEntity.calculateImpulse(ConductorPossessionController.wasLeftPressed(), ConductorPossessionController.wasRightPressed());
        if (!ConductorPossessionController.wasSprintPressed()) {
            this.field_6250 *= 0.3f;
            this.field_6212 *= 0.3f;
        }
        this.field_6282 = ConductorPossessionController.wasJumpPressed();
        this.flyingSpeedOverride = Float.valueOf(0.2f);
        if (ConductorPossessionController.wasSprintPressed()) {
            this.flyingSpeedOverride = Float.valueOf(this.flyingSpeedOverride.floatValue() + 0.006f);
        }
    }

    protected float method_49484() {
        return this.flyingSpeedOverride == null ? super.method_49484() : this.flyingSpeedOverride.floatValue();
    }

    public void method_5697(@NotNull class_1297 entity) {
        if (ConductorPossessionController.getPossessingConductor(entity) == this) {
            return;
        }
        super.method_5697(entity);
    }

    public boolean method_5810() {
        return super.method_5810() && !this.isPossessed();
    }

    public boolean method_5787() {
        return super.method_5787() || this.isPossessedAndClient();
    }

    private boolean suffocatesAt(class_2338 pos) {
        class_238 aabb = this.method_5829();
        class_238 aabb1 = new class_238((double)pos.method_10263(), aabb.field_1322, (double)pos.method_10260(), (double)pos.method_10263() + 1.0, aabb.field_1325, (double)pos.method_10260() + 1.0).method_1011(1.0E-7);
        return this.field_6002.method_39454((class_1297)this, aabb1);
    }

    private void moveTowardsClosestSpace(double x, double z) {
        class_2338 blockpos = class_2338.method_49637((double)x, (double)this.method_23318(), (double)z);
        if (this.suffocatesAt(blockpos)) {
            double d0 = x - (double)blockpos.method_10263();
            double d1 = z - (double)blockpos.method_10260();
            class_2350 direction = null;
            double d2 = Double.MAX_VALUE;
            class_2350[] adirection = new class_2350[]{class_2350.field_11039, class_2350.field_11034, class_2350.field_11043, class_2350.field_11035};
            for (class_2350 direction1 : adirection) {
                double d3 = direction1.method_10166().method_10172(d0, 0.0, d1);
                double d4 = direction1.method_10171() == class_2350.class_2352.field_11056 ? 1.0 - d3 : d3;
                double d = d4;
                if (!(d4 < d2) || this.suffocatesAt(blockpos.method_10093(direction1))) continue;
                d2 = d4;
                direction = direction1;
            }
            if (direction != null) {
                class_243 vec3 = this.method_18798();
                if (direction.method_10166() == class_2350.class_2351.field_11048) {
                    this.method_18800(0.1 * (double)direction.method_10148(), vec3.field_1351, vec3.field_1350);
                } else {
                    this.method_18800(vec3.field_1352, vec3.field_1351, 0.1 * (double)direction.method_10165());
                }
            }
        }
    }

    public void method_6007() {
        if (this.isPossessedAndClient()) {
            this.oBob = this.bob;
            this.field_6241 = this.method_36454();
            if (!this.field_5960) {
                this.moveTowardsClosestSpace(this.method_23317() - (double)this.method_17681() * 0.35, this.method_23321() + (double)this.method_17681() * 0.35);
                this.moveTowardsClosestSpace(this.method_23317() - (double)this.method_17681() * 0.35, this.method_23321() - (double)this.method_17681() * 0.35);
                this.moveTowardsClosestSpace(this.method_23317() + (double)this.method_17681() * 0.35, this.method_23321() - (double)this.method_17681() * 0.35);
                this.moveTowardsClosestSpace(this.method_23317() + (double)this.method_17681() * 0.35, this.method_23321() + (double)this.method_17681() * 0.35);
            }
        }
        super.method_6007();
        if (this.isPossessedAndClient()) {
            float f = !this.method_24828() || this.method_29504() || this.method_5681() ? 0.0f : Math.min(0.1f, (float)this.method_18798().method_37267());
            this.bob += (f - this.bob) * 0.4f;
        }
    }

    protected void updateFrequencyListeners() {
        this.forwardListener = new FrequencyListener("forward");
        this.backwardListener = new FrequencyListener("backward");
        this.leftListener = new FrequencyListener("left");
        this.rightListener = new FrequencyListener("right");
        this.jumpListener = new FrequencyListener("jump");
        this.sneakListener = new FrequencyListener("sneak");
    }

    public int getForwardSignalStrength() {
        if (this.forwardListener == null) {
            return 0;
        }
        return this.forwardListener.receivedStrength;
    }

    private List<class_1799> getHeldSchedules() {
        if (this.heldSchedules == null) {
            this.heldSchedules = new ArrayList<class_1799>();
        }
        return this.heldSchedules;
    }

    public ConductorEntity(class_1299<? extends class_1427> type, class_1937 level) {
        super(type, level);
        this.method_49477(0.5f);
    }

    public boolean isHoldingSchedules() {
        return !this.getHeldSchedules().isEmpty();
    }

    public boolean isHoldingSchedulesClient() {
        return (Boolean)this.field_6011.method_12789(HOLDING_SCHEDULES);
    }

    public void addSchedule(class_1799 stack) {
        if (stack.method_7960()) {
            return;
        }
        this.getHeldSchedules().add(stack.method_7972());
        this.field_6011.method_12778(HOLDING_SCHEDULES, (Object)true);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(COLOR, (Object)ConductorEntity.idFrom(ConductorEntity.defaultColor()));
        this.field_6011.method_12784(BLOCK, (Object)this.method_24515());
        this.field_6011.method_12784(JOB, (Object)Job.DEFAULT.ordinal());
        this.field_6011.method_12784(HOLDING_SCHEDULES, (Object)this.isHoldingSchedules());
        for (Map.Entry<String, Couple<class_2940<class_1799>>> entry : FREQUENCY_DATA.entrySet()) {
            for (boolean first : Iterate.trueAndFalse) {
                this.field_6011.method_12784((class_2940)entry.getValue().get(first), (Object)class_1799.field_8037);
            }
        }
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(2, (class_1352)new ConductorLookedAtGoal(this));
        this.field_6201.method_6277(1, (class_1352)new ConductorPonderBlockGoal(this));
        this.field_6201.method_6277(1, (class_1352)new FollowToolboxPlayerGoal(this, 1.25));
        this.field_6201.method_6277(1, (class_1352)new RemoteControlGoal(this, 1.25));
        this.field_6201.method_6277(0, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f){

            public boolean method_6264() {
                return super.method_6264() && !ConductorEntity.this.isPossessed();
            }

            public boolean method_6266() {
                return super.method_6266() && !ConductorEntity.this.isPossessed();
            }
        });
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_23718, 1.0).method_26868(class_5134.field_23724, 8.0).method_26868(class_5134.field_23725, 8.0);
    }

    public void method_5650(@NotNull class_1297.class_5529 reason) {
        super.method_5650(reason);
        ((Set)WITH_TOOLBOXES.get((class_1936)this.field_6002)).remove((Object)this);
    }

    public void method_36209() {
        ((Set)WITH_TOOLBOXES.get((class_1936)this.field_6002)).remove((Object)this);
    }

    public boolean method_5643(@NotNull class_1282 pSource, float pAmount) {
        class_1309 living;
        if (this.method_5668() instanceof CarriageContraptionEntity) {
            return false;
        }
        class_1297 class_12972 = pSource.method_5529();
        if (class_12972 instanceof class_1309 && (living = (class_1309)class_12972).method_6047().method_31574((class_1792)AllItems.WRENCH.get())) {
            pAmount = 10.0f;
        }
        return super.method_5643(pSource, pAmount);
    }

    protected int method_6130(int pAir) {
        return pAir;
    }

    protected float method_18394(@NotNull class_4050 pPose, @NotNull class_4048 pDimensions) {
        return pDimensions.field_18068 * 0.76f;
    }

    public boolean canReach(class_2382 pos) {
        return pos.method_19770((class_2374)this.method_19538()) <= REACH.method_10262(class_2382.field_11176);
    }

    protected boolean isToolbox(class_1799 stack) {
        class_1747 blockItem;
        class_1792 class_17922 = stack.method_7909();
        return class_17922 instanceof class_1747 && (blockItem = (class_1747)class_17922).method_7711() instanceof ToolboxBlock;
    }

    public boolean isCarryingToolbox() {
        return this.toolbox != null;
    }

    public class_1799 getToolboxDisplayStack() {
        if (this.isCarryingToolbox()) {
            return this.toolbox.getDisplayStack();
        }
        return class_1799.field_8037;
    }

    protected void setToolbox(@Nullable MountedToolbox toolbox) {
        this.toolbox = toolbox;
        if (toolbox != null) {
            ((Set)WITH_TOOLBOXES.get((class_1936)this.field_6002)).add(this);
        } else {
            ((Set)WITH_TOOLBOXES.get((class_1936)this.field_6002)).remove((Object)this);
        }
    }

    @Nullable
    public MountedToolbox getToolbox() {
        return this.toolbox;
    }

    @NotNull
    public MountedToolbox getOrCreateToolboxHolder() {
        if (!this.isCarryingToolbox()) {
            this.setToolbox(new MountedToolbox(this, class_1767.field_7957));
        }
        return this.toolbox;
    }

    public void equipToolbox(class_1799 stack) {
        class_1747 blockItem;
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1747 && (class_17922 = (blockItem = (class_1747)class_17922).method_7711()) instanceof ToolboxBlock) {
            ToolboxBlock toolbox = (ToolboxBlock)class_17922;
            this.setToolbox(new MountedToolbox(this, toolbox.getColor()));
            this.toolbox.readFromItem(stack);
            this.toolbox.sendData();
            this.setJob(Job.TOOLBOX_CARRIER);
        }
    }

    public void setJob(Job job) {
        this.method_5841().method_12778(JOB, (Object)job.ordinal());
    }

    public Job getJob() {
        return Job.values()[(Integer)this.method_5841().method_12789(JOB)];
    }

    public void method_5837(@NotNull class_3222 pServerPlayer) {
        super.method_5837(pServerPlayer);
        if (this.toolbox != null) {
            this.toolbox.sendData();
        }
    }

    public class_1799 unequipToolbox() {
        this.setJob(Job.DEFAULT);
        if (this.field_6002.field_9236 || this.toolbox == null) {
            if (this.toolbox != null) {
                this.toolbox.method_11012();
            }
            this.setToolbox(null);
            return class_1799.field_8037;
        }
        this.toolbox.unequipTracked();
        class_1799 itemStack = this.toolbox.getCloneItemStack();
        this.toolbox.method_11012();
        this.setToolbox(null);
        return itemStack;
    }

    protected void openToolbox(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            MountedToolbox.openMenu(serverPlayer, this.toolbox);
        }
    }

    @NotNull
    protected class_1269 method_5992(class_1657 player, @NotNull class_1268 hand) {
        class_1792 class_17922 = player.method_5998(hand).method_7909();
        if (class_17922 instanceof class_1769) {
            class_1769 di = (class_1769)class_17922;
            this.setColor(di.method_7802());
            if (!player.method_7337()) {
                player.method_5998(hand).method_7934(1);
            }
            return class_1269.field_5812;
        }
        if (player.method_5998(hand).method_7909().equals(AllBlocks.ANDESITE_CASING.asStack().method_7909())) {
            if (this.method_6032() < this.method_6063()) {
                this.method_6033(this.method_6063());
                if (!player.method_7337()) {
                    player.method_5998(hand).method_7934(1);
                }
                return class_1269.field_5812;
            }
        } else {
            if (!this.isCarryingToolbox() && this.isToolbox(player.method_5998(hand)) && this.getJob() == Job.DEFAULT) {
                this.equipToolbox(player.method_5998(hand));
                player.method_5998(hand).method_7934(1);
                return class_1269.field_5812;
            }
            if (this.isCarryingToolbox()) {
                if (player.method_5715() && player.method_5998(hand).method_7960()) {
                    player.method_6122(hand, this.unequipToolbox());
                } else if (!this.field_6002.field_9236) {
                    this.openToolbox(player);
                }
                return class_1269.field_5812;
            }
            if (player.method_5998(hand).method_7960() && !this.getHeldSchedules().isEmpty()) {
                for (class_1799 item : this.heldSchedules) {
                    if (player.method_7270(item)) continue;
                    player.method_7328(item, false);
                }
                this.field_6011.method_12778(HOLDING_SCHEDULES, (Object)false);
                this.getHeldSchedules().clear();
            } else {
                if (this.getJob() == Job.DEFAULT && AllBlocks.REDSTONE_LINK.isIn(player.method_5998(hand))) {
                    this.setJob(Job.REMOTE_CONTROL);
                    player.method_5998(hand).method_7934(1);
                    return class_1269.field_5812;
                }
                if (this.getJob() == Job.REMOTE_CONTROL) {
                    if (player.method_5715() && player.method_5998(hand).method_7960()) {
                        player.method_6122(hand, AllBlocks.REDSTONE_LINK.asStack());
                        this.setJob(Job.DEFAULT);
                    } else if (player.method_5998(hand).method_7909() instanceof LinkedControllerItem) {
                        int i = 0;
                        for (Consumer<Optional<Couple<RedstoneLinkNetworkHandler.Frequency>>> freq : this.frequencies.settersInOrder()) {
                            freq.accept(Optional.of(LinkedControllerItem.toFrequency((class_1799)player.method_5998(hand), (int)i)));
                            ++i;
                        }
                        this.updateFrequencyListeners();
                    }
                } else {
                    if (this.getJob() == Job.DEFAULT && AllItems.GOGGLES.isIn(player.method_5998(hand))) {
                        this.setJob(Job.SPY);
                        player.method_5998(hand).method_7934(1);
                        return class_1269.field_5812;
                    }
                    if (this.getJob() == Job.SPY && player.method_5715() && player.method_5998(hand).method_7960()) {
                        player.method_6122(hand, AllItems.GOGGLES.asStack());
                        this.setJob(Job.DEFAULT);
                    }
                }
            }
        }
        return super.method_5992(player, hand);
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return class_3417.field_21919;
    }

    @Nullable
    protected class_3414 method_6002() {
        return AllSoundEvents.CRUSHING_1.getMainEvent();
    }

    public void method_5773() {
        class_1937 class_19372;
        this.resetPosition();
        class_4076 sectionPos = class_4076.method_42614((class_5568)this);
        if (!sectionPos.equals((Object)this.oldSectionPos)) {
            this.setHasSentChunks(false);
        }
        if (this.field_6002.field_9236) {
            ConductorPossessionController.tryUpdatePossession(this);
            this.updatePossessionInputs();
        }
        super.method_5773();
        if (this.ventCooldown > 0) {
            --this.ventCooldown;
        }
        if ((class_19372 = this.field_6002) instanceof class_3218) {
            Object t;
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.fakePlayer == null) {
                this.fakePlayer = EntityUtils.createConductorFakePlayer(serverLevel, this);
            }
            if ((t = this.currentlyViewing.get()) instanceof class_3222) {
                class_3222 player = (class_3222)t;
                class_4076 chunkPos = class_4076.method_18682((class_2338)this.method_24515());
                int viewDistance = player.field_13995.method_3760().method_14568();
                for (int x = chunkPos.method_10263() - viewDistance; x <= chunkPos.method_10263() + viewDistance; ++x) {
                    for (int z = chunkPos.method_10260() - viewDistance; z <= chunkPos.method_10260() + viewDistance; ++z) {
                        serverLevel.method_14178().method_17297(class_3230.field_14031, new class_1923(x, z), 3, (Object)new class_1923(x, z));
                    }
                }
            }
        }
        if (this.toolbox != null) {
            this.toolbox.tick();
        }
    }

    public static ConductorEntity spawn(class_1937 level, class_2338 pos, class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof ConductorCapItem)) {
            return null;
        }
        ConductorCapItem cap = (ConductorCapItem)class_17922;
        ConductorEntity result = new ConductorEntity((class_1299<? extends class_1427>)((class_1299)CREntities.CONDUCTOR.get()), level);
        result.method_5814((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
        result.setColor(cap.color);
        result.method_24523(stack);
        level.method_8649((class_1297)result);
        return result;
    }

    public boolean isInMinecart() {
        return this.method_5854() instanceof class_1688;
    }

    public static class_1767 defaultColor() {
        return class_1767.field_7966;
    }

    public void setColor(class_1767 color) {
        this.method_5841().method_12778(COLOR, (Object)ConductorEntity.idFrom(color));
    }

    public class_1767 getColor() {
        return ConductorEntity.colorFrom((Byte)this.field_6011.method_12789(COLOR));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isCorrectEngineerCap(class_1799 hat) {
        if (hat.method_7960()) {
            return true;
        }
        class_1792 class_17922 = hat.method_7909();
        if (!(class_17922 instanceof ConductorCapItem)) return false;
        ConductorCapItem cap = (ConductorCapItem)class_17922;
        if (cap.color != this.getColor()) return false;
        return true;
    }

    boolean isLookingAtMe(class_1657 player) {
        if (player.method_7325()) {
            return false;
        }
        boolean looking = false;
        class_1799 helmet = player.method_6118(class_1304.field_6169);
        if (this.isCorrectEngineerCap(helmet) || !ItemUtils.blocksEndermanView(helmet, player, null)) {
            class_243 headLine;
            class_243 playerView = player.method_5828(1.0f).method_1029();
            double angle = playerView.method_1026(headLine = this.method_33571().method_1020(player.method_33571()).method_1029());
            looking = angle > 0.983 && player.method_6057((class_1297)this);
        }
        return looking;
    }

    public static class_1767 colorFrom(byte b) {
        if (b >= 16) {
            return null;
        }
        return class_1767.method_7791((int)b);
    }

    public static byte idFrom(class_1767 color) {
        int c = color.method_7789();
        if (c >= 16) {
            return 16;
        }
        return (byte)c;
    }

    public boolean canUseBlock(class_2680 state) {
        return state.method_26164(class_3481.field_15493) || state.method_27852(class_2246.field_10363) || state.method_26204() instanceof TrackSwitchBlock;
    }

    protected void method_6099(@NotNull class_1282 pSource, int pLooting, boolean pRecentlyHit) {
        super.method_6099(pSource, pLooting, pRecentlyHit);
        Job job = this.getJob();
        class_1799 holdingStack = this.unequipToolbox();
        if (!holdingStack.method_7960()) {
            this.method_5775(holdingStack);
        }
        if (this.isHoldingSchedules()) {
            for (class_1799 scheduleStack : this.getHeldSchedules()) {
                this.method_5775(scheduleStack);
            }
        }
        if (job == Job.REMOTE_CONTROL) {
            this.method_5775(AllBlocks.REDSTONE_LINK.asStack());
        } else if (job == Job.SPY) {
            this.method_5775(AllItems.GOGGLES.asStack());
        }
    }

    public void method_5652(@NotNull class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10566("target", (class_2520)class_2512.method_10692((class_2338)((class_2338)this.method_5841().method_12789(BLOCK))));
        nbt.method_10567("color", ((Byte)this.method_5841().method_12789(COLOR)).byteValue());
        if (this.toolbox != null) {
            class_2487 toolboxTag = new class_2487();
            this.toolbox.write(toolboxTag, false);
            nbt.method_10566("toolboxHolder", (class_2520)toolboxTag);
        }
        if (!this.getHeldSchedules().isEmpty()) {
            class_2499 schedulesTag = new class_2499();
            boolean hasItem = false;
            for (class_1799 heldSchedule : this.heldSchedules) {
                if (heldSchedule.method_7960()) continue;
                schedulesTag.add((Object)heldSchedule.method_7953(new class_2487()));
                hasItem = true;
            }
            if (hasItem) {
                nbt.method_10566("heldSchedules", (class_2520)schedulesTag);
            }
        }
        nbt.method_10582("job", this.getJob().name());
        nbt.method_10566("frequencies", (class_2520)this.frequencies.write());
    }

    public void method_5749(@NotNull class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10573("color", 1)) {
            this.method_5841().method_12778(COLOR, (Object)nbt.method_10571("color"));
        }
        if (nbt.method_10573("target", 10)) {
            this.method_5841().method_12778(BLOCK, (Object)class_2512.method_10691((class_2487)nbt.method_10562("target")));
        }
        if (nbt.method_10573("toolboxHolder", 10)) {
            this.setToolbox(MountedToolbox.read(this, nbt.method_10562("toolboxHolder")));
        } else {
            this.setToolbox(null);
        }
        if (nbt.method_10573("job", 8)) {
            this.setJob(Job.valueOf(nbt.method_10558("job")));
        } else {
            this.setJob(Job.DEFAULT);
        }
        this.getHeldSchedules().clear();
        if (nbt.method_10573("heldSchedules", 9)) {
            class_2499 schedulesTag = nbt.method_10554("heldSchedules", 10);
            for (int i = 0; i < schedulesTag.size(); ++i) {
                class_1799 stack = class_1799.method_7915((class_2487)schedulesTag.method_10602(i));
                if (stack.method_7960()) continue;
                this.getHeldSchedules().add(stack);
            }
        }
        if (!this.field_6002.field_9236) {
            this.method_5841().method_12778(HOLDING_SCHEDULES, (Object)this.isHoldingSchedules());
            this.frequencies.read(nbt.method_10562("frequencies"));
            this.updateFrequencyListeners();
        }
    }

    static {
        for (String name : List.of("forward", "backward", "left", "right", "jump", "sneak")) {
            FREQUENCY_DATA.put(name, (Couple<class_2940<class_1799>>)Couple.create((Object)class_2945.method_12791(ConductorEntity.class, (class_2941)class_2943.field_13322), (Object)class_2945.method_12791(ConductorEntity.class, (class_2941)class_2943.field_13322)));
        }
        REACH = new class_2382(3, 2, 3);
        RECENTLY_DISMOUNTED_PLAYERS = new ArrayList<class_1657>();
    }

    public class FrequencyListener
    implements IRedstoneLinkable {
        public final String key;
        @Nullable
        public final Couple<RedstoneLinkNetworkHandler.Frequency> frequency;
        public int receivedStrength = 0;

        public FrequencyListener(String key) {
            this.key = key;
            this.frequency = ConductorEntity.this.frequencies.entries().get(this.key).orElse(null);
            if (this.frequency != null) {
                Create.REDSTONE_LINK_NETWORK_HANDLER.addToNetwork((class_1936)ConductorEntity.this.field_6002, (IRedstoneLinkable)this);
            }
        }

        public int getTransmittedStrength() {
            return 0;
        }

        public void setReceivedStrength(int power) {
            this.receivedStrength = power;
        }

        public boolean isListening() {
            return true;
        }

        public boolean isAlive() {
            return ConductorEntity.this.method_5805() && this.frequency != null;
        }

        public Couple<RedstoneLinkNetworkHandler.Frequency> getNetworkKey() {
            return this.frequency;
        }

        public class_2338 getLocation() {
            return ConductorEntity.this.method_24515();
        }

        public boolean isPowered() {
            return this.receivedStrength > 0;
        }
    }

    public class FrequencyHolder
    implements Iterable<Optional<Couple<RedstoneLinkNetworkHandler.Frequency>>> {
        public FrequencyHolder() {
        }

        public FrequencyHolder(@Nullable Couple<// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull RedstoneLinkNetworkHandler.Frequency> forward, @Nullable Couple<// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull RedstoneLinkNetworkHandler.Frequency> backward, @Nullable Couple<// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull RedstoneLinkNetworkHandler.Frequency> left, @Nullable Couple<// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull RedstoneLinkNetworkHandler.Frequency> right, @Nullable Couple<// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull RedstoneLinkNetworkHandler.Frequency> jump, Couple<RedstoneLinkNetworkHandler.Frequency> sneak) {
            this.setForward(forward);
            this.setBackward(backward);
            this.setLeft(left);
            this.setRight(right);
            this.setJump(jump);
            this.setSneak(sneak);
        }

        @Override
        @NotNull
        public @NotNull Iterator<Optional<Couple<// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull RedstoneLinkNetworkHandler.Frequency>>> iterator() {
            return List.of(Optional.ofNullable(this.getForward()), Optional.ofNullable(this.getBackward()), Optional.ofNullable(this.getLeft()), Optional.ofNullable(this.getRight()), Optional.ofNullable(this.getJump()), Optional.ofNullable(this.getSneak())).iterator();
        }

        public Map<String, Optional<Couple<// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull RedstoneLinkNetworkHandler.Frequency>>> entries() {
            return Map.of("forward", Optional.ofNullable(this.getForward()), "backward", Optional.ofNullable(this.getBackward()), "left", Optional.ofNullable(this.getLeft()), "right", Optional.ofNullable(this.getRight()), "jump", Optional.ofNullable(this.getJump()), "sneak", Optional.ofNullable(this.getSneak()));
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public Map<String, Couple<@NotNull class_1799>> stacks() {
            HashMap<String, @NotNull Couple> stacks = new HashMap<String, Couple>();
            for (Map.Entry<String, Optional<Couple<RedstoneLinkNetworkHandler.Frequency>>> entry : this.entries().entrySet()) {
                if (entry.getValue().isEmpty()) {
                    stacks.put(entry.getKey(), Couple.create((Object)class_1799.field_8037, (Object)class_1799.field_8037));
                    continue;
                }
                Couple<// Could not load outer class - annotation placement on inner may be incorrect
                 @NotNull RedstoneLinkNetworkHandler.Frequency> freqs = entry.getValue().get();
                stacks.put(entry.getKey(), Couple.create((Object)((RedstoneLinkNetworkHandler.Frequency)freqs.getFirst()).getStack(), (Object)((RedstoneLinkNetworkHandler.Frequency)freqs.getSecond()).getStack()));
            }
            return ImmutableMap.copyOf(stacks);
        }

        public Map<String, Consumer<Optional<Couple<// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull RedstoneLinkNetworkHandler.Frequency>>>> setters() {
            return Map.of("forward", freq -> this.setForward((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))), "backward", freq -> this.setBackward((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))), "left", freq -> this.setLeft((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))), "right", freq -> this.setRight((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))), "jump", freq -> this.setJump((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))), "sneak", freq -> this.setSneak((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))));
        }

        public List<Consumer<Optional<Couple<// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull RedstoneLinkNetworkHandler.Frequency>>>> settersInOrder() {
            return List.of(freq -> this.setForward((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))), freq -> this.setBackward((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))), freq -> this.setLeft((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))), freq -> this.setRight((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))), freq -> this.setJump((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))), freq -> this.setSneak((Couple<RedstoneLinkNetworkHandler.Frequency>)((Couple)freq.orElse(null))));
        }

        public class_2487 write() {
            class_2487 tag = new class_2487();
            for (Map.Entry<String, Optional<Couple<RedstoneLinkNetworkHandler.Frequency>>> freq : this.entries().entrySet()) {
                if (!freq.getValue().isPresent()) continue;
                class_2487 subTag = new class_2487();
                subTag.method_10566("first", (class_2520)((RedstoneLinkNetworkHandler.Frequency)freq.getValue().get().getFirst()).getStack().method_7953(new class_2487()));
                subTag.method_10566("second", (class_2520)((RedstoneLinkNetworkHandler.Frequency)freq.getValue().get().getSecond()).getStack().method_7953(new class_2487()));
                tag.method_10566(freq.getKey(), (class_2520)subTag);
            }
            return tag;
        }

        public FrequencyHolder read(class_2487 tag) {
            for (Map.Entry<String, Consumer<Optional<Couple<RedstoneLinkNetworkHandler.Frequency>>>> freq : this.setters().entrySet()) {
                if (tag.method_10573(freq.getKey(), 10)) {
                    class_1799 first = class_1799.method_7915((class_2487)tag.method_10562(freq.getKey()).method_10562("first"));
                    class_1799 second = class_1799.method_7915((class_2487)tag.method_10562(freq.getKey()).method_10562("second"));
                    freq.getValue().accept(Optional.of(Couple.create((Object)RedstoneLinkNetworkHandler.Frequency.of((class_1799)first), (Object)RedstoneLinkNetworkHandler.Frequency.of((class_1799)second))));
                    continue;
                }
                freq.getValue().accept(Optional.empty());
            }
            return this;
        }

        private static Couple<class_1799> freqToStacks(@Nullable Couple<RedstoneLinkNetworkHandler.Frequency> freqs) {
            if (freqs == null) {
                return Couple.create((Object)class_1799.field_8037, (Object)class_1799.field_8037);
            }
            return freqs.map(RedstoneLinkNetworkHandler.Frequency::getStack);
        }

        private static Couple<RedstoneLinkNetworkHandler.Frequency> stacksToFreq(Couple<class_1799> stacks) {
            return stacks.map(RedstoneLinkNetworkHandler.Frequency::of);
        }

        private void set(String name, @Nullable Couple<RedstoneLinkNetworkHandler.Frequency> value) {
            Couple<class_1799> stacks = FrequencyHolder.freqToStacks(value);
            Couple<class_2940<class_1799>> freqAccessors = FREQUENCY_DATA.get(name);
            for (boolean first : Iterate.trueAndFalse) {
                ConductorEntity.this.field_6011.method_12778((class_2940)freqAccessors.get(first), (Object)((class_1799)stacks.get(first)));
            }
        }

        private Couple<RedstoneLinkNetworkHandler.Frequency> get(String name) {
            Couple<class_2940<class_1799>> freqAccessors = FREQUENCY_DATA.get(name);
            return FrequencyHolder.stacksToFreq((Couple<class_1799>)freqAccessors.map(arg_0 -> ((class_2945)ConductorEntity.this.field_6011).method_12789(arg_0)));
        }

        @Nullable
        public Couple<RedstoneLinkNetworkHandler.Frequency> getForward() {
            return this.get("forward");
        }

        public void setForward(@Nullable Couple<RedstoneLinkNetworkHandler.Frequency> forward) {
            this.set("forward", forward);
        }

        @Nullable
        public Couple<RedstoneLinkNetworkHandler.Frequency> getBackward() {
            return this.get("backward");
        }

        public void setBackward(@Nullable Couple<RedstoneLinkNetworkHandler.Frequency> backward) {
            this.set("backward", backward);
        }

        @Nullable
        public Couple<RedstoneLinkNetworkHandler.Frequency> getLeft() {
            return this.get("left");
        }

        public void setLeft(@Nullable Couple<RedstoneLinkNetworkHandler.Frequency> left) {
            this.set("left", left);
        }

        @Nullable
        public Couple<RedstoneLinkNetworkHandler.Frequency> getRight() {
            return this.get("right");
        }

        public void setRight(@Nullable Couple<RedstoneLinkNetworkHandler.Frequency> right) {
            this.set("right", right);
        }

        @Nullable
        public Couple<RedstoneLinkNetworkHandler.Frequency> getJump() {
            return this.get("jump");
        }

        public void setJump(@Nullable Couple<RedstoneLinkNetworkHandler.Frequency> jump) {
            this.set("jump", jump);
        }

        @Nullable
        public Couple<RedstoneLinkNetworkHandler.Frequency> getSneak() {
            return this.get("sneak");
        }

        public void setSneak(@Nullable Couple<RedstoneLinkNetworkHandler.Frequency> sneak) {
            this.set("sneak", sneak);
        }
    }

    public static enum Job {
        REDSTONE_OPERATOR,
        TOOLBOX_CARRIER,
        REMOTE_CONTROL,
        SPY;

        public static final Job DEFAULT;

        static {
            DEFAULT = REDSTONE_OPERATOR;
        }
    }

    static class ConductorLookedAtGoal
    extends JobBasedGoal {
        @Nullable
        private class_1309 target;

        public ConductorLookedAtGoal(ConductorEntity conductor) {
            super(conductor, Job.REDSTONE_OPERATOR);
        }

        @Override
        public boolean method_6264() {
            if (!super.method_6264()) {
                return false;
            }
            for (class_1657 player : this.conductor.field_6002.method_18456()) {
                if (!player.method_6057((class_1297)this.conductor)) continue;
                return this.conductor.method_5858((class_1297)player) < 256.0 && this.conductor.isLookingAtMe(player);
            }
            return false;
        }

        public void method_6269() {
            class_1937 level = this.conductor.field_6002;
            class_2338 pos = (class_2338)this.conductor.method_5841().method_12789(BLOCK);
            class_2680 state = level.method_8320(pos);
            class_2248 block = state.method_26204();
            class_3222 fake = this.conductor.fakePlayer;
            if (this.conductor.canReach((class_2382)pos) && this.conductor.canUseBlock(state) && fake != null) {
                boolean canUse;
                class_3959 context = new class_3959(this.conductor.method_33571(), new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()), class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)fake);
                class_3965 hitResult = level.method_17742(context);
                if (!pos.equals((Object)hitResult.method_17777())) {
                    return;
                }
                boolean bl = canUse = state.method_26218((class_1922)level, pos).method_1110() || EntityUtils.handleUseEvent((class_1657)fake, class_1268.field_5808, hitResult);
                if (canUse) {
                    state.method_26174(level, (class_1657)fake, class_1268.field_5808, hitResult);
                }
            }
        }

        public void method_6268() {
            if (this.target != null) {
                this.conductor.field_6206.method_35111((class_1297)this.target);
            }
        }
    }

    static class ConductorPonderBlockGoal
    extends JobBasedGoal {
        private class_2338 target;

        public ConductorPonderBlockGoal(ConductorEntity conductor) {
            super(conductor, Job.REDSTONE_OPERATOR);
            this.target = (class_2338)conductor.field_6011.method_12789(BLOCK);
        }

        @Override
        public boolean method_6264() {
            if (!super.method_6264()) {
                return false;
            }
            this.target = (class_2338)this.conductor.field_6011.method_12789(BLOCK);
            if (this.conductor.canReach((class_2382)this.target) && this.conductor.canUseBlock(this.conductor.field_6002.method_8320(this.target))) {
                return true;
            }
            for (int y = -REACH.method_10264(); y < REACH.method_10264(); ++y) {
                for (int x = -REACH.method_10263(); x < REACH.method_10263(); ++x) {
                    for (int z = -REACH.method_10260(); z < REACH.method_10260(); ++z) {
                        class_3959 context;
                        class_3965 hitResult;
                        class_2338 at = this.conductor.method_24515().method_10069(x, y, z);
                        class_2680 state = this.conductor.field_6002.method_8320(at);
                        if (!this.conductor.canUseBlock(state) || !(hitResult = this.conductor.field_6002.method_17742(context = new class_3959(this.conductor.method_33571(), new class_243((double)at.method_10263(), (double)at.method_10264(), (double)at.method_10260()), class_3959.class_3960.field_17559, class_3959.class_242.field_1348, null))).method_17777().equals((Object)at)) continue;
                        this.target = at;
                        this.conductor.field_6011.method_12778(BLOCK, (Object)this.target);
                        return true;
                    }
                }
            }
            return false;
        }

        public void method_6268() {
            this.conductor.field_6206.method_20248((double)this.target.method_10263(), (double)this.target.method_10264(), (double)this.target.method_10260());
        }
    }

    static class FollowToolboxPlayerGoal
    extends JobBasedGoal {
        protected final double speedModifier;
        @Nullable
        protected class_1657 target;
        protected int timeToRecalcPath;

        public FollowToolboxPlayerGoal(ConductorEntity conductor, double speedModifier) {
            super(conductor, Job.TOOLBOX_CARRIER);
            this.speedModifier = speedModifier;
        }

        public void method_6268() {
            super.method_6268();
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.method_38847(10);
                if (this.conductor.method_5858((class_1297)this.target) > 16.0) {
                    this.conductor.method_5942().method_6335((class_1297)this.target, this.speedModifier);
                } else {
                    this.conductor.method_5942().method_6340();
                }
            }
        }

        @Override
        public boolean method_6264() {
            return super.method_6264() && this.conductor.isCarryingToolbox() && !this.conductor.getToolbox().getConnectedPlayers().isEmpty();
        }

        @Override
        public boolean method_6266() {
            return super.method_6266() && this.conductor.isCarryingToolbox() && this.conductor.getToolbox().getConnectedPlayers().contains(this.target) && this.target.method_5805() && !this.target.method_7325();
        }

        public void method_6269() {
            super.method_6269();
            List<class_1657> players = this.conductor.getToolbox().getConnectedPlayers();
            this.target = players.get(this.conductor.field_5974.method_43048(players.size()));
        }

        public void method_6270() {
            super.method_6270();
            this.target = null;
        }
    }

    static class RemoteControlGoal
    extends JobBasedGoal {
        protected final double speedModifier;
        protected class_243 targetDirection = class_243.field_1353;
        protected double targetStrength = 15.0;
        private int honkPacketCooldown = 0;
        private boolean usedToHonk;

        public RemoteControlGoal(ConductorEntity conductor, double speedModifier) {
            super(conductor, Job.REMOTE_CONTROL);
            this.speedModifier = speedModifier;
        }

        protected double getGroundY(class_243 vec) {
            class_2338 blockPos = class_2338.method_49638((class_2374)vec);
            return this.conductor.field_6002.method_8320(blockPos.method_10074()).method_26215() ? vec.field_1351 : class_14.method_60((class_1922)this.conductor.field_6002, (class_2338)blockPos);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void method_6268() {
            CarriageContraptionEntity cce;
            super.method_6268();
            Pair<class_243, Double> pair = this.calculateTarget();
            this.targetDirection = (class_243)pair.getFirst();
            this.targetStrength = (Double)pair.getSecond();
            class_243 target = this.conductor.method_19538().method_1019(this.targetDirection.method_1021(2.0));
            class_1297 class_12972 = this.conductor.method_5668();
            if (class_12972 instanceof CarriageContraptionEntity && (cce = (CarriageContraptionEntity)class_12972).getControllingPlayer().isEmpty() && (class_12972 = cce.getContraption()) instanceof CarriageContraption) {
                CarriageContraption cc = (CarriageContraption)class_12972;
                if (this.conductor.fakePlayer != null) {
                    ScheduleRuntime runtime;
                    class_2338 seat = cc.getSeatOf(this.conductor.field_6021);
                    if (seat == null) {
                        return;
                    }
                    Couple controlsPresent = (Couple)cc.conductorSeats.get(seat);
                    if (controlsPresent == null) {
                        return;
                    }
                    if (cce.getCarriage() != null && (runtime = cce.getCarriage().train.runtime).getSchedule() != null && !runtime.completed && !runtime.paused) {
                        return;
                    }
                    class_2338 controlsPos = null;
                    class_2338 reverseControlsPos = null;
                    if (((Boolean)controlsPresent.getFirst()).booleanValue()) {
                        controlsPos = seat.method_10093(cc.getAssemblyDirection().method_10153());
                    }
                    if (((Boolean)controlsPresent.getSecond()).booleanValue()) {
                        if (controlsPos == null) {
                            controlsPos = seat.method_10093(cc.getAssemblyDirection());
                        } else {
                            reverseControlsPos = seat.method_10093(cc.getAssemblyDirection());
                        }
                    }
                    if (controlsPos == null) {
                        return;
                    }
                    Set<Integer> controls = this.getControls();
                    if (reverseControlsPos != null && controls.contains(1) && !controls.contains(0)) {
                        controls.remove(1);
                        controls.add(0);
                        controlsPos = reverseControlsPos;
                    }
                    boolean isSprintKeyPressed = controls.remove(5);
                    cce.control(controlsPos, controls, (class_1657)this.conductor.fakePlayer);
                    Train train = cce.getCarriage().train;
                    if (isSprintKeyPressed && this.honkPacketCooldown-- <= 0) {
                        train.determineHonk(this.conductor.field_6002);
                        if (train.lowHonk != null) {
                            Utils.sendHonkPacket(train, true);
                            this.honkPacketCooldown = 5;
                            this.usedToHonk = true;
                        }
                    }
                    if (isSprintKeyPressed) return;
                    if (!this.usedToHonk) return;
                    Utils.sendHonkPacket(train, false);
                    this.honkPacketCooldown = 0;
                    this.usedToHonk = false;
                    return;
                }
            }
            if (!(this.targetDirection.method_1027() > 0.01)) return;
            this.conductor.method_5962().method_6239(target.field_1352, this.getGroundY(target), target.field_1350, this.speedModifier * this.targetStrength / 15.0);
        }

        private Set<Integer> getControls() {
            HashSet<Integer> controls = new HashSet<Integer>();
            if (this.conductor.forwardListener != null && this.conductor.forwardListener.isPowered()) {
                controls.add(0);
            }
            if (this.conductor.backwardListener != null && this.conductor.backwardListener.isPowered()) {
                controls.add(1);
            }
            if (this.conductor.leftListener != null && this.conductor.leftListener.isPowered()) {
                controls.add(2);
            }
            if (this.conductor.rightListener != null && this.conductor.rightListener.isPowered()) {
                controls.add(3);
            }
            if (this.conductor.jumpListener != null && this.conductor.jumpListener.isPowered()) {
                controls.add(4);
            }
            if (this.conductor.sneakListener != null && this.conductor.sneakListener.isPowered()) {
                controls.add(5);
            }
            return controls;
        }

        private Pair<class_243, Double> calculateTarget() {
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            if (this.conductor.forwardListener != null && this.conductor.forwardListener.isPowered()) {
                z -= (double)this.conductor.forwardListener.receivedStrength;
            }
            if (this.conductor.backwardListener != null && this.conductor.backwardListener.isPowered()) {
                z += (double)this.conductor.backwardListener.receivedStrength;
            }
            if (this.conductor.leftListener != null && this.conductor.leftListener.isPowered()) {
                x -= (double)this.conductor.leftListener.receivedStrength;
            }
            if (this.conductor.rightListener != null && this.conductor.rightListener.isPowered()) {
                x += (double)this.conductor.rightListener.receivedStrength;
            }
            if (this.conductor.jumpListener != null && this.conductor.jumpListener.isPowered()) {
                y += (double)this.conductor.jumpListener.receivedStrength;
            }
            if (this.conductor.sneakListener != null && this.conductor.sneakListener.isPowered()) {
                y -= (double)this.conductor.sneakListener.receivedStrength;
            }
            double avgStrength = 0.0;
            int count = 0;
            if (x != 0.0) {
                avgStrength += Math.abs(x);
                ++count;
            }
            if (y != 0.0) {
                avgStrength += Math.abs(y);
                ++count;
            }
            if (z != 0.0) {
                avgStrength += Math.abs(z);
                ++count;
            }
            return Pair.of((Object)new class_243(x, Math.max(0.0, y), z).method_1021(0.06666666666666667), (Object)(count == 0 ? 0.0 : avgStrength / (double)count));
        }

        public void method_6269() {
            super.method_6269();
            Pair<class_243, Double> pair = this.calculateTarget();
            this.targetDirection = (class_243)pair.getFirst();
            this.targetStrength = (Double)pair.getSecond();
        }

        public void method_6270() {
            super.method_6270();
            this.targetDirection = class_243.field_1353;
            this.targetStrength = 15.0;
        }

        public boolean method_38846() {
            return true;
        }
    }

    static class JobBasedGoal
    extends class_1352 {
        private final Job job;
        protected final ConductorEntity conductor;

        public JobBasedGoal(ConductorEntity conductor, Job job) {
            this.conductor = conductor;
            this.job = job;
        }

        public boolean method_6264() {
            return this.conductor.getJob() == this.job && !this.conductor.isPossessed();
        }

        public boolean method_6266() {
            return this.method_6264();
        }
    }
}

