/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.switches;

import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.switches.TrackSwitch;
import com.railwayteam.railways.content.switches.TrackSwitchBlockEntity;
import com.railwayteam.railways.content.switches.fabric.TrackSwitchBlockImpl;
import com.railwayteam.railways.registry.CRBlockEntities;
import com.railwayteam.railways.registry.CRShapes;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.utility.Lang;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1667;
import net.minecraft.class_1676;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TrackSwitchBlock
extends class_2383
implements IBE<TrackSwitchBlockEntity>,
IWrenchable {
    boolean isAutomatic;
    public static final class_2746 LOCKED = class_2741.field_12502;

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static TrackSwitchBlock manual(class_4970.class_2251 properties) {
        return TrackSwitchBlockImpl.manual(properties);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static TrackSwitchBlock automatic(class_4970.class_2251 properties) {
        return TrackSwitchBlockImpl.automatic(properties);
    }

    protected TrackSwitchBlock(class_4970.class_2251 properties, boolean isAutomatic) {
        super(properties);
        this.isAutomatic = isAutomatic;
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder.method_11667(new class_2769[]{field_11177}).method_11667(new class_2769[]{LOCKED}));
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2680 state = super.method_9605(context);
        if (state == null) {
            return null;
        }
        return (class_2680)((class_2680)state.method_11657((class_2769)field_11177, (Comparable)context.method_8042())).method_11657((class_2769)LOCKED, (Comparable)Boolean.valueOf(context.method_8045().method_49807(context.method_8037().method_10074(), class_2350.field_11033)));
    }

    public Class<TrackSwitchBlockEntity> getBlockEntityClass() {
        return TrackSwitchBlockEntity.class;
    }

    public class_2591<? extends TrackSwitchBlockEntity> getBlockEntityType() {
        return this.isAutomatic ? (class_2591)CRBlockEntities.BRASS_SWITCH.get() : (class_2591)CRBlockEntities.ANDESITE_SWITCH.get();
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean isMoving) {
        IBE.onRemove((class_2680)state, (class_1937)level, (class_2338)pos, (class_2680)newState);
    }

    @NotNull
    public class_265 method_9530(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_3726 context) {
        class_3727 entityContext;
        if (context instanceof class_3727 && (entityContext = (class_3727)context).method_32480() instanceof class_1676) {
            return this.isAutomatic ? CRShapes.BRASS_SWITCH_PROJECTILE.get((class_2350)state.method_11654((class_2769)field_11177)) : CRShapes.ANDESITE_SWITCH_PROJECTILE.get((class_2350)state.method_11654((class_2769)field_11177));
        }
        return this.isAutomatic ? CRShapes.BRASS_SWITCH.get((class_2350)state.method_11654((class_2769)field_11177)) : CRShapes.ANDESITE_SWITCH.get((class_2350)state.method_11654((class_2769)field_11177));
    }

    @NotNull
    public class_265 method_9549(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_3726 context) {
        return this.field_23159 ? this.method_9530(state, level, pos, context) : class_259.method_1073();
    }

    @NotNull
    public class_1269 method_9534(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1657 player, @NotNull class_1268 hand, @NotNull class_3965 hit) {
        class_1799 itemInHand = player.method_5998(hand);
        if (AllItems.WRENCH.isIn(itemInHand)) {
            return class_1269.field_5811;
        }
        if (level.field_9236) {
            return class_1269.field_5812;
        }
        TrackSwitchBlockEntity te = (TrackSwitchBlockEntity)this.getBlockEntity((class_1922)level, pos);
        if (te != null) {
            if (player.method_7334() == ConductorEntity.FAKE_PLAYER_PROFILE) {
                return te.onProjectileHit() ? class_1269.field_21466 : class_1269.field_5812;
            }
            return te.onUse(player.method_21749());
        }
        return class_1269.field_5812;
    }

    public void method_19286(class_1937 level, class_2680 state, class_3965 hit, class_1676 projectile) {
        super.method_19286(level, state, hit, projectile);
        TrackSwitchBlockEntity te = (TrackSwitchBlockEntity)this.getBlockEntity((class_1922)level, hit.method_17777());
        if (te != null) {
            te.onProjectileHit();
        }
        if (projectile instanceof class_1667) {
            projectile.method_31472();
        }
    }

    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 block, class_2338 fromPos, boolean isMoving) {
        super.method_9612(state, level, pos, block, fromPos, isMoving);
        TrackSwitchBlockEntity te = (TrackSwitchBlockEntity)this.getBlockEntity((class_1922)level, pos);
        if (te != null) {
            te.checkRedstoneInputs();
        }
    }

    @Deprecated
    public boolean method_9498(@NotNull class_2680 state) {
        return true;
    }

    @Deprecated
    public int method_9572(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof TrackSwitchBlockEntity) {
            TrackSwitchBlockEntity te = (TrackSwitchBlockEntity)class_25862;
            return te.getTargetAnalogOutput();
        }
        return 0;
    }

    public static enum SwitchState implements class_3542
    {
        NORMAL(0),
        REVERSE_LEFT(-1),
        REVERSE_RIGHT(1);

        private final int direction;

        private SwitchState(int direction) {
            this.direction = direction;
        }

        public static SwitchState fromSteerDirection(TravellingPoint.SteerDirection direction, boolean forward) {
            return switch (direction) {
                default -> throw new IncompatibleClassChangeError();
                case TravellingPoint.SteerDirection.NONE -> NORMAL;
                case TravellingPoint.SteerDirection.LEFT -> {
                    if (forward) {
                        yield REVERSE_LEFT;
                    }
                    yield REVERSE_RIGHT;
                }
                case TravellingPoint.SteerDirection.RIGHT -> forward ? REVERSE_RIGHT : REVERSE_LEFT;
            };
        }

        @NotNull
        public String method_15434() {
            return Lang.asId((String)this.name());
        }

        public boolean canSwitchTo(SwitchState next, SwitchConstraint constraint) {
            return switch (constraint) {
                default -> throw new IncompatibleClassChangeError();
                case SwitchConstraint.NONE -> true;
                case SwitchConstraint.TO_LEFT -> {
                    if (next.direction <= this.direction) {
                        yield true;
                    }
                    yield false;
                }
                case SwitchConstraint.TO_RIGHT -> next.direction >= this.direction;
            };
        }

        @NotNull
        public SwitchState nextStateFor(TrackSwitch sw, SwitchConstraint constraint) {
            if (this == NORMAL) {
                if (sw.hasRightExit() && constraint.canGoRight()) {
                    return REVERSE_RIGHT;
                }
                if (sw.hasLeftExit() && constraint.canGoLeft()) {
                    return REVERSE_LEFT;
                }
            } else if (this == REVERSE_RIGHT) {
                if (constraint == SwitchConstraint.NONE) {
                    if (sw.hasLeftExit() && constraint.canGoLeft()) {
                        return REVERSE_LEFT;
                    }
                    if (sw.hasStraightExit() && constraint.canGoLeft()) {
                        return NORMAL;
                    }
                } else {
                    if (sw.hasStraightExit() && constraint.canGoLeft()) {
                        return NORMAL;
                    }
                    if (sw.hasLeftExit() && constraint.canGoLeft()) {
                        return REVERSE_LEFT;
                    }
                }
            } else if (this == REVERSE_LEFT) {
                if (sw.hasStraightExit() && constraint.canGoRight()) {
                    return NORMAL;
                }
                if (sw.hasRightExit() && constraint.canGoRight()) {
                    return REVERSE_RIGHT;
                }
            }
            return this;
        }

        public SwitchState nextStateForPonder(SwitchConstraint constraint) {
            if (this == NORMAL) {
                if (constraint.canGoRight()) {
                    return REVERSE_RIGHT;
                }
                if (constraint.canGoLeft()) {
                    return REVERSE_LEFT;
                }
            } else if (this == REVERSE_RIGHT) {
                if (constraint == SwitchConstraint.NONE) {
                    if (constraint.canGoLeft()) {
                        return REVERSE_LEFT;
                    }
                } else if (constraint.canGoLeft()) {
                    return NORMAL;
                }
            } else if (this == REVERSE_LEFT && constraint.canGoRight()) {
                return NORMAL;
            }
            return this;
        }
    }

    public static enum SwitchConstraint {
        NONE,
        TO_RIGHT,
        TO_LEFT;


        public boolean canGoRight() {
            return this != TO_LEFT;
        }

        public boolean canGoLeft() {
            return this != TO_RIGHT;
        }
    }
}

