/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.gravestones;

import com.google.gson.GsonBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.pneumono.gravestones.compat.CompatRegistry;
import net.pneumono.gravestones.content.GravestonesRegistry;
import net.pneumono.gravestones.content.entity.TechnicalGravestoneBlockEntity;
import net.pneumono.gravestones.gravestones.DecayTimeType;
import net.pneumono.gravestones.gravestones.ExperienceKeptCalculation;
import net.pneumono.gravestones.gravestones.GravestoneData;
import net.pneumono.gravestones.gravestones.GravestonePosition;
import net.pneumono.gravestones.gravestones.TimeFormatType;
import net.pneumono.pneumonocore.config.AbstractConfiguration;
import net.pneumono.pneumonocore.config.BooleanConfiguration;
import net.pneumono.pneumonocore.config.ConfigEnv;
import net.pneumono.pneumonocore.config.Configs;
import net.pneumono.pneumonocore.config.EnumConfiguration;
import net.pneumono.pneumonocore.config.TimeConfiguration;
import net.pneumono.pneumonocore.config.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Gravestones
implements ModInitializer {
    public static final String MOD_ID = "gravestones";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Gravestones");
    public static final BooleanConfiguration AESTHETIC_GRAVESTONES = (BooleanConfiguration)Configs.register((AbstractConfiguration)new BooleanConfiguration("gravestones", "aesthetic_gravestones", ConfigEnv.SERVER, true));
    public static final BooleanConfiguration DECAY_WITH_TIME = (BooleanConfiguration)Configs.register((AbstractConfiguration)new BooleanConfiguration("gravestones", "decay_with_time", ConfigEnv.SERVER, true));
    public static final BooleanConfiguration DECAY_WITH_DEATHS = (BooleanConfiguration)Configs.register((AbstractConfiguration)new BooleanConfiguration("gravestones", "decay_with_deaths", ConfigEnv.SERVER, true));
    public static final TimeConfiguration DECAY_TIME = (TimeConfiguration)Configs.register((AbstractConfiguration)new TimeConfiguration("gravestones", "decay_time", ConfigEnv.SERVER, Long.valueOf(8L * (long)TimeUnit.HOURS.getDivision())));
    public static final EnumConfiguration<DecayTimeType> GRAVESTONE_DECAY_TIME_TYPE = (EnumConfiguration)Configs.register((AbstractConfiguration)new EnumConfiguration("gravestones", "decay_time_type", ConfigEnv.SERVER, (Enum)DecayTimeType.TICKS));
    public static final BooleanConfiguration STORE_EXPERIENCE = (BooleanConfiguration)Configs.register((AbstractConfiguration)new BooleanConfiguration("gravestones", "store_experience", ConfigEnv.SERVER, true));
    public static final BooleanConfiguration EXPERIENCE_CAP = (BooleanConfiguration)Configs.register((AbstractConfiguration)new BooleanConfiguration("gravestones", "experience_cap", ConfigEnv.SERVER, true));
    public static final EnumConfiguration<ExperienceKeptCalculation> EXPERIENCE_KEPT = (EnumConfiguration)Configs.register((AbstractConfiguration)new EnumConfiguration("gravestones", "experience_kept", ConfigEnv.SERVER, (Enum)ExperienceKeptCalculation.VANILLA));
    public static final BooleanConfiguration EXPERIENCE_DECAY = (BooleanConfiguration)Configs.register((AbstractConfiguration)new BooleanConfiguration("gravestones", "experience_decay", ConfigEnv.SERVER, false));
    public static final BooleanConfiguration GRAVESTONE_ACCESSIBLE_OWNER_ONLY = (BooleanConfiguration)Configs.register((AbstractConfiguration)new BooleanConfiguration("gravestones", "gravestone_accessible_owner_only", ConfigEnv.SERVER, true));
    public static final BooleanConfiguration SPAWN_GRAVESTONE_SKELETONS = (BooleanConfiguration)Configs.register((AbstractConfiguration)new BooleanConfiguration("gravestones", "spawn_gravestone_skeletons", ConfigEnv.SERVER, false));
    public static final BooleanConfiguration BROADCAST_COLLECT_IN_CHAT = (BooleanConfiguration)Configs.register((AbstractConfiguration)new BooleanConfiguration("gravestones", "broadcast_collect_in_chat", ConfigEnv.SERVER, false));
    public static final BooleanConfiguration BROADCAST_COORDINATES_IN_CHAT = (BooleanConfiguration)Configs.register((AbstractConfiguration)new BooleanConfiguration("gravestones", "broadcast_coordinates_in_chat", ConfigEnv.SERVER, false));
    public static final BooleanConfiguration CONSOLE_INFO = (BooleanConfiguration)Configs.register((AbstractConfiguration)new BooleanConfiguration("gravestones", "console_info", ConfigEnv.CLIENT, false));
    public static final EnumConfiguration<TimeFormatType> TIME_FORMAT = (EnumConfiguration)Configs.register((AbstractConfiguration)new EnumConfiguration("gravestones", "time_format", ConfigEnv.CLIENT, (Enum)TimeFormatType.MMDDYYYY));
    public static final class_2960 RESOURCE_CONDITION_CONFIGURATIONS = Gravestones.identifier("configurations");

    public void onInitialize() {
        LOGGER.info("Initializing Gravestones");
        Configs.reload((String)MOD_ID);
        GravestonesRegistry.registerModContent();
        this.registerCommands();
        ResourceConditions.register((class_2960)RESOURCE_CONDITION_CONFIGURATIONS, jsonObject -> (Boolean)AESTHETIC_GRAVESTONES.getValue());
        CompatRegistry.registerCompat();
    }

    public static class_2960 identifier(String path) {
        return class_2960.method_43902((String)MOD_ID, (String)path);
    }

    private void registerCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)MOD_ID).requires(source -> source.method_9259(4))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"getdata").then(class_2170.method_9247((String)"gravestone").then(class_2170.method_9244((String)"position", (ArgumentType)class_2262.method_9698()).executes(context -> {
            class_2338 pos;
            class_3218 world = ((class_2168)context.getSource()).method_9225();
            if (!world.method_8320(pos = class_2262.method_48299((CommandContext)context, (String)"position")).method_27852(GravestonesRegistry.GRAVESTONE_TECHNICAL)) {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"No gravestone at that position!").method_27692(class_124.field_1061));
            } else {
                class_2586 patt0$temp = world.method_8321(pos);
                if (patt0$temp instanceof TechnicalGravestoneBlockEntity) {
                    TechnicalGravestoneBlockEntity entity = (TechnicalGravestoneBlockEntity)patt0$temp;
                    GameProfile owner = entity.getGraveOwner();
                    if (owner != null) {
                        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Gravestone has a spawnDate of " + entity.getSpawnDateTime() + " and a graveOwner of " + owner.getName() + " (" + String.valueOf(owner.getId()) + ")")).method_27692(class_124.field_1060));
                    } else {
                        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Gravestone has a spawnDate of " + entity.getSpawnDateTime() + " and no graveOwner!")).method_27692(class_124.field_1061));
                    }
                    StringBuilder itemMessage = new StringBuilder();
                    boolean notFirst = false;
                    for (class_1799 item : entity.getItems()) {
                        if (notFirst) {
                            itemMessage.append(", ");
                        } else {
                            notFirst = true;
                        }
                        itemMessage.append(item.toString());
                    }
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Gravestone has the following items " + String.valueOf(itemMessage))).method_27692(class_124.field_1065));
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Gravestone has " + entity.getExperience() + " experience points")).method_27692(class_124.field_1065));
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Gravestone has the following mod data " + entity.getAllModData().toString())).method_27692(class_124.field_1065));
                }
            }
            return 1;
        })))).then(class_2170.method_9247((String)"player").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> {
            File gravestoneFile = new File(((class_2168)context.getSource()).method_9225().method_8503().method_27050(class_5218.field_24188).toString(), "gravestone_data.json");
            try {
                if (gravestoneFile.exists()) {
                    BufferedReader reader = Files.newBufferedReader(gravestoneFile.toPath());
                    GravestoneData data = (GravestoneData)new GsonBuilder().serializeNulls().setPrettyPrinting().create().fromJson((Reader)reader, GravestoneData.class);
                    ((Reader)reader).close();
                    List<GravestonePosition> positions = data.getPlayerGravePositions(class_2186.method_9315((CommandContext)context, (String)"player").method_7334().getId());
                    StringBuilder posList = new StringBuilder();
                    boolean notFirst = false;
                    for (GravestonePosition pos : positions) {
                        if (notFirst) {
                            posList.append(", ");
                        } else {
                            notFirst = true;
                        }
                        posList.append("(").append(pos.posX).append(",").append(pos.posY).append(",").append(pos.posZ).append(") in ").append(pos.dimension);
                    }
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)(Objects.requireNonNull(class_2186.method_9315((CommandContext)context, (String)"player").method_5476()).getString() + " has graves at the following locations: " + String.valueOf(posList))));
                } else {
                    LOGGER.error("Could not find gravestone data file.");
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Could not find gravestone data file.").method_27692(class_124.field_1061));
                }
            }
            catch (IOException e) {
                LOGGER.error("Could not read gravestone data file!", (Throwable)e);
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Could not read gravestone data file!").method_27692(class_124.field_1061));
            }
            return 1;
        }))))));
    }
}

