/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.gravestones.gravestones;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.pneumono.gravestones.gravestones.GravestonePosition;
import net.pneumono.gravestones.gravestones.PlayerGravestoneData;

public class GravestoneData {
    public List<PlayerGravestoneData> data = new ArrayList<PlayerGravestoneData>();

    public List<GravestonePosition> getPlayerGravePositions(UUID player) {
        for (PlayerGravestoneData playerData : this.data) {
            if (!Objects.equals(playerData.getOwner().toString(), player.toString())) continue;
            return new ArrayList<GravestonePosition>(playerData.getPositionsAsList());
        }
        return null;
    }

    public PlayerGravestoneData getPlayerData(UUID player) {
        for (PlayerGravestoneData playerData : this.data) {
            if (!Objects.equals(playerData.getOwner().toString(), player.toString())) continue;
            return playerData;
        }
        return null;
    }

    public void setPlayerData(PlayerGravestoneData newPlayerData, UUID player, GravestonePosition pos) {
        for (PlayerGravestoneData playerData : this.data) {
            if (!Objects.equals(playerData.getOwner().toString(), newPlayerData.owner.toString())) continue;
            this.data.remove(playerData);
            this.addPlayerDataSafely(newPlayerData, player, pos);
            return;
        }
        this.addPlayerDataSafely(newPlayerData, player, pos);
    }

    private void addPlayerDataSafely(PlayerGravestoneData playerData, UUID player, GravestonePosition gravestonePos) {
        this.data.add(Objects.requireNonNullElseGet(playerData, () -> new PlayerGravestoneData(player, gravestonePos)));
    }

    public boolean hasData() {
        return !this.data.isEmpty();
    }
}

