/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.advancement.trigger;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.advancement.predicate.CameraPredicate;
import io.github.mortuusars.exposure.advancement.predicate.ExposurePredicate;
import io.github.mortuusars.exposure.item.CameraItem;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_195;
import net.minecraft.class_2090;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5257;
import net.minecraft.class_5258;
import net.minecraft.class_5267;
import org.jetbrains.annotations.NotNull;

public class FrameExposedTrigger
extends class_4558<TriggerInstance> {
    public static final class_2960 ID = Exposure.resource("frame_exposed");

    @NotNull
    public class_2960 method_794() {
        return ID;
    }

    @NotNull
    protected TriggerInstance createInstance(JsonObject json, @NotNull class_5258 predicate, @NotNull class_5257 deserializationContext) {
        CameraPredicate camera = CameraPredicate.fromJson(json.get("camera"));
        ExposurePredicate exposure = ExposurePredicate.fromJson(json.get("exposure"));
        class_2090 location = class_2090.method_9021((JsonElement)json.get("location"));
        return new TriggerInstance(predicate, camera, exposure, location);
    }

    public void trigger(class_3222 player, ItemAndStack<CameraItem> camera, class_2487 frame, List<class_1297> entitiesInFrame) {
        this.method_22510(player, triggerInstance -> triggerInstance.matches(player, camera, frame, entitiesInFrame));
    }

    public static class TriggerInstance
    extends class_195 {
        private final CameraPredicate cameraPredicate;
        private final ExposurePredicate exposurePredicate;
        private final class_2090 locationPredicate;

        public TriggerInstance(class_5258 predicate, CameraPredicate cameraPredicate, ExposurePredicate exposurePredicate, class_2090 locationPredicate) {
            super(ID, predicate);
            this.cameraPredicate = cameraPredicate;
            this.exposurePredicate = exposurePredicate;
            this.locationPredicate = locationPredicate;
        }

        public boolean matches(class_3222 player, ItemAndStack<CameraItem> camera, class_2487 frame, List<class_1297> entitiesInFrame) {
            return this.cameraPredicate.matches(camera) && this.exposurePredicate.matches(player, frame, entitiesInFrame) && this.locationPredicate.method_9018(player.method_51469(), player.method_23317(), player.method_23318(), player.method_23321());
        }

        @NotNull
        public JsonObject method_807(@NotNull class_5267 conditions) {
            JsonObject jsonobject = super.method_807(conditions);
            jsonobject.add("camera", this.cameraPredicate.serializeToJson());
            jsonobject.add("exposure", this.exposurePredicate.serializeToJson());
            jsonobject.add("location", this.locationPredicate.method_9019());
            return jsonobject;
        }
    }
}

