/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib.util.toml;

import com.cursee.monolib.util.toml.Context;
import com.cursee.monolib.util.toml.ValueReader;
import com.cursee.monolib.util.toml.ValueWriter;
import com.cursee.monolib.util.toml.WriterContext;
import java.util.concurrent.atomic.AtomicInteger;

class BooleanValueReaderWriter
implements ValueReader,
ValueWriter {
    static final BooleanValueReaderWriter BOOLEAN_VALUE_READER_WRITER = new BooleanValueReaderWriter();

    @Override
    public boolean canRead(String s) {
        return s.startsWith("true") || s.startsWith("false");
    }

    @Override
    public Object read(String s, AtomicInteger index, Context context) {
        Boolean b = (s = s.substring(index.get())).startsWith("true") ? Boolean.TRUE : Boolean.FALSE;
        int endIndex = b == Boolean.TRUE ? 4 : 5;
        index.addAndGet(endIndex - 1);
        return b;
    }

    @Override
    public boolean canWrite(Object value) {
        return Boolean.class.isInstance(value);
    }

    @Override
    public void write(Object value, WriterContext context) {
        context.write(value.toString());
    }

    @Override
    public boolean isPrimitiveType() {
        return true;
    }

    private BooleanValueReaderWriter() {
    }

    public String toString() {
        return "boolean";
    }
}

