/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.client.level.entities.layer;

import com.blackgear.vanillabackport.client.level.entities.model.CreakingModel;
import com.blackgear.vanillabackport.common.level.entities.creaking.Creaking;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_922;

@Environment(value=EnvType.CLIENT)
public class CreakingEmissiveLayer<T extends Creaking, M extends CreakingModel<T>>
extends class_3887<T, M> {
    private final class_2960 texture;
    private final AlphaFunction<T> alphaFunction;
    private final DrawSelector<T, M> drawSelector;
    private final Function<class_2960, class_1921> bufferProvider;

    public CreakingEmissiveLayer(class_3883<T, M> renderer, class_2960 texture, AlphaFunction<T> alphaFunction, DrawSelector<T, M> drawSelector, Function<class_2960, class_1921> bufferProvider) {
        super(renderer);
        this.texture = texture;
        this.alphaFunction = alphaFunction;
        this.drawSelector = drawSelector;
        this.bufferProvider = bufferProvider;
    }

    public void render(class_4587 poseStack, class_4597 buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entity.method_5767() && this.onlyDrawSelectedParts()) {
            class_4588 vertices = buffer.getBuffer(this.bufferProvider.apply(this.texture));
            ((CreakingModel)this.method_17165()).method_2828(poseStack, vertices, packedLight, class_922.method_23622(entity, (float)0.0f), 1.0f, 1.0f, 1.0f, this.alphaFunction.apply(entity, partialTick, ageInTicks));
            this.resetDrawForAllParts();
        }
    }

    private boolean onlyDrawSelectedParts() {
        List<class_630> partsToDraw = this.drawSelector.getPartsToDraw((CreakingModel)this.method_17165());
        if (partsToDraw.isEmpty()) {
            return false;
        }
        ((CreakingModel)this.method_17165()).method_32008().method_32088().forEach(model -> {
            model.field_38456 = true;
        });
        partsToDraw.forEach(model -> {
            model.field_38456 = false;
        });
        return true;
    }

    private void resetDrawForAllParts() {
        ((CreakingModel)this.method_17165()).method_32008().method_32088().forEach(model -> {
            model.field_38456 = false;
        });
    }

    @Environment(value=EnvType.CLIENT)
    public static interface AlphaFunction<T extends Creaking> {
        public float apply(T var1, float var2, float var3);
    }

    @Environment(value=EnvType.CLIENT)
    public static interface DrawSelector<T extends Creaking, M extends class_583<T>> {
        public List<class_630> getPartsToDraw(M var1);
    }
}

