/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.core.mixin.client;

import com.blackgear.vanillabackport.common.registries.ModBiomes;
import com.blackgear.vanillabackport.core.mixin.access.SoundEngineAccessor;
import com.blackgear.vanillabackport.core.mixin.access.SoundManagerAccessor;
import net.minecraft.class_1113;
import net.minecraft.class_1140;
import net.minecraft.class_1142;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4235;
import net.minecraft.class_5195;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1142.class})
public abstract class MusicManagerMixin {
    @Shadow
    @Nullable
    private class_1113 field_5574;
    @Shadow
    @Final
    private class_310 field_5575;
    @Unique
    private static final float FADE_OUT_FACTOR = 0.97f;
    @Unique
    private static final float FADE_IN_MIN_STEP = 5.0E-4f;
    @Unique
    private static final float FADE_IN_MAX_STEP = 0.005f;
    @Unique
    private static final float VOLUME_THRESHOLD = 1.0E-4f;
    @Unique
    private float currentGain = 1.0f;

    @Shadow
    public abstract void method_4859();

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTick(CallbackInfo ci) {
        if (this.field_5574 == null) {
            return;
        }
        float targetVolume = this.getBackgroundMusicVolume();
        if (this.currentGain != targetVolume && this.fadePlaying(targetVolume)) {
            ci.cancel();
        }
    }

    @Inject(method={"startPlaying"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventPlayingInPaleGarden(class_5195 selector, CallbackInfo ci) {
        if (this.field_5575.field_1724 == null) {
            return;
        }
        class_6880 biome = this.field_5575.field_1724.method_37908().method_23753(this.field_5575.field_1724.method_24515());
        if (biome.method_40225(ModBiomes.PALE_GARDEN)) {
            ci.cancel();
        }
    }

    @Inject(method={"startPlaying"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/sounds/SoundManager;play(Lnet/minecraft/client/resources/sounds/SoundInstance;)V")})
    private void updateVolume(class_5195 selector, CallbackInfo ci) {
        if (this.field_5574 != null) {
            class_1140 engine = ((SoundManagerAccessor)this.field_5575.method_1483()).getSoundEngine();
            this.setVolume(engine, this.field_5574, this.getBackgroundMusicVolume());
        }
    }

    @Inject(method={"startPlaying"}, at={@At(value="TAIL")})
    private void onStartPlaying(class_5195 selector, CallbackInfo ci) {
        this.currentGain = this.getBackgroundMusicVolume();
    }

    @Unique
    private boolean fadePlaying(float targetVolume) {
        if (this.currentGain == targetVolume) {
            return true;
        }
        if (this.currentGain < targetVolume) {
            float step = class_3532.method_15363((float)this.currentGain, (float)5.0E-4f, (float)0.005f);
            this.currentGain = Math.min(this.currentGain + step, targetVolume);
        } else {
            this.currentGain = 0.97f * this.currentGain + 0.029999971f * targetVolume;
            if (Math.abs(this.currentGain - targetVolume) < 1.0E-4f) {
                this.currentGain = targetVolume;
            }
        }
        this.currentGain = class_3532.method_15363((float)this.currentGain, (float)0.0f, (float)1.0f);
        if (this.currentGain <= 1.0E-4f) {
            this.method_4859();
            return false;
        }
        class_1140 engine = ((SoundManagerAccessor)this.field_5575.method_1483()).getSoundEngine();
        this.setVolume(engine, this.field_5574, this.currentGain);
        return true;
    }

    @Unique
    private float getBackgroundMusicVolume() {
        class_746 player = this.field_5575.field_1724;
        if (player == null) {
            return 1.0f;
        }
        class_6880 biome = player.method_37908().method_23753(player.method_24515());
        return biome.method_40225(ModBiomes.PALE_GARDEN) ? 0.0f : 1.0f;
    }

    @Unique
    private void setVolume(class_1140 engine, class_1113 instance, float volume) {
        SoundEngineAccessor accessor = (SoundEngineAccessor)engine;
        if (!accessor.isLoaded()) {
            return;
        }
        class_4235.class_4236 handle = accessor.getInstanceToChannel().get(instance);
        if (handle != null) {
            handle.method_19735(channel -> channel.method_19647(volume * accessor.callCalculateVolume(instance)));
        }
    }
}

