/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import dan200.computercraft.api.upgrades.UpgradeBase;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.api.upgrades.UpgradeSerialiser;
import dan200.computercraft.shared.platform.PlatformHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeManager<R extends UpgradeSerialiser<? extends T>, T extends UpgradeBase>
extends class_4309 {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeManager.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final String kind;
    private final class_5321<class_2378<R>> registry;
    private Map<String, UpgradeWrapper<R, T>> current = Map.of();
    private Map<T, UpgradeWrapper<R, T>> currentWrappers = Map.of();

    public UpgradeManager(String kind, String path, class_5321<class_2378<R>> registry) {
        super(GSON, path);
        this.kind = kind;
        this.registry = registry;
    }

    public @Nullable T get(String id) {
        UpgradeWrapper<R, T> wrapper = this.current.get(id);
        return wrapper == null ? null : (T)wrapper.upgrade();
    }

    public @Nullable UpgradeWrapper<R, T> getWrapper(T upgrade) {
        return this.currentWrappers.get(upgrade);
    }

    public @Nullable String getOwner(T upgrade) {
        UpgradeWrapper<R, T> wrapper = this.currentWrappers.get(upgrade);
        return wrapper != null ? wrapper.modId() : null;
    }

    public @Nullable UpgradeData<T> get(class_1799 stack) {
        if (stack.method_7960()) {
            return null;
        }
        for (UpgradeWrapper<R, T> wrapper : this.current.values()) {
            class_1799 craftingStack = wrapper.upgrade().getCraftingItem();
            if (craftingStack.method_7960() || craftingStack.method_7909() != stack.method_7909() || !wrapper.upgrade().isItemSuitable(stack)) continue;
            return UpgradeData.of(wrapper.upgrade, wrapper.upgrade.getUpgradeData(stack));
        }
        return null;
    }

    public Collection<T> getUpgrades() {
        return this.currentWrappers.keySet();
    }

    public Map<String, UpgradeWrapper<R, T>> getUpgradeWrappers() {
        return this.current;
    }

    protected void apply(Map<class_2960, JsonElement> upgrades, class_3300 manager, class_3695 profiler) {
        HashMap<String, UpgradeWrapper<R, T>> newUpgrades = new HashMap<String, UpgradeWrapper<R, T>>();
        for (Map.Entry<class_2960, JsonElement> element : upgrades.entrySet()) {
            try {
                this.loadUpgrade(newUpgrades, element.getKey(), element.getValue());
            }
            catch (JsonParseException | IllegalArgumentException e) {
                LOG.error("Error loading {} {} from JSON file", new Object[]{this.kind, element.getKey(), e});
            }
        }
        this.current = Collections.unmodifiableMap(newUpgrades);
        this.currentWrappers = newUpgrades.values().stream().collect(Collectors.toUnmodifiableMap(UpgradeWrapper::upgrade, x -> x));
        LOG.info("Loaded {} {}s", (Object)this.current.size(), (Object)this.kind);
    }

    private void loadUpgrade(Map<String, UpgradeWrapper<R, T>> current, class_2960 id, JsonElement json) {
        Object upgrade;
        JsonObject root = class_3518.method_15295((JsonElement)json, (String)"top element");
        if (!PlatformHelper.get().shouldLoadResource(root)) {
            return;
        }
        class_2960 serialiserId = new class_2960(class_3518.method_15265((JsonObject)root, (String)"type"));
        UpgradeSerialiser serialiser = (UpgradeSerialiser)PlatformHelper.get().tryGetRegistryObject(this.registry, serialiserId);
        if (serialiser == null) {
            throw new JsonSyntaxException("Unknown upgrade type '" + String.valueOf(serialiserId) + "'");
        }
        String modId = id.method_12836();
        if (modId.equals("minecraft") || modId.isEmpty()) {
            modId = "computercraft";
        }
        if (!(upgrade = serialiser.fromJson(id, root)).getUpgradeID().equals((Object)id)) {
            throw new IllegalArgumentException("Upgrade " + String.valueOf(id) + " from " + String.valueOf(serialiser) + " was incorrectly given id " + String.valueOf(upgrade.getUpgradeID()));
        }
        UpgradeWrapper result = new UpgradeWrapper(id.toString(), upgrade, serialiser, modId);
        current.put(result.id(), result);
    }

    public void loadFromNetwork(Map<String, UpgradeWrapper<R, T>> newUpgrades) {
        this.current = Collections.unmodifiableMap(newUpgrades);
        this.currentWrappers = newUpgrades.values().stream().collect(Collectors.toUnmodifiableMap(UpgradeWrapper::upgrade, x -> x));
    }

    public record UpgradeWrapper<R extends UpgradeSerialiser<? extends T>, T extends UpgradeBase>(String id, T upgrade, R serialiser, String modId) {
    }
}

