/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client;

import com.mojang.blaze3d.platform.GlStateManager;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.client.MPOATVConstructingVertexConsumer;
import io.wispforest.accessories.client.PostEffectBuffer;
import io.wispforest.accessories.client.gui.AccessoriesInternalSlot;
import io.wispforest.accessories.client.gui.AccessoriesScreen;
import io.wispforest.accessories.compat.AccessoriesConfig;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import java.awt.Color;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4720;
import net.minecraft.class_583;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.lwjgl.opengl.GL30;

public class AccessoriesRenderLayer<T extends class_1309, M extends class_583<T>>
extends class_3887<T, M> {
    private static final PostEffectBuffer BUFFER = new PostEffectBuffer();
    private static final float increment = 0.1f;
    private static Map<String, Float> brightnessMap = new HashMap<String, Float>();
    private static Map<String, Float> opacityMap = new HashMap<String, Float>();
    private static long lastUpdated20th = 0L;

    public AccessoriesRenderLayer(class_3883<T, M> renderLayerParent) {
        super(renderLayerParent);
    }

    public void render(class_4587 poseStack, class_4597 multiBufferSource, int light, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        AccessoriesScreen accessoriesScreen;
        class_1735 class_17352;
        long current20th;
        boolean shouldUpdate;
        AccessoriesConfig.ClientData.HoverOptions highlightOptions = Accessories.getConfig().clientData.hoverOptions;
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        if (capability == null) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        float scale = (float)(1.0 + 0.5 * (0.75 + Math.sin((double)System.currentTimeMillis() / 250.0)));
        boolean renderingLines = AccessoriesScreen.COLLECT_ACCESSORY_POSITIONS;
        boolean useCustomerBuffer = AccessoriesScreen.IS_RENDERING_UI_ENTITY;
        if (!renderingLines && !AccessoriesScreen.NOT_VERY_NICE_POSITIONS.isEmpty()) {
            AccessoriesScreen.NOT_VERY_NICE_POSITIONS.clear();
        }
        if (multiBufferSource instanceof class_4597.class_4598) {
            class_4597.class_4598 bufferSource = (class_4597.class_4598)multiBufferSource;
            bufferSource.method_22993();
        }
        boolean bl = shouldUpdate = lastUpdated20th != (current20th = calendar.getTimeInMillis() / 50L);
        if (shouldUpdate) {
            lastUpdated20th = current20th;
        }
        class_437 screen = class_310.method_1551().field_1755;
        AccessoriesInternalSlot selected = null;
        if (screen instanceof AccessoriesScreen && (class_17352 = (accessoriesScreen = (AccessoriesScreen)screen).getHoveredSlot()) instanceof AccessoriesInternalSlot) {
            AccessoriesInternalSlot slot;
            selected = slot = (AccessoriesInternalSlot)class_17352;
        }
        for (Map.Entry<String, AccessoriesContainer> entry : capability.getContainers().entrySet()) {
            AccessoriesContainer container = entry.getValue();
            ExpandedSimpleContainer accessories = container.getAccessories();
            ExpandedSimpleContainer cosmetics = container.getCosmeticAccessories();
            boolean containerSelected = selected != null && selected.accessoriesContainer.slotType() == container.slotType();
            for (int i = 0; i < accessories.method_5439(); ++i) {
                AccessoryRenderer renderer;
                boolean isSelected;
                boolean bl2 = isSelected = containerSelected && selected.method_34266() == i;
                if (shouldUpdate) {
                    Float currentBrightness = brightnessMap.getOrDefault(entry.getKey() + i, Float.valueOf(1.0f));
                    Float currentOpacity = opacityMap.getOrDefault(entry.getKey() + i, Float.valueOf(1.0f));
                    if (selected != null && !isSelected) {
                        brightnessMap.put(entry.getKey() + i, Float.valueOf(Math.max(highlightOptions.unHoveredOptions.darkenedBrightness, currentBrightness.floatValue() - 0.1f)));
                        opacityMap.put(entry.getKey() + i, Float.valueOf(Math.max(highlightOptions.unHoveredOptions.darkenedOpacity, currentOpacity.floatValue() - 0.1f)));
                    } else {
                        brightnessMap.put(entry.getKey() + i, Float.valueOf(Math.min(1.0f, currentBrightness.floatValue() + 0.1f)));
                        opacityMap.put(entry.getKey() + i, Float.valueOf(Math.min(1.0f, currentOpacity.floatValue() + 0.1f)));
                    }
                }
                class_1799 stack = accessories.method_5438(i);
                class_1799 cosmeticStack = cosmetics.method_5438(i);
                if (!cosmeticStack.method_7960()) {
                    stack = cosmeticStack;
                }
                if (stack.method_7960() || (renderer = AccessoriesRendererRegistry.getRender(stack)) == null || !renderer.shouldRender(container.shouldRender(i))) continue;
                poseStack.method_22903();
                MPOATVConstructingVertexConsumer mpoatv = new MPOATVConstructingVertexConsumer();
                MutableBoolean bufferedGrabbedFlag = new MutableBoolean(false);
                class_4597 innerBufferSource = renderType -> {
                    bufferedGrabbedFlag.setValue(true);
                    return useCustomerBuffer ? class_4720.method_24037((class_4588)multiBufferSource.getBuffer(renderType), (class_4588)mpoatv) : multiBufferSource.getBuffer(renderType);
                };
                if (!AccessoriesScreen.IS_RENDERING_UI_ENTITY || isSelected || selected == null || highlightOptions.unHoveredOptions.renderUnHovered) {
                    renderer.render(stack, SlotReference.of(entity, container.getSlotName(), i), poseStack, this.method_17165(), innerBufferSource, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                }
                float[] colorValues = null;
                if (useCustomerBuffer && bufferedGrabbedFlag.getValue().booleanValue()) {
                    if (multiBufferSource instanceof class_4597.class_4598) {
                        class_4597.class_4598 bufferSource = (class_4597.class_4598)multiBufferSource;
                        if (highlightOptions.hoveredOptions.brightenHovered && isSelected) {
                            if (calendar.get(2) + 1 == 5 && calendar.get(5) == 16) {
                                float hue = (float)((double)System.currentTimeMillis() / 20.0 % 360.0 / 360.0);
                                Color color = new Color(class_3532.method_15369((float)hue, (float)1.0f, (float)1.0f));
                                colorValues = new float[]{(float)color.getRed() / 128.0f, (float)color.getGreen() / 128.0f, (float)color.getBlue() / 128.0f, 1.0f};
                            } else {
                                float mul = highlightOptions.hoveredOptions.cycleBrightness ? scale : 1.5f;
                                colorValues = new float[]{mul, mul, mul, 1.0f};
                            }
                        } else if (highlightOptions.unHoveredOptions.darkenUnHovered) {
                            Float darkness = brightnessMap.getOrDefault(entry.getKey() + i, Float.valueOf(1.0f));
                            colorValues = new float[]{darkness.floatValue(), darkness.floatValue(), darkness.floatValue(), opacityMap.getOrDefault(entry.getKey() + i, Float.valueOf(1.0f)).floatValue()};
                        }
                        if (colorValues != null) {
                            BUFFER.beginWrite(true, 256);
                            bufferSource.method_22993();
                            BUFFER.endWrite();
                            BUFFER.draw(colorValues);
                            class_276 frameBuffer = BUFFER.buffer();
                            GlStateManager._glBindFramebuffer((int)36008, (int)frameBuffer.field_1476);
                            GL30.glBlitFramebuffer((int)0, (int)0, (int)frameBuffer.field_1482, (int)frameBuffer.field_1481, (int)0, (int)0, (int)frameBuffer.field_1482, (int)frameBuffer.field_1481, (int)256, (int)9728);
                            class_310.method_1551().method_1522().method_1235(false);
                        } else {
                            bufferSource.method_22993();
                        }
                    }
                    if (renderingLines && AccessoriesScreen.IS_RENDERING_LINE_TARGET) {
                        AccessoriesScreen.NOT_VERY_NICE_POSITIONS.put(container.getSlotName() + i, mpoatv.meanPos());
                    }
                }
                poseStack.method_22909();
            }
        }
    }
}

