/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.fabric;

import io.netty.buffer.ByteBuf;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.networking.AccessoriesPackets;
import io.wispforest.accessories.networking.base.BaseNetworkHandler;
import io.wispforest.accessories.networking.base.HandledPacketPayload;
import io.wispforest.accessories.networking.base.NetworkBuilderRegister;
import io.wispforest.accessories.networking.base.PacketBuilderConsumer;
import io.wispforest.accessories.networking.base.Type;
import io.wispforest.endec.Endec;
import io.wispforest.endec.format.bytebuf.ByteBufDeserializer;
import io.wispforest.endec.format.bytebuf.ByteBufSerializer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class AccessoriesFabricNetworkHandler
extends BaseNetworkHandler {
    public static final AccessoriesFabricNetworkHandler INSTANCE = new AccessoriesFabricNetworkHandler(AccessoriesPackets::register);
    private final Map<Type<?>, PacketType<AccessoriesFabricPacket<?>>> packetTypes = new HashMap();

    protected AccessoriesFabricNetworkHandler(Consumer<NetworkBuilderRegister> builder) {
        super(Accessories.of("main"), builder);
    }

    @Override
    public void init() {
        super.init();
        this.s2cBuilders.forEach((location, builder) -> builder.registerPacket(this::registerS2CDeferred));
        this.c2sBuilders.forEach((location, builder) -> builder.registerPacket(this::registerC2S));
    }

    @Environment(value=EnvType.CLIENT)
    public void initClient(PacketBuilderConsumer registerS2C) {
        this.s2cBuilders.forEach((location, builder) -> builder.registerPacket(registerS2C::accept));
    }

    protected <M extends HandledPacketPayload> void registerC2S(Class<M> messageType, Endec<M> endec) {
        ServerPlayNetworking.registerGlobalReceiver(this.getOrCreateType(messageType, endec), (packet, player, sender) -> packet.innerPacket().handle((class_1657)player));
    }

    protected <M extends HandledPacketPayload> void registerS2CDeferred(Class<M> messageType, Endec<M> endec) {
        this.getOrCreateType(messageType, endec);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public <M extends HandledPacketPayload> void sendToServer(M packet) {
        ClientPlayNetworking.send(this.createFabricPacket(packet, true));
    }

    @Override
    public <M extends HandledPacketPayload> void sendToPlayer(class_3222 player, M packet) {
        ServerPlayNetworking.send((class_3222)player, this.createFabricPacket(packet, false));
    }

    @Override
    public <M extends HandledPacketPayload> void sendToTrackingAndSelf(class_1297 entity, Supplier<M> packet) {
        if (entity.method_37908().field_9236) {
            return;
        }
        for (class_3222 player : PlayerLookup.tracking((class_1297)entity)) {
            this.sendToPlayer(player, (HandledPacketPayload)packet.get());
        }
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            this.sendToPlayer(serverPlayer, (HandledPacketPayload)packet.get());
        }
    }

    @Nullable
    public <M extends HandledPacketPayload> PacketType<AccessoriesFabricPacket<?>> get(Class<M> mClass) {
        return this.packetTypes.get(this.getId(mClass));
    }

    private <P extends HandledPacketPayload> AccessoriesFabricPacket<P> createFabricPacket(P packet, boolean isClient) {
        return new AccessoriesFabricPacket<P>(packet, this.getEndec(packet.getClass(), isClient));
    }

    public <M extends HandledPacketPayload> PacketType<AccessoriesFabricPacket<?>> getOrCreateType(Class<M> messageType, Endec<M> endec) {
        return this.packetTypes.computeIfAbsent(this.getId(messageType), location -> PacketType.create((class_2960)location.location(), buf -> {
            HandledPacketPayload innerData = (HandledPacketPayload)endec.decodeFully(ByteBufDeserializer::of, buf);
            return new AccessoriesFabricPacket<HandledPacketPayload>(innerData, endec);
        }));
    }

    public <P extends HandledPacketPayload> Endec<P> getEndec(Class<P> clazz, boolean isClient) {
        return ((BaseNetworkHandler.PacketBuilder)(isClient ? this.c2sBuilders : this.s2cBuilders).get(this.getId(clazz))).endec();
    }

    public record AccessoriesFabricPacket<P extends HandledPacketPayload>(P innerPacket, Endec<P> endec) implements FabricPacket
    {
        public void write(class_2540 buf) {
            this.endec.encodeFully(() -> ByteBufSerializer.of((ByteBuf)buf), this.innerPacket);
        }

        public PacketType<?> getType() {
            Class<?> clazz = this.innerPacket.getClass();
            PacketType<AccessoriesFabricPacket<?>> packetType = INSTANCE.get(clazz);
            if (packetType == null) {
                throw new IllegalStateException("Unable to get the FabricPacket Type for the following class! [Name: " + String.valueOf(clazz) + "]");
            }
            return packetType;
        }
    }

    public static interface RegistrationFunc {
        public <M extends HandledPacketPayload> void consume(Class<M> var1, Endec<M> var2);
    }
}

