/*
 * Decompiled with CFR 0.152.
 */
package us.mikebartosh.minecraft;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import us.mikebartosh.minecraft.CopperCoins;

public class CoinBlock
extends class_2383 {
    private static final Map<CoinType, Map<class_2350, class_265[]>> SHAPES = new EnumMap<CoinType, Map<class_2350, class_265[]>>(CoinType.class);
    public static final class_2754<CoinType> TYPE = class_2754.method_11850((String)"type", CoinType.class);
    public static final class_2758 COUNT = class_2758.method_11867((String)"count", (int)1, (int)4);
    public static final class_2753 FACING = class_2383.field_11177;

    public CoinBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)COUNT, (Comparable)Integer.valueOf(1))).method_11657(TYPE, (Comparable)((Object)CoinType.COPPER)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, COUNT, TYPE});
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!world.field_9236) {
            boolean matchesType;
            int current = (Integer)state.method_11654((class_2769)COUNT);
            CoinType type = (CoinType)((Object)state.method_11654(TYPE));
            class_1799 held = player.method_5998(hand);
            int limit = type == CoinType.SILVER ? 4 : 3;
            boolean bl = matchesType = type == CoinType.COPPER && held.method_31574(CopperCoins.COPPER_COIN) || type == CoinType.SILVER && held.method_31574(CopperCoins.SILVER_COIN) || type == CoinType.GOLD && held.method_31574(CopperCoins.GOLD_COIN);
            if (current < limit && matchesType && !held.method_7960()) {
                if (!player.method_7337()) {
                    held.method_7934(1);
                }
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)COUNT, (Comparable)Integer.valueOf(current + 1)), 3);
                world.method_8396(null, pos, class_3417.field_14844, class_3419.field_15245, 1.0f, 1.0f);
            } else if (player.method_5715()) {
                int newCount;
                class_1799 coin;
                switch (type.ordinal()) {
                    case 1: {
                        class_1799 class_17992 = new class_1799((class_1935)CopperCoins.SILVER_COIN);
                        break;
                    }
                    case 2: {
                        class_1799 class_17992 = new class_1799((class_1935)CopperCoins.GOLD_COIN);
                        break;
                    }
                    default: {
                        class_1799 class_17992 = coin = new class_1799((class_1935)CopperCoins.COPPER_COIN);
                    }
                }
                if (!player.method_7337()) {
                    CoinBlock.method_9577((class_1937)world, (class_2338)pos, (class_1799)coin);
                }
                if ((newCount = current - 1) <= 0) {
                    world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
                } else {
                    world.method_8652(pos, (class_2680)state.method_11657((class_2769)COUNT, (Comparable)Integer.valueOf(newCount)), 3);
                }
                world.method_8396(null, pos, class_3417.field_15197, class_3419.field_15245, 1.0f, 1.0f);
            }
        }
        return class_1269.field_5812;
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_1799 stack = ctx.method_8041();
        CoinType type = CoinType.COPPER;
        if (stack.method_31574(CopperCoins.SILVER_COIN)) {
            type = CoinType.SILVER;
        }
        if (stack.method_31574(CopperCoins.GOLD_COIN)) {
            type = CoinType.GOLD;
        }
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042().method_10153())).method_11657(TYPE, (Comparable)((Object)type));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 dir = (class_2350)state.method_11654((class_2769)FACING);
        int countIndex = (Integer)state.method_11654((class_2769)COUNT) - 1;
        CoinType type = (CoinType)((Object)state.method_11654(TYPE));
        Map<class_2350, class_265[]> dirMap = SHAPES.get((Object)type);
        if (dirMap == null) {
            return class_259.method_1073();
        }
        class_265[] shapes = dirMap.get(dir);
        if (shapes == null || shapes.length == 0) {
            return class_259.method_1073();
        }
        int idx = Math.max(0, Math.min(countIndex, shapes.length - 1));
        return shapes[idx];
    }

    private static class_265 rotateShape(class_2350 to, class_265 shape) {
        class_265[] buffer = new class_265[]{shape, class_259.method_1073()};
        int times = (to.method_10161() - class_2350.field_11043.method_10161() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = class_259.method_1084((class_265)buffer[1], (class_265)class_259.method_1081((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = class_259.method_1073();
        }
        return buffer[0];
    }

    static {
        for (CoinType type : CoinType.values()) {
            EnumMap<class_2350, class_265[]> dirMap = new EnumMap<class_2350, class_265[]>(class_2350.class);
            class_265[] bases = Hitboxes.forType(type);
            int desiredCount = type == CoinType.SILVER ? 4 : bases.length;
            for (class_2350 dir : class_2350.class_2353.field_11062) {
                class_265[] rotated = new class_265[desiredCount];
                for (int i = 0; i < desiredCount; ++i) {
                    class_265 base = i < bases.length ? bases[i] : bases[bases.length - 1];
                    rotated[i] = CoinBlock.rotateShape(dir, base);
                }
                dirMap.put(dir, rotated);
            }
            SHAPES.put(type, dirMap);
        }
    }

    public static enum CoinType implements class_3542
    {
        COPPER("copper"),
        SILVER("silver"),
        GOLD("gold");

        private final String name;

        private CoinType(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }

    private static class Hitboxes {
        static final class_265 COPPER_3_1 = class_259.method_1081((double)0.71875, (double)0.046875, (double)0.09375, (double)0.90625, (double)0.109375, (double)0.40625);
        static final class_265 COPPER_3_2 = class_259.method_1081((double)0.65625, (double)0.046875, (double)0.15625, (double)0.71875, (double)0.109375, (double)0.34375);
        static final class_265 COPPER_3_3 = class_259.method_1081((double)0.90625, (double)0.046875, (double)0.15625, (double)0.96875, (double)0.109375, (double)0.34375);
        static final class_265 COPPER_1_1 = class_259.method_1081((double)0.30192875, (double)0.0, (double)0.307765625, (double)0.61442875, (double)0.0625, (double)0.495265625);
        static final class_265 COPPER_1_2 = class_259.method_1081((double)0.36442875, (double)0.0, (double)0.245265625, (double)0.55192875, (double)0.0625, (double)0.307765625);
        static final class_265 COPPER_1_3 = class_259.method_1081((double)0.36442875, (double)0.0, (double)0.495265625, (double)0.55192875, (double)0.0625, (double)0.557765625);
        static final class_265 COPPER_2_1 = class_259.method_1081((double)0.46875, (double)0.0, (double)0.25, (double)0.78125, (double)0.0625, (double)0.4375);
        static final class_265 COPPER_2_2 = class_259.method_1081((double)0.53125, (double)0.0, (double)0.1875, (double)0.71875, (double)0.0625, (double)0.25);
        static final class_265 COPPER_2_3 = class_259.method_1081((double)0.53125, (double)0.0, (double)0.4375, (double)0.71875, (double)0.0625, (double)0.5);
        static final class_265 COPPER_SHAPE_1 = class_259.method_17786((class_265)COPPER_1_1, (class_265[])new class_265[]{COPPER_1_2, COPPER_1_3});
        static final class_265 COPPER_SHAPE_2 = class_259.method_17786((class_265)COPPER_2_1, (class_265[])new class_265[]{COPPER_2_2, COPPER_2_3, COPPER_SHAPE_1});
        static final class_265 COPPER_SHAPE_3 = class_259.method_17786((class_265)COPPER_3_1, (class_265[])new class_265[]{COPPER_3_2, COPPER_3_3, COPPER_SHAPE_1, COPPER_SHAPE_2});
        static final class_265 SILVER_4_1 = class_259.method_1081((double)0.44, (double)0.0, (double)0.01125, (double)0.565, (double)0.0625, (double)0.26125);
        static final class_265 SILVER_4_2 = class_259.method_1081((double)0.565, (double)0.0, (double)0.07375, (double)0.6275, (double)0.0625, (double)0.19875);
        static final class_265 SILVER_4_3 = class_259.method_1081((double)0.3775, (double)0.0, (double)0.07375, (double)0.44, (double)0.0625, (double)0.19875);
        static final class_265 SILVER_1_1 = class_259.method_1081((double)0.730625, (double)0.0, (double)0.095625, (double)0.855625, (double)0.0625, (double)0.345625);
        static final class_265 SILVER_1_2 = class_259.method_1081((double)0.668125, (double)0.0, (double)0.158125, (double)0.730625, (double)0.0625, (double)0.283125);
        static final class_265 SILVER_1_3 = class_259.method_1081((double)0.855625, (double)0.0, (double)0.158125, (double)0.918125, (double)0.0625, (double)0.283125);
        static final class_265 SILVER_2_1 = class_259.method_1081((double)0.44, (double)0.0, (double)0.38625, (double)0.565, (double)0.0625, (double)0.63625);
        static final class_265 SILVER_2_2 = class_259.method_1081((double)0.565625, (double)0.0, (double)0.44875, (double)0.628125, (double)0.0625, (double)0.57375);
        static final class_265 SILVER_2_3 = class_259.method_1081((double)0.3775, (double)0.0, (double)0.44875, (double)0.44, (double)0.0625, (double)0.57375);
        static final class_265 SILVER_3_1 = class_259.method_1081((double)0.75, (double)0.046875, (double)0.296875, (double)0.875, (double)0.109375, (double)0.546875);
        static final class_265 SILVER_3_2 = class_259.method_1081((double)0.6875, (double)0.046875, (double)0.359375, (double)0.75, (double)0.109375, (double)0.484375);
        static final class_265 SILVER_3_3 = class_259.method_1081((double)0.875, (double)0.046875, (double)0.359375, (double)0.9375, (double)0.109375, (double)0.484375);
        static final class_265 SILVER_SHAPE_1 = class_259.method_17786((class_265)SILVER_1_1, (class_265[])new class_265[]{SILVER_1_2, SILVER_1_3});
        static final class_265 SILVER_SHAPE_2 = class_259.method_17786((class_265)SILVER_2_1, (class_265[])new class_265[]{SILVER_2_2, SILVER_2_3, SILVER_SHAPE_1});
        static final class_265 SILVER_SHAPE_3 = class_259.method_17786((class_265)SILVER_3_1, (class_265[])new class_265[]{SILVER_3_2, SILVER_3_3, SILVER_SHAPE_1, SILVER_SHAPE_2});
        static final class_265 SILVER_SHAPE_4 = class_259.method_17786((class_265)SILVER_4_1, (class_265[])new class_265[]{SILVER_4_2, SILVER_4_3, SILVER_SHAPE_1, SILVER_SHAPE_2, SILVER_SHAPE_3});
        static final class_265 GOLD_1 = class_259.method_1081((double)0.296875, (double)0.0, (double)0.390625, (double)0.546875, (double)0.0625, (double)0.453125);
        static final class_265 GOLD_1B = class_259.method_1081((double)0.296875, (double)0.0, (double)0.703125, (double)0.546875, (double)0.0625, (double)0.765625);
        static final class_265 GOLD_1C = class_259.method_1081((double)0.234375, (double)0.0, (double)0.453125, (double)0.609375, (double)0.0625, (double)0.703125);
        static final class_265 GOLD_2A = class_259.method_1081((double)0.504888125, (double)0.0, (double)0.142473125, (double)0.879888125, (double)0.0625, (double)0.392473125);
        static final class_265 GOLD_2B = class_259.method_1081((double)0.567388125, (double)0.0, (double)0.079973125, (double)0.817388125, (double)0.0625, (double)0.142473125);
        static final class_265 GOLD_2C = class_259.method_1081((double)0.567388125, (double)0.0, (double)0.392473125, (double)0.817388125, (double)0.0625, (double)0.454973125);
        static final class_265 GOLD_3A = class_259.method_1081((double)0.598638125, (double)0.03125, (double)0.439348125, (double)0.848638125, (double)0.09375, (double)0.501848125);
        static final class_265 GOLD_3B = class_259.method_1081((double)0.598638125, (double)0.03125, (double)0.751848125, (double)0.848638125, (double)0.09375, (double)0.814348125);
        static final class_265 GOLD_3C = class_259.method_1081((double)0.536138125, (double)0.03125, (double)0.501848125, (double)0.911138125, (double)0.09375, (double)0.751848125);
        static final class_265 GOLD_SHAPE_1 = class_259.method_17786((class_265)GOLD_1, (class_265[])new class_265[]{GOLD_1B, GOLD_1C});
        static final class_265 GOLD_SHAPE_2 = class_259.method_17786((class_265)GOLD_2A, (class_265[])new class_265[]{GOLD_2B, GOLD_2C, GOLD_SHAPE_1});
        static final class_265 GOLD_SHAPE_3 = class_259.method_17786((class_265)GOLD_3A, (class_265[])new class_265[]{GOLD_3B, GOLD_3C, GOLD_SHAPE_1, GOLD_SHAPE_2});

        private Hitboxes() {
        }

        static class_265[] forType(CoinType type) {
            class_265[] class_265Array;
            switch (type.ordinal()) {
                case 1: {
                    class_265[] class_265Array2 = new class_265[4];
                    class_265Array2[0] = SILVER_SHAPE_1;
                    class_265Array2[1] = SILVER_SHAPE_2;
                    class_265Array2[2] = SILVER_SHAPE_3;
                    class_265Array = class_265Array2;
                    class_265Array2[3] = SILVER_SHAPE_4;
                    break;
                }
                case 2: {
                    class_265[] class_265Array3 = new class_265[3];
                    class_265Array3[0] = GOLD_SHAPE_1;
                    class_265Array3[1] = GOLD_SHAPE_2;
                    class_265Array = class_265Array3;
                    class_265Array3[2] = GOLD_SHAPE_3;
                    break;
                }
                default: {
                    class_265[] class_265Array4 = new class_265[3];
                    class_265Array4[0] = COPPER_SHAPE_1;
                    class_265Array4[1] = COPPER_SHAPE_2;
                    class_265Array = class_265Array4;
                    class_265Array4[2] = COPPER_SHAPE_3;
                }
            }
            return class_265Array;
        }
    }
}

