/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.util.config;

import com.blackgear.platform.core.events.ServerLifecycleEvents;
import com.blackgear.platform.core.mixin.access.LevelResourceAccessor;
import com.blackgear.platform.core.network.MessageHandler;
import com.blackgear.platform.core.network.listener.ServerListenerEvents;
import com.blackgear.platform.core.network.packet.ConfigSyncPacket;
import com.blackgear.platform.core.util.config.ConfigTracker;
import com.blackgear.platform.core.util.config.ModConfig;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigLoader {
    public static final Logger LOGGER = LogManager.getLogger();
    static final class_5218 SERVERCONFIG = LevelResourceAccessor.createLevelResource("serverconfig");

    private static Path getServerConfigPath(MinecraftServer server) {
        Path config = server.method_27050(SERVERCONFIG);
        ConfigLoader.getOrCreateDirectory(config, "serverconfig");
        return config;
    }

    public static void bootstrap() {
        ServerLifecycleEvents.STARTING.register(server -> ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.SERVER, ConfigLoader.getServerConfigPath(server)));
        ServerLifecycleEvents.STOPPING.register(server -> ConfigTracker.INSTANCE.unloadConfigs(ModConfig.Type.SERVER, ConfigLoader.getServerConfigPath(server)));
        ServerListenerEvents.JOIN.register((handler, server) -> {
            class_3222 player = handler.field_14140;
            if (server.method_19466(player.method_7334())) {
                return;
            }
            ConfigTracker.INSTANCE.configSets().get((Object)ModConfig.Type.SERVER).forEach(config -> {
                try {
                    String name = config.getFileName();
                    byte[] data = Files.readAllBytes(config.getFullPath());
                    ConfigSyncPacket packet = new ConfigSyncPacket(name, data);
                    MessageHandler.DEFAULT_CHANNEL.sendToPlayer(packet, (class_1657)player);
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
            });
        });
    }

    private static void getOrCreateDirectory(Path dirPath, String dirLabel) {
        if (!Files.isDirectory(dirPath.getParent(), new LinkOption[0])) {
            ConfigLoader.getOrCreateDirectory(dirPath.getParent(), "parent of " + dirLabel);
        }
        if (!Files.isDirectory(dirPath, new LinkOption[0])) {
            LOGGER.debug("Making {} directory : {}", (Object)dirLabel, (Object)dirPath);
            try {
                Files.createDirectory(dirPath, new FileAttribute[0]);
            }
            catch (IOException exception) {
                if (exception instanceof FileAlreadyExistsException) {
                    LOGGER.fatal("Failed to create {} directory - there is a file in the way", (Object)dirLabel);
                } else {
                    LOGGER.fatal("Problem with creating {} directory (Permissions?)", (Object)dirLabel, (Object)exception);
                }
                throw new RuntimeException("Problem creating directory", exception);
            }
            LOGGER.debug("Created {} directory : {}", (Object)dirLabel, (Object)dirPath);
        } else {
            LOGGER.debug("Found existing {} directory : {}", (Object)dirLabel, (Object)dirPath);
        }
    }
}

