/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut.config;

import com.corosus.watut.config.ConfigServerControlledSyncedToClient;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2487;

public class ConfigServerSyncHelper {
    private static ConfigServerSyncHelper instance;
    private HashMap<String, Class> settingsTypes = new HashMap();
    private HashMap<String, Field> cache = new HashMap();

    public static ConfigServerSyncHelper getInstance() {
        if (instance == null) {
            instance = new ConfigServerSyncHelper();
            instance.init();
        }
        return instance;
    }

    private void init() {
        for (Field field : ConfigServerControlledSyncedToClient.class.getDeclaredFields()) {
            this.add(field);
        }
    }

    public class_2487 getSyncableConfigOnServer() {
        class_2487 nbt = new class_2487();
        try {
            for (Map.Entry<String, Class> entry : this.settingsTypes.entrySet()) {
                String name = entry.getKey();
                Class clazz = entry.getValue();
                Object value = this.getFieldValue(name);
                if (value == null) continue;
                if (clazz == Integer.TYPE) {
                    nbt.method_10569(name, ((Integer)value).intValue());
                    continue;
                }
                if (clazz == Float.TYPE) {
                    nbt.method_10548(name, ((Float)value).floatValue());
                    continue;
                }
                if (clazz == Double.TYPE) {
                    nbt.method_10549(name, ((Double)value).doubleValue());
                    continue;
                }
                if (clazz == String.class) {
                    nbt.method_10582(name, (String)value);
                    continue;
                }
                if (clazz != Boolean.TYPE) continue;
                nbt.method_10556(name, ((Boolean)value).booleanValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nbt;
    }

    public void updateSyncableConfigOnClient(class_2487 nbt) {
        try {
            for (Map.Entry<String, Class> entry : this.settingsTypes.entrySet()) {
                String name = entry.getKey();
                Class value = entry.getValue();
                if (value == Integer.TYPE) {
                    this.setFieldValue(name, nbt.method_10550(name));
                    continue;
                }
                if (value == Float.TYPE) {
                    this.setFieldValue(name, Float.valueOf(nbt.method_10583(name)));
                    continue;
                }
                if (value == Double.TYPE) {
                    this.setFieldValue(name, nbt.method_10574(name));
                    continue;
                }
                if (value == String.class) {
                    this.setFieldValue(name, nbt.method_10558(name));
                    continue;
                }
                if (value != Boolean.TYPE) continue;
                this.setFieldValue(name, nbt.method_10577(name));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setFieldValue(String name, Object value) {
        if (!this.cache.containsKey(name)) {
            try {
                Field field = ConfigServerControlledSyncedToClient.class.getDeclaredField(name);
                this.cache.put(name, field);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        try {
            this.cache.get(name).set(null, value);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private Object getFieldValue(String name) {
        if (!this.cache.containsKey(name)) {
            try {
                Field field = ConfigServerControlledSyncedToClient.class.getDeclaredField(name);
                this.cache.put(name, field);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        try {
            return this.cache.get(name).get(null);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void add(Field field) {
        this.settingsTypes.put(field.getName(), field.getType());
    }
}

