/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.entity;

import com.google.common.collect.Lists;
import com.ninni.spawn.SpawnTags;
import com.ninni.spawn.block.SnailEggsBlock;
import com.ninni.spawn.registry.SpawnBlocks;
import com.ninni.spawn.registry.SpawnItems;
import com.ninni.spawn.registry.SpawnSoundEvents;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1920;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6019;
import net.minecraft.class_8103;
import org.jetbrains.annotations.Nullable;

public class Snail
extends class_1429 {
    private static final class_2940<Integer> SCARED_TICKS = class_2945.method_12791(Snail.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> WET_TICKS = class_2945.method_12791(Snail.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> SHELL_GROWTH = class_2945.method_12791(Snail.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> HAS_EGG = class_2945.method_12791(Snail.class, (class_2941)class_2943.field_13323);
    private final class_6019 regrowthTicks = class_6019.method_35017((int)12000, (int)24000);
    private int cooldown = 2;

    public Snail(class_1299<? extends Snail> entityType, class_1937 world) {
        super(entityType, world);
        this.method_49477(1.0f);
    }

    public boolean method_6481(class_1799 itemStack) {
        return itemStack.method_31573(SpawnTags.SNAIL_FEEDS);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(2, (class_1352)new SnailLayEggGoal(this));
        this.field_6201.method_6277(2, (class_1352)new class_1391((class_1314)this, 1.25, class_1856.method_8106(SpawnTags.SNAIL_TEMPTS), false));
        this.field_6201.method_6277(5, (class_1352)new class_1353((class_1429)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new SnailWanderGoal(this, 1.0));
        this.field_6201.method_6277(7, (class_1352)new SnailLookAtEntityGoal(this, class_1657.class, 6.0f));
        this.field_6201.method_6277(8, (class_1352)new SnailLookAroundGoal(this));
    }

    public void method_24650(class_3218 world, class_1429 other) {
        if (other instanceof Snail) {
            Snail otherSnail = (Snail)other;
            class_3222 serverPlayerEntity = this.method_6478();
            if (serverPlayerEntity == null) {
                serverPlayerEntity = otherSnail.method_6478();
            }
            if (serverPlayerEntity != null) {
                serverPlayerEntity.method_7281(class_3468.field_15410);
                class_174.field_1190.method_855(serverPlayerEntity, (class_1429)this, (class_1429)otherSnail, null);
                class_174.field_1190.method_855(serverPlayerEntity, (class_1429)otherSnail, (class_1429)this, null);
            }
            this.method_5614(6000);
            otherSnail.method_5614(6000);
            this.method_6477();
            otherSnail.method_6477();
            this.setHasEgg(true);
            otherSnail.setHasEgg(true);
            world.method_8421((class_1297)this, (byte)18);
            if (world.method_8450().method_8355(class_1928.field_19391)) {
                world.method_8649((class_1297)new class_1303((class_1937)world, this.method_23317(), this.method_23318(), this.method_23321(), this.method_6051().method_43048(7) + 1));
            }
        }
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 6.0).method_26868(class_5134.field_23718, 1.0).method_26868(class_5134.field_23719, 0.1);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SCARED_TICKS, (Object)0);
        this.field_6011.method_12784(WET_TICKS, (Object)0);
        this.field_6011.method_12784(SHELL_GROWTH, (Object)0);
        this.field_6011.method_12784(HAS_EGG, (Object)false);
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10569("ScaredTicks", this.getScaredTicks());
        compoundTag.method_10569("WetTicks", this.getWetTicks());
        compoundTag.method_10569("Shelled", this.getShellGrowthTicks());
        compoundTag.method_10556("HasEgg", this.hasEgg());
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.setScaredTicks(compoundTag.method_10550("ScaredTicks"));
        this.setWetTicks(compoundTag.method_10550("WetTicks"));
        this.setShellGrowthTicks(compoundTag.method_10550("Shelled"));
        this.setHasEgg(compoundTag.method_10577("HasEgg"));
    }

    public int getScaredTicks() {
        return (Integer)this.field_6011.method_12789(SCARED_TICKS);
    }

    public void setScaredTicks(int scaredTicks) {
        this.field_6011.method_12778(SCARED_TICKS, (Object)scaredTicks);
    }

    public boolean isScared() {
        return this.getScaredTicks() > 0;
    }

    public boolean hasEgg() {
        return (Boolean)this.field_6011.method_12789(HAS_EGG);
    }

    public void setHasEgg(boolean hasEgg) {
        this.field_6011.method_12778(HAS_EGG, (Object)hasEgg);
    }

    public int getWetTicks() {
        return (Integer)this.field_6011.method_12789(WET_TICKS);
    }

    public void setWetTicks(int wetTicks) {
        this.field_6011.method_12778(WET_TICKS, (Object)wetTicks);
    }

    public void addWetTicks(int wetTicks) {
        this.setWetTicks(this.getWetTicks() + wetTicks);
    }

    public int getShellGrowthTicks() {
        return (Integer)this.field_6011.method_12789(SHELL_GROWTH);
    }

    public void setShellGrowthTicks(int shellTicks) {
        this.field_6011.method_12778(SHELL_GROWTH, (Object)shellTicks);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (this.method_6481(itemStack) && this.method_5618() == 0) {
            if (itemStack.method_31574(class_1802.field_8208)) {
                this.method_5706((class_1935)class_1802.field_8428);
            }
            this.method_5783(SpawnSoundEvents.SNAIL_EAT, 1.0f, 1.0f);
        }
        if (itemStack.method_31574(class_1802.field_8705) && !this.isScared() && this.getWetTicks() < 900) {
            if (!this.method_37908().field_9236) {
                if (!player.method_31549().field_7477) {
                    player.method_6122(player.method_6058(), class_1802.field_8550.method_7854());
                }
                this.addWetTicks(300);
                this.method_5783(class_3417.field_14834, 1.0f, 1.0f);
                return class_1269.field_5812;
            }
            return class_1269.field_21466;
        }
        return super.method_5992(player, hand);
    }

    public void method_6007() {
        int shellGrowthTicks;
        super.method_6007();
        if (this.getWetTicks() > 0) {
            this.addWetTicks(-1);
            if (this.field_5974.method_43048(10) == 0) {
                this.method_37908().method_8406((class_2394)class_2398.field_18306, this.method_23322(0.6), this.method_23318() + this.field_5974.method_43058(), this.method_23325(0.6), 0.0, 0.0, 0.0);
            }
        }
        if (this.method_25936().method_26164(SpawnTags.MUCUS_SOLIDIFIER) || this.method_5721()) {
            this.addWetTicks(1);
        }
        if (!this.method_37908().field_9236 && this.method_24828() && this.getWetTicks() > 0) {
            class_2680 blockState = SpawnBlocks.MUCUS.method_9564();
            for (int l = 0; l < 4; ++l) {
                if (this.cooldown >= 0) continue;
                int i = class_3532.method_15357((double)(this.method_23317() + (double)((float)(l % 2 * 2 - 1) * 0.25f)));
                class_2338 blockPos2 = new class_2338(i, class_3532.method_15357((double)this.method_23318()), class_3532.method_15357((double)(this.method_23321() + (double)((float)(l / 2 % 2 * 2 - 1) * 0.25f))));
                if (!this.method_37908().method_8320(blockPos2).method_26215() || !blockState.method_26184((class_4538)this.method_37908(), blockPos2)) continue;
                this.method_37908().method_8501(blockPos2, blockState);
                this.cooldown = 10;
                this.method_5712(blockPos2, blockState);
                this.method_37908().method_43276(class_5712.field_28164, blockPos2, class_5712.class_7397.method_43286((class_1297)this, (class_2680)blockState));
            }
            --this.cooldown;
        }
        this.method_37908().method_8390(class_1657.class, this.method_5829().method_1014(2.0), this::isValidEntity).forEach(player -> this.setScaredTicks(100));
        if (this.getScaredTicks() > 0) {
            this.method_5942().method_6340();
            this.setScaredTicks(this.getScaredTicks() - 1);
        }
        if (!this.method_37908().method_8608() && (shellGrowthTicks = this.getShellGrowthTicks()) > 0 && !this.method_6109()) {
            if (shellGrowthTicks == 1) {
                this.method_5783(SpawnSoundEvents.SNAIL_SHELL_GROW, 1.0f, 1.0f);
            }
            this.setShellGrowthTicks(shellGrowthTicks - 1);
        }
    }

    private boolean isValidEntity(class_1657 entity) {
        return this.getShellGrowthTicks() == 0 && !entity.method_7325() && entity.method_5805() && !entity.method_31549().field_7477 && !entity.method_5715();
    }

    public boolean method_5810() {
        return !this.isScared();
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (!this.method_37908().field_9236 && this.getShellGrowthTicks() == 0) {
            if (source.method_48789(class_8103.field_42247)) {
                if (!this.isScared()) {
                    this.method_5699(new class_1799((class_1935)SpawnItems.SNAIL_SHELL), 0.1f);
                    this.method_5783(SpawnSoundEvents.SNAIL_HURT_HIDDEN, 1.0f, 1.0f);
                    this.setShellGrowthTicks(this.regrowthTicks.method_35008(this.field_5974));
                }
                return false;
            }
            this.setScaredTicks(100);
        }
        if (source.method_5529() instanceof class_1309 && amount < 12.0f && !this.method_37908().field_9236 && this.isScared()) {
            this.method_5783(SpawnSoundEvents.SNAIL_HURT_HIDDEN, 1.0f, 1.0f);
            return false;
        }
        return super.method_5643(source, amount);
    }

    public boolean method_30948() {
        return this.isScared();
    }

    public void method_6091(class_243 vec3) {
        if (this.isScared()) {
            this.method_18799(this.method_18798().method_18805(0.0, 1.0, 0.0));
            vec3 = vec3.method_18805(0.0, 1.0, 0.0);
        }
        super.method_6091(vec3);
    }

    @Nullable
    protected class_3414 method_5994() {
        return "Gary".equals(class_124.method_539((String)this.method_5477().getString())) ? class_3417.field_15051 : super.method_5994();
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return SpawnSoundEvents.SNAIL_HURT;
    }

    @Nullable
    protected class_3414 method_6002() {
        return this.isScared() ? SpawnSoundEvents.SNAIL_DEATH_HIDDEN : SpawnSoundEvents.SNAIL_DEATH;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(SpawnSoundEvents.SNAIL_SLIDE, 0.15f, 1.0f);
    }

    @Nullable
    public class_1296 method_5613(class_3218 serverLevel, class_1296 ageableMob) {
        return null;
    }

    public static boolean canSpawn(class_1299<Snail> snailEntityEntityType, class_5425 world, class_3730 mobSpawnType, class_2338 pos, class_5819 randomSource) {
        return world.method_8320(pos.method_10074()).method_26164(class_3481.field_35567) && class_1429.method_39448((class_1920)world, (class_2338)pos);
    }

    public static class SnailLayEggGoal
    extends class_1352 {
        private final Snail snail;
        private class_2338 layPos;

        SnailLayEggGoal(Snail snail) {
            this.snail = snail;
        }

        public boolean method_6264() {
            class_2338 layPos = this.getLayPosition();
            if (this.layPos == null && layPos != null) {
                this.layPos = layPos;
            }
            return this.layPos != null && this.snail.hasEgg();
        }

        public boolean method_6266() {
            return this.layPos != null && this.snail.method_37908().method_8320(this.layPos).method_26164(class_3481.field_29822) && this.snail.method_37908().method_8320(this.layPos.method_10084()).method_26215();
        }

        public void method_6269() {
            if (this.layPos != null) {
                class_243 vec3d = class_243.method_24953((class_2382)this.layPos);
                this.snail.method_5942().method_6337(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, 1.0);
                this.snail.method_5988().method_19615(vec3d);
            }
        }

        public void method_6268() {
            class_243 vec3d;
            double distance;
            if (this.layPos != null && (distance = (double)class_3532.method_15355((float)((float)this.snail.method_5707(vec3d = class_243.method_24953((class_2382)this.layPos))))) <= 2.0) {
                this.snail.method_5783(SpawnSoundEvents.SNAIL_LAY_EGGS, 1.0f, 1.0f);
                this.snail.method_37908().method_8652(this.layPos, (class_2680)SpawnBlocks.SNAIL_EGGS.method_9564().method_11657((class_2769)SnailEggsBlock.method_33374((class_2350)class_2350.field_11033), (Comparable)Boolean.valueOf(true)), 2);
                this.snail.setHasEgg(false);
            }
        }

        @Nullable
        private class_2338 getLayPosition() {
            ArrayList list = Lists.newArrayList();
            int range = 8;
            for (int x = -range; x <= range; ++x) {
                for (int z = -range; z <= range; ++z) {
                    class_2338 position = new class_2338((int)this.snail.method_23317() + x, (int)this.snail.method_23318(), (int)this.snail.method_23321() + z);
                    if (!this.snail.method_37908().method_8320(position.method_10074()).method_26164(class_3481.field_29822) || !this.snail.method_37908().method_8320(position).method_26215()) continue;
                    list.add(position);
                }
            }
            if (list.isEmpty()) {
                return null;
            }
            return (class_2338)list.get(this.snail.field_5974.method_43048(list.size()));
        }
    }

    public static class SnailWanderGoal
    extends class_1394 {
        private final Snail mob;

        public SnailWanderGoal(Snail mob, double d) {
            super((class_1314)mob, d);
            this.mob = mob;
        }

        public void method_6269() {
            super.method_6269();
        }

        public boolean method_6264() {
            return super.method_6264() && !this.mob.isScared();
        }

        public boolean method_6266() {
            return super.method_6266() && !this.mob.isScared();
        }
    }

    public static class SnailLookAtEntityGoal
    extends class_1361 {
        private final Snail mob;

        public SnailLookAtEntityGoal(Snail mob, Class<? extends class_1309> targetType, float range) {
            super((class_1308)mob, targetType, range);
            this.mob = mob;
        }

        public boolean method_6264() {
            return super.method_6264() && !this.mob.isScared();
        }

        public boolean method_6266() {
            return super.method_6266() && !this.mob.isScared();
        }
    }

    public static class SnailLookAroundGoal
    extends class_1376 {
        private final Snail mob;

        public SnailLookAroundGoal(Snail mob) {
            super((class_1308)mob);
            this.mob = mob;
        }

        public boolean method_6264() {
            return super.method_6264() && !this.mob.isScared();
        }

        public boolean method_6266() {
            return super.method_6266() && !this.mob.isScared();
        }
    }
}

