/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.networking;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.networking.events.GridPowerStorageStateChanged;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.AECableType;
import appeng.block.networking.EnergyCellBlock;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.me.energy.StoredEnergyAmount;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import org.jetbrains.annotations.Nullable;

public class EnergyCellBlockEntity
extends AENetworkBlockEntity
implements IAEPowerStorage,
IGridTickable {
    private final StoredEnergyAmount stored;
    private byte currentDisplayLevel;
    private boolean neighborChangePending;

    public EnergyCellBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setIdlePowerUsage(0.0).addService(IAEPowerStorage.class, this).addService(IGridTickable.class, this);
        EnergyCellBlock cellBlock = (EnergyCellBlock)this.method_11010().method_26204();
        this.stored = new StoredEnergyAmount(0.0, cellBlock.getMaxPower(), this::emitPowerEvent);
    }

    @Override
    public AECableType getCableConnectionType(class_2350 dir) {
        return AECableType.COVERED;
    }

    @Override
    public void onReady() {
        super.onReady();
        int value = (Integer)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)EnergyCellBlock.ENERGY_STORAGE);
        this.currentDisplayLevel = (byte)value;
        this.updateStateForPowerLevel();
    }

    public static int getStorageLevelFromFillFactor(double fillFactor) {
        return (int)Math.floor(4.0 * class_3532.method_15350((double)(fillFactor + 0.01), (double)0.0, (double)1.0));
    }

    private void updateStateForPowerLevel() {
        if (this.method_11015()) {
            return;
        }
        int storageLevel = EnergyCellBlockEntity.getStorageLevelFromFillFactor(this.stored.getAmount() / this.stored.getMaximum());
        if (this.currentDisplayLevel != storageLevel) {
            this.currentDisplayLevel = (byte)storageLevel;
            this.field_11863.method_8501(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657((class_2769)EnergyCellBlock.ENERGY_STORAGE, (Comparable)Integer.valueOf(storageLevel)));
        }
    }

    private void setChangedNoTicketUpdate() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            throw new IllegalArgumentException("Expected server level, not " + this.field_11863);
        }
        class_3218 serverLevel = (class_3218)class_19372;
        class_2338 pos = this.method_11016();
        class_2791 chunk = serverLevel.method_14178().method_12121(class_4076.method_18675((int)pos.method_10263()), class_4076.method_18675((int)pos.method_10260()), class_2806.field_12803, false);
        if (chunk != null) {
            chunk.method_12008(true);
        }
    }

    private void onAmountChanged() {
        this.setChangedNoTicketUpdate();
        if (!this.neighborChangePending) {
            this.neighborChangePending = true;
            this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().alertDevice((IGridNode)node));
        }
    }

    @Override
    public void method_11007(class_2487 data) {
        super.method_11007(data);
        data.method_10549("internalCurrentPower", this.stored.getAmount());
        data.method_10556("neighborChangePending", this.neighborChangePending);
    }

    @Override
    public void loadTag(class_2487 data) {
        super.loadTag(data);
        this.stored.setStored(data.method_10574("internalCurrentPower"));
        this.neighborChangePending = data.method_10577("neighborChangePending");
    }

    @Override
    public void importSettings(SettingsFrom mode, class_2487 input, @Nullable class_1657 player) {
        super.importSettings(mode, input, player);
        if (mode == SettingsFrom.DISMANTLE_ITEM) {
            this.stored.setStored(input.method_10574("internalCurrentPower"));
        }
    }

    @Override
    public void exportSettings(SettingsFrom from, class_2487 data, @Nullable class_1657 player) {
        super.exportSettings(from, data, player);
        if (from == SettingsFrom.DISMANTLE_ITEM && this.stored.getAmount() > 0.0) {
            data.method_10549("internalCurrentPower", this.stored.getAmount());
            data.method_10549("internalMaxPower", this.stored.getMaximum());
        }
    }

    @Override
    public final double injectAEPower(double amt, Actionable mode) {
        double inserted = this.stored.insert(amt, mode == Actionable.MODULATE);
        if (mode == Actionable.MODULATE && inserted > 0.0) {
            this.onAmountChanged();
        }
        return amt - inserted;
    }

    @Override
    public final double extractAEPower(double amt, Actionable mode, PowerMultiplier pm) {
        return pm.divide(this.extractAEPower(pm.multiply(amt), mode));
    }

    private double extractAEPower(double amt, Actionable mode) {
        double extracted = this.stored.extract(amt, mode == Actionable.MODULATE);
        if (mode == Actionable.MODULATE && extracted > 0.0) {
            this.onAmountChanged();
        }
        return extracted;
    }

    @Override
    public double getAEMaxPower() {
        return this.stored.getMaximum();
    }

    @Override
    public double getAECurrentPower() {
        return this.stored.getAmount();
    }

    @Override
    public boolean isAEPublicPowerStorage() {
        return true;
    }

    @Override
    public AccessRestriction getPowerFlow() {
        return AccessRestriction.READ_WRITE;
    }

    @Override
    public int getPriority() {
        return ((EnergyCellBlock)this.method_11010().method_26204()).getPriority();
    }

    private void emitPowerEvent(GridPowerStorageStateChanged.PowerEventType type) {
        this.getMainNode().ifPresent(grid -> grid.postEvent(new GridPowerStorageStateChanged(this, type)));
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 20, !this.neighborChangePending, true);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (Platform.areBlockEntitiesTicking(this.method_10997(), this.method_11016())) {
            if (this.neighborChangePending) {
                this.neighborChangePending = false;
                this.method_5431();
                this.updateStateForPowerLevel();
            }
            return TickRateModulation.SLEEP;
        }
        return TickRateModulation.IDLE;
    }
}

