/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.style;

import appeng.client.guidebook.document.DefaultStyles;
import appeng.client.guidebook.style.ResolvedTextStyle;
import appeng.client.guidebook.style.TextStyle;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public interface Styleable {
    public TextStyle getStyle();

    public void setStyle(TextStyle var1);

    public TextStyle getHoverStyle();

    public void setHoverStyle(TextStyle var1);

    @Nullable
    public Styleable getStylingParent();

    default public void modifyStyle(Consumer<TextStyle.Builder> customizer) {
        TextStyle.Builder builder = this.getStyle().toBuilder();
        customizer.accept(builder);
        this.setStyle(builder.build());
    }

    default public void modifyHoverStyle(Consumer<TextStyle.Builder> customizer) {
        TextStyle.Builder builder = this.getHoverStyle().toBuilder();
        customizer.accept(builder);
        TextStyle hoverStyle = builder.build();
        if (hoverStyle.whiteSpace() != null) {
            throw new IllegalStateException("Hover-Style may not override layout properties");
        }
        this.setHoverStyle(hoverStyle);
    }

    default public ResolvedTextStyle resolveStyle() {
        Styleable stylingParent = this.getStylingParent();
        if (stylingParent != null) {
            return this.getStyle().mergeWith(stylingParent.resolveStyle());
        }
        return this.getStyle().mergeWith(DefaultStyles.BASE_STYLE);
    }

    default public ResolvedTextStyle resolveHoverStyle(ResolvedTextStyle baseStyle) {
        Styleable stylingParent = this.getStylingParent();
        if (stylingParent != null) {
            return this.getHoverStyle().mergeWith(stylingParent.resolveHoverStyle(baseStyle));
        }
        return this.getHoverStyle().mergeWith(baseStyle);
    }
}

