/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testplots;

import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEItemKey;
import appeng.blockentity.misc.InscriberBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.server.testplots.TestPlotCollection;
import appeng.server.testplots.TestPlotGenerator;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;

public final class InscriberTestPlots {
    private InscriberTestPlots() {
    }

    @TestPlotGenerator
    public static void generateInscriberRecipePlots(TestPlotCollection tests) {
        class_1799 namePlate = AEItems.NAME_PRESS.stack();
        namePlate.method_7959("InscribeName", (class_2520)class_2519.method_23256((String)"HELLO WORLD"));
        class_1799 ironIngots = new class_1799((class_1935)class_1802.field_8620, 2);
        class_1799 namedIngots = ironIngots.method_7972();
        namedIngots.method_7977((class_2561)class_2561.method_43470((String)"HELLO WORLD"));
        InscriberTestPlots.addTest("nameplate", tests, namePlate, ironIngots, class_1799.field_8037, namePlate, class_1799.field_8037, class_1799.field_8037, namedIngots);
        InscriberTestPlots.addPrintTest(tests, AEItems.SILICON, AEItems.SILICON_PRESS, AEItems.SILICON_PRINT);
        InscriberTestPlots.addPrintTest(tests, (class_1935)class_1802.field_8695, AEItems.LOGIC_PROCESSOR_PRESS, AEItems.LOGIC_PROCESSOR_PRINT);
        InscriberTestPlots.addPrintTest(tests, (class_1935)class_1802.field_8477, AEItems.ENGINEERING_PROCESSOR_PRESS, AEItems.ENGINEERING_PROCESSOR_PRINT);
        InscriberTestPlots.addPrintTest(tests, AEItems.CERTUS_QUARTZ_CRYSTAL, AEItems.CALCULATION_PROCESSOR_PRESS, AEItems.CALCULATION_PROCESSOR_PRINT);
    }

    private static void addPrintTest(TestPlotCollection tests, class_1935 ingredient, class_1935 press, class_1935 expectedResult) {
        String suffix = AEItemKey.of(ingredient).getId().method_12832() + "_print";
        InscriberTestPlots.addTest("inscriber_" + suffix, tests, new class_1799(press), new class_1799(ingredient, 2), class_1799.field_8037, new class_1799(press), class_1799.field_8037, class_1799.field_8037, new class_1799(expectedResult, 2));
    }

    private static void addTest(String suffix, TestPlotCollection tests, class_1799 topSlot, class_1799 middleSlot, class_1799 bottomSlot, class_1799 expectedTopSlot, class_1799 expectedMiddleSlot, class_1799 expectedBottomSlot, class_1799 expectedResult) {
        tests.add("inscriber_recipe_" + suffix, plot -> {
            plot.creativeEnergyCell(class_2338.field_10980.method_10074());
            plot.blockEntity(class_2338.field_10980, AEBlocks.INSCRIBER, be -> {
                be.getUpgrades().addItems(AEItems.SPEED_CARD.stack());
                be.getUpgrades().addItems(AEItems.SPEED_CARD.stack());
                be.getUpgrades().addItems(AEItems.SPEED_CARD.stack());
                be.getUpgrades().addItems(AEItems.SPEED_CARD.stack());
                be.getUpgrades().addItems(AEItems.SPEED_CARD.stack());
                InternalInventory inv = be.getInternalInventory();
                inv.insertItem(0, topSlot.method_7972(), false);
                inv.insertItem(1, bottomSlot.method_7972(), false);
                inv.insertItem(2, middleSlot.method_7972(), false);
            });
        }, plotTestHelper -> plotTestHelper.method_36041().method_36079(() -> {
            InscriberBlockEntity inscriber = (InscriberBlockEntity)plotTestHelper.method_36014(class_2338.field_10980);
            InternalInventory inv = inscriber.getInternalInventory();
            plotTestHelper.check(class_1799.method_31577((class_1799)inv.getStackInSlot(0), (class_1799)expectedTopSlot), "Top slot is not as expected", class_2338.field_10980);
            plotTestHelper.check(class_1799.method_31577((class_1799)inv.getStackInSlot(1), (class_1799)expectedBottomSlot), "Bottom slot is not as expected", class_2338.field_10980);
            plotTestHelper.check(class_1799.method_31577((class_1799)inv.getStackInSlot(2), (class_1799)expectedMiddleSlot), "Middle slot is not as expected", class_2338.field_10980);
            plotTestHelper.check(class_1799.method_31577((class_1799)inv.getStackInSlot(3), (class_1799)expectedResult), "Result slot is not as expected", class_2338.field_10980);
        }).method_36075());
    }
}

