/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.gui.impl;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.impl.discord.DiscordStatus;
import com.gitlab.cdagaming.craftpresence.core.integrations.discord.assets.DiscordAsset;
import com.gitlab.cdagaming.craftpresence.core.integrations.discord.assets.DiscordAssetUtils;
import com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.DynamicScrollableList;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicSelectorGui;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedTextControl;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ScrollPane;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.DynamicWidget;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.TextDisplayWidget;
import craftpresence.external.org.meteordev.starscript.compiler.Expr;
import craftpresence.jvmdg.api.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_U_List;
import io.github.cdagaming.unicore.utils.FileUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_364;

public class CommandsGui
extends ExtendedScreen {
    private static final Pattern SURROUNDED_BY_QUOTES = Pattern.compile("\"(.*?)\"");
    public ExtendedButtonControl proceedButton;
    public ExtendedButtonControl copyButton;
    public ExtendedButtonControl enterButton;
    private String[] executionCommandArgs;
    private ExtendedTextControl commandInput;
    private ScrollPane childFrame;
    private TextDisplayWidget previewArea;
    private String executionString;
    private String commandString = "";
    private boolean blockInteractions = false;
    private String[] commandArgs;
    private String[] filteredCommandArgs;
    private List<String> tabCompletions = StringUtils.newArrayList();

    public CommandsGui(String ... commandArgs) {
        super(Constants.TRANSLATOR.translate("gui.config.title.commands", new Object[0]));
        this.executionCommandArgs = commandArgs;
        this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.usage.main", new Object[0]);
    }

    private static List<String> getListOfStringsMatchingLastWord(String[] inputArgs, Collection<?> possibleCompletions) {
        String s = inputArgs[inputArgs.length - 1];
        List list = StringUtils.newArrayList();
        if (!possibleCompletions.isEmpty()) {
            for (Object object : possibleCompletions) {
                String str;
                if (object == null || !CommandsGui.doesStringStartWith(s, str = String.valueOf(object))) continue;
                list.add(str);
            }
        }
        return list;
    }

    private static boolean doesStringStartWith(String original, String region) {
        return region.regionMatches(true, 0, original, 0, original.length());
    }

    public void executeCommand(String ... args) {
        this.executionCommandArgs = args;
    }

    public void initializeUi() {
        this.proceedButton = (ExtendedButtonControl)this.addControl((class_364)new ExtendedButtonControl(6, this.getScreenHeight() - 26, 95, 20, Constants.TRANSLATOR.translate("gui.config.message.button.back", new Object[0]), () -> this.openScreen(this.getParent()), new String[0]));
        this.copyButton = (ExtendedButtonControl)this.addControl((class_364)new ExtendedButtonControl(6, 6, 95, 20, Constants.TRANSLATOR.translate("gui.config.message.button.copy", new Object[0]), () -> this.copyToClipboard(this.executionString), new String[0]));
        this.enterButton = (ExtendedButtonControl)this.addControl((class_364)new ExtendedButtonControl(this.getScreenWidth() - 26, this.getScreenHeight() - 26, 20, 20, "=>", () -> {
            if (this.canAcceptCommand()) {
                this.acceptCommand();
            }
        }, new String[0]));
        this.commandInput = (ExtendedTextControl)this.addControl((class_364)new ExtendedTextControl(this.getFontRenderer(), this.proceedButton.getRight() + 4, this.getScreenHeight() - 26, this.getScreenWidth() - 135, 20, () -> {
            this.commandString = this.commandInput.getControlMessage();
        }));
        this.commandInput.setControlMessage(this.commandString);
        this.childFrame = (ScrollPane)this.addControl((class_364)new ScrollPane(0, 32, this.getScreenWidth(), this.getScreenHeight() - 64));
        this.previewArea = (TextDisplayWidget)this.childFrame.addWidget((DynamicWidget)new TextDisplayWidget(0, 0, this.childFrame.getScreenWidth(), this.executionString));
        super.initializeUi();
    }

    public void preRender() {
        this.proceedButton.setControlEnabled(!this.blockInteractions);
        this.copyButton.setControlEnabled(!this.blockInteractions);
        this.enterButton.setControlEnabled(!this.blockInteractions);
        this.commandInput.setControlEnabled(!this.blockInteractions);
        if (!this.blockInteractions) {
            this.checkCommands();
        }
        this.previewArea.setMessage(this.executionString);
        super.preRender();
    }

    private void checkCommands() {
        if (this.isValidCommand()) {
            this.commandArgs = this.commandString.replace("/", "").split(" ");
            this.filteredCommandArgs = this.commandString.replace("/", "").replace("cp", "").replace("craftpresence", "").trim().split(" ");
            this.tabCompletions = this.getTabCompletions(this.filteredCommandArgs);
        }
        if (this.executionCommandArgs != null) {
            if (this.executionCommandArgs.length == 0 || this.executionCommandArgs[0].equalsIgnoreCase("help") || this.executionCommandArgs[0].equalsIgnoreCase("?") || this.executionCommandArgs[0].equalsIgnoreCase("")) {
                this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.usage.main", new Object[0]);
            } else if (!StringUtils.isNullOrEmpty((String)this.executionCommandArgs[0])) {
                if (this.executionCommandArgs[0].equalsIgnoreCase("request")) {
                    if (CraftPresence.CLIENT.isAvailable()) {
                        if (this.executionCommandArgs.length == 1) {
                            this.executionString = CraftPresence.CLIENT.STATUS == DiscordStatus.JoinRequest && CraftPresence.CLIENT.REQUESTER_USER != null ? Constants.TRANSLATOR.translate("craftpresence.command.request.info", new Object[]{CraftPresence.CLIENT.REQUESTER_USER.getEffectiveName(), CraftPresence.SCHEDULER.TIMER}) : Constants.TRANSLATOR.translate("craftpresence.command.request.none", new Object[0]);
                        } else if (!StringUtils.isNullOrEmpty((String)this.executionCommandArgs[1])) {
                            if (CraftPresence.CLIENT.STATUS == DiscordStatus.JoinRequest && CraftPresence.CLIENT.REQUESTER_USER != null) {
                                if (this.executionCommandArgs[1].equalsIgnoreCase("accept")) {
                                    this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.request.accept", new Object[]{CraftPresence.CLIENT.REQUESTER_USER.getEffectiveName()});
                                    CraftPresence.CLIENT.acceptJoinRequest();
                                } else if (this.executionCommandArgs[1].equalsIgnoreCase("deny")) {
                                    this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.request.denied", new Object[]{CraftPresence.CLIENT.REQUESTER_USER.getEffectiveName()});
                                    CraftPresence.CLIENT.denyJoinRequest();
                                } else {
                                    this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.unrecognized", new Object[0]);
                                }
                            } else {
                                this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.request.none", new Object[0]);
                            }
                        }
                    } else {
                        this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.offline", new Object[0]);
                    }
                } else if (this.executionCommandArgs[0].equalsIgnoreCase("export")) {
                    String clientId = CraftPresence.CONFIG.generalSettings.clientId;
                    boolean doFullCopy = false;
                    String urlMeta = "";
                    if (this.executionCommandArgs.length == 1) {
                        this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.usage.export", new Object[]{clientId, false});
                    } else if (!StringUtils.isNullOrEmpty((String)this.executionCommandArgs[1])) {
                        if (this.executionCommandArgs[1].equalsIgnoreCase("assets")) {
                            if (this.executionCommandArgs.length >= 3 && this.executionCommandArgs.length <= 5) {
                                for (int i = 2; i < this.executionCommandArgs.length; ++i) {
                                    if (StringUtils.isValidBoolean((String)this.executionCommandArgs[i])) {
                                        doFullCopy = Boolean.parseBoolean(this.executionCommandArgs[i]);
                                        continue;
                                    }
                                    if (DiscordAssetUtils.isValidId(this.executionCommandArgs[i])) {
                                        clientId = this.executionCommandArgs[i];
                                        continue;
                                    }
                                    Matcher matcher = SURROUNDED_BY_QUOTES.matcher(this.commandString);
                                    if (!matcher.find()) continue;
                                    urlMeta = matcher.group(1);
                                }
                            } else {
                                this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.unrecognized", new Object[0]);
                            }
                            this.exportAssets(clientId, doFullCopy, urlMeta);
                        } else {
                            this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.unrecognized", new Object[0]);
                        }
                    }
                } else if (this.executionCommandArgs[0].equalsIgnoreCase("compile")) {
                    if (this.executionCommandArgs.length == 1) {
                        this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.usage.compile", new Object[0]);
                    } else {
                        Matcher matcher = SURROUNDED_BY_QUOTES.matcher(this.commandString);
                        if (matcher.find()) {
                            String contents = matcher.group(1);
                            StringBuilder out = new StringBuilder();
                            String value = CraftPresence.CLIENT.getCompileResult(contents, true, null, out, new Expr.Visitor[0]).get().toString();
                            int length = StringUtils.getBytes((String)value, (String)"UTF-8").length;
                            this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.compile", new Object[]{value, length, out.toString().replace("\n", "\\n")});
                        } else {
                            this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.unrecognized", new Object[0]);
                        }
                    }
                } else if (this.executionCommandArgs[0].equalsIgnoreCase("search")) {
                    if (this.executionCommandArgs.length == 1) {
                        this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.usage.search", new Object[0]);
                    } else if (!StringUtils.isNullOrEmpty((String)this.executionCommandArgs[1])) {
                        List results = StringUtils.newArrayList(CraftPresence.CLIENT.getArgumentEntries(this.executionCommandArgs[1]));
                        if (!results.isEmpty()) {
                            this.openScreen((ExtendedScreen)new DynamicSelectorGui(Constants.TRANSLATOR.translate("gui.config.title.selector.view.items", new Object[0]), results, null, null, false, false, DynamicScrollableList.RenderType.Placeholder, null, null));
                        } else {
                            this.executionString = Constants.TRANSLATOR.translate("gui.config.message.empty.list", new Object[0]);
                        }
                    }
                } else if (this.executionCommandArgs[0].equalsIgnoreCase("reload")) {
                    this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.reload", new Object[0]);
                    CommandUtils.reloadData(true);
                    this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.reload.complete", new Object[0]);
                } else if (this.executionCommandArgs[0].equalsIgnoreCase("shutdown")) {
                    if (CraftPresence.CLIENT.isAvailable()) {
                        this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.shutdown.pre", new Object[0]);
                        CraftPresence.CLIENT.shutDown();
                        this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.shutdown.post", new Object[0]);
                    } else {
                        this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.offline", new Object[0]);
                    }
                } else if (this.executionCommandArgs[0].equalsIgnoreCase("reboot")) {
                    this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.reboot.pre", new Object[0]);
                    CommandUtils.setupRPC();
                    this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.reboot.post", new Object[0]);
                } else if (this.executionCommandArgs[0].equalsIgnoreCase("view")) {
                    if (this.executionCommandArgs.length == 1) {
                        this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.usage.view", new Object[0]);
                    } else if (!StringUtils.isNullOrEmpty((String)this.executionCommandArgs[1])) {
                        if (this.executionCommandArgs[1].equalsIgnoreCase("placeholders")) {
                            this.executeCommand("search", "all");
                            return;
                        }
                        if (this.executionCommandArgs[1].equalsIgnoreCase("items")) {
                            if (CraftPresence.TILE_ENTITIES.isEnabled()) {
                                this.openScreen((ExtendedScreen)new DynamicSelectorGui(Constants.TRANSLATOR.translate("gui.config.title.selector.view.items", new Object[0]), CraftPresence.TILE_ENTITIES.TILE_ENTITY_NAMES, null, null, false, false, DynamicScrollableList.RenderType.ItemData, null, null));
                            } else {
                                this.executionString = Constants.TRANSLATOR.translate("gui.config.message.hover.access", new Object[]{Constants.TRANSLATOR.translate("gui.config.name.advanced.enable_per_item", new Object[0])});
                            }
                        } else if (this.executionCommandArgs[1].equalsIgnoreCase("entities")) {
                            if (CraftPresence.ENTITIES.isEnabled()) {
                                this.openScreen((ExtendedScreen)new DynamicSelectorGui(Constants.TRANSLATOR.translate("gui.config.title.selector.view.entities", new Object[0]), CraftPresence.ENTITIES.ENTITY_NAMES, null, null, false, false, DynamicScrollableList.RenderType.EntityData, null, null));
                            } else {
                                this.executionString = Constants.TRANSLATOR.translate("gui.config.message.hover.access", new Object[]{Constants.TRANSLATOR.translate("gui.config.name.advanced.enable_per_entity", new Object[0])});
                            }
                        } else if (this.executionCommandArgs[1].equalsIgnoreCase("servers")) {
                            if (CraftPresence.SERVER.isEnabled()) {
                                this.openScreen((ExtendedScreen)new DynamicSelectorGui(Constants.TRANSLATOR.translate("gui.config.title.selector.view.servers", new Object[0]), CraftPresence.SERVER.knownAddresses, null, null, false, false, DynamicScrollableList.RenderType.ServerData, null, null));
                            } else {
                                this.executionString = Constants.TRANSLATOR.translate("gui.config.message.hover.access", new Object[]{Constants.TRANSLATOR.translate("gui.config.name.general.detect_world_data", new Object[0])});
                            }
                        } else if (this.executionCommandArgs[1].equalsIgnoreCase("screens")) {
                            if (CraftPresence.GUIS.isEnabled()) {
                                this.openScreen((ExtendedScreen)new DynamicSelectorGui(Constants.TRANSLATOR.translate("gui.config.title.selector.view.guis", new Object[0]), CraftPresence.GUIS.GUI_NAMES, null, null, false, false, DynamicScrollableList.RenderType.None, null, null).setIdentifierType(DynamicScrollableList.IdentifierType.Gui));
                            } else {
                                this.executionString = Constants.TRANSLATOR.translate("gui.config.message.hover.access", new Object[]{Constants.TRANSLATOR.translate("gui.config.name.advanced.enable_per_gui", new Object[0])});
                            }
                        } else if (this.executionCommandArgs[1].equalsIgnoreCase("biomes")) {
                            if (CraftPresence.BIOMES.isEnabled()) {
                                this.openScreen((ExtendedScreen)new DynamicSelectorGui(Constants.TRANSLATOR.translate("gui.config.title.selector.view.biomes", new Object[0]), CraftPresence.BIOMES.BIOME_NAMES, null, null, false, false, DynamicScrollableList.RenderType.None, null, null));
                            } else {
                                this.executionString = Constants.TRANSLATOR.translate("gui.config.message.hover.access", new Object[]{Constants.TRANSLATOR.translate("gui.config.name.general.detect_biome_data", new Object[0])});
                            }
                        } else if (this.executionCommandArgs[1].equalsIgnoreCase("dimensions")) {
                            if (CraftPresence.DIMENSIONS.isEnabled()) {
                                this.openScreen((ExtendedScreen)new DynamicSelectorGui(Constants.TRANSLATOR.translate("gui.config.title.selector.view.dimensions", new Object[0]), CraftPresence.DIMENSIONS.DIMENSION_NAMES, null, null, false, false, DynamicScrollableList.RenderType.None, null, null));
                            } else {
                                this.executionString = Constants.TRANSLATOR.translate("gui.config.message.hover.access", new Object[]{Constants.TRANSLATOR.translate("gui.config.name.general.detect_dimension_data", new Object[0])});
                            }
                        } else if (this.executionCommandArgs[1].equalsIgnoreCase("currentData")) {
                            this.executionString = CraftPresence.CLIENT.isAvailable() && CraftPresence.CLIENT.PRESENCE != null ? Constants.TRANSLATOR.translate("craftpresence.command.current_data", new Object[]{CraftPresence.CLIENT.CURRENT_USER.getEffectiveName(), CraftPresence.CLIENT.PRESENCE.activityType().name(), StringUtils.convertString((String)CraftPresence.CLIENT.PRESENCE.details(), (String)"UTF-8", (boolean)true), StringUtils.convertString((String)CraftPresence.CLIENT.PRESENCE.state(), (String)"UTF-8", (boolean)true), CraftPresence.CLIENT.PRESENCE.startTimestamp(), CraftPresence.CLIENT.CLIENT_ID, StringUtils.convertString((String)CraftPresence.CLIENT.PRESENCE.largeImageKey(), (String)"UTF-8", (boolean)true), StringUtils.convertString((String)CraftPresence.CLIENT.PRESENCE.largeImageText(), (String)"UTF-8", (boolean)true), StringUtils.convertString((String)CraftPresence.CLIENT.PRESENCE.smallImageKey(), (String)"UTF-8", (boolean)true), StringUtils.convertString((String)CraftPresence.CLIENT.PRESENCE.smallImageText(), (String)"UTF-8", (boolean)true), CraftPresence.CLIENT.PARTY_ID, CraftPresence.CLIENT.PARTY_SIZE, CraftPresence.CLIENT.PARTY_MAX, CraftPresence.CLIENT.PRESENCE.partyPrivacy().name(), CraftPresence.CLIENT.JOIN_SECRET, CraftPresence.CLIENT.PRESENCE.endTimestamp(), CraftPresence.CLIENT.MATCH_SECRET, CraftPresence.CLIENT.SPECTATE_SECRET, CraftPresence.CLIENT.PRESENCE.buttons().toString(), CraftPresence.CLIENT.PRESENCE.instance()}) : Constants.TRANSLATOR.translate("craftpresence.command.offline", new Object[0]);
                        } else if (this.executionCommandArgs[1].equalsIgnoreCase("assets")) {
                            if (this.executionCommandArgs.length == 2) {
                                this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.usage.view.assets", new Object[0]);
                            } else if (!StringUtils.isNullOrEmpty((String)this.executionCommandArgs[2])) {
                                if (this.executionCommandArgs[2].equalsIgnoreCase("custom")) {
                                    this.openScreen((ExtendedScreen)new DynamicSelectorGui(Constants.TRANSLATOR.translate("gui.config.title.selector.view.assets.custom", new Object[0]), DiscordAssetUtils.CUSTOM_ASSET_LIST.keySet(), null, null, false, false, DynamicScrollableList.RenderType.CustomDiscordAsset, null, null));
                                } else if (this.executionCommandArgs[2].equalsIgnoreCase("all")) {
                                    this.openScreen((ExtendedScreen)new DynamicSelectorGui(Constants.TRANSLATOR.translate("gui.config.title.selector.view.assets.all", new Object[0]), DiscordAssetUtils.ASSET_LIST.keySet(), null, null, false, false, DynamicScrollableList.RenderType.DiscordAsset, null, null));
                                }
                            }
                        } else {
                            this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.unrecognized", new Object[0]);
                        }
                    }
                } else {
                    this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.unrecognized", new Object[0]);
                }
            } else {
                this.executionString = Constants.TRANSLATOR.translate("craftpresence.logger.error.command", new Object[0]);
            }
        }
        this.executionCommandArgs = null;
    }

    public boolean method_25404(int keyCode, int mouseX, int mouseY) {
        if (!this.blockInteractions) {
            if (this.commandInput.isControlFocused()) {
                if (CommandsGui.isEscapeKey((int)keyCode)) {
                    this.commandInput.setControlFocused(false);
                } else {
                    if (this.canAcceptCommand()) {
                        if (keyCode == CommandsGui.getKeyByVersion((int)15, (int)258) && !this.tabCompletions.isEmpty()) {
                            if (this.commandArgs.length > 1 && (this.filteredCommandArgs[this.filteredCommandArgs.length - 1].length() > 1 || this.filteredCommandArgs[this.filteredCommandArgs.length - 1].equalsIgnoreCase("?"))) {
                                this.commandString = this.commandString.replace(this.filteredCommandArgs[this.filteredCommandArgs.length - 1], J_U_List.getFirst(this.tabCompletions));
                                this.commandInput.setControlMessage(this.commandString);
                            }
                        } else if (keyCode == CommandsGui.getKeyByVersion((int)28, (int)257) || keyCode == CommandsGui.getKeyByVersion((int)156, (int)335)) {
                            this.acceptCommand();
                        }
                    }
                    return this.commandInput.method_25404(keyCode, mouseX, mouseY);
                }
            }
            return super.method_25404(keyCode, mouseX, mouseY);
        }
        return false;
    }

    private boolean isValidCommand() {
        return !StringUtils.isNullOrEmpty((String)this.commandString) && this.commandString.startsWith("/");
    }

    private boolean canAcceptCommand() {
        return this.isValidCommand() && this.commandArgs != null && this.commandArgs.length > 0 && (this.commandArgs[0].equalsIgnoreCase("cp") || this.commandArgs[0].equalsIgnoreCase("craftpresence"));
    }

    private void acceptCommand() {
        this.executeCommand(this.filteredCommandArgs);
        this.childFrame.resetMouseScroll();
        this.childFrame.setMouseScroll(0);
    }

    private List<String> getTabCompletions(String[] args) {
        List completions = StringUtils.newArrayList();
        if (args.length == 1) {
            completions.add("?");
            completions.add("help");
            completions.add("compile");
            completions.add("search");
            completions.add("reload");
            completions.add("request");
            completions.add("export");
            completions.add("view");
            completions.add("reboot");
            completions.add("shutdown");
        } else if (args.length == 2) {
            if (args[0].equalsIgnoreCase("export")) {
                completions.add("assets");
            } else if (args[0].equalsIgnoreCase("search")) {
                completions.add("type:");
                completions.add("all");
            } else if (args[0].equalsIgnoreCase("view")) {
                completions.add("placeholders");
                completions.add("currentData");
                completions.add("assets");
                completions.add("dimensions");
                completions.add("biomes");
                completions.add("items");
                completions.add("entities");
                completions.add("servers");
                completions.add("screens");
            } else if (args[0].equalsIgnoreCase("request")) {
                completions.add("accept");
                completions.add("deny");
            }
        } else if (args.length == 3 && args[0].equalsIgnoreCase("view") && args[1].equalsIgnoreCase("assets")) {
            completions.add("all");
            completions.add("custom");
        }
        return CommandsGui.getListOfStringsMatchingLastWord(args, completions);
    }

    private void exportAssets(String clientId, boolean doFullCopy, String urlMeta) {
        Constants.getThreadFactory().newThread(() -> {
            this.blockInteractions = true;
            DiscordAsset[] assetList = DiscordAssetUtils.loadAssets(clientId, false);
            boolean hasError = false;
            if (assetList != null) {
                String filePath = "craftpresence" + File.separator + "export" + File.separator + clientId + File.separator;
                this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.export.pre", new Object[]{assetList.length, clientId, doFullCopy});
                File dataDir = new File(filePath + "downloads.txt");
                String encoding = CraftPresence.CLIENT.isAvailable() ? CraftPresence.CLIENT.ipcInstance.getEncoding() : "UTF-8";
                try {
                    FileUtils.assertFileExists((File)dataDir);
                }
                catch (Throwable ex) {
                    Constants.LOG.debugError(ex);
                    hasError = true;
                }
                try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(dataDir.toPath(), new OpenOption[0]), encoding));){
                    bw.write("## Export Data => " + clientId);
                    bw.newLine();
                    bw.newLine();
                    for (int i = 0; i < assetList.length; ++i) {
                        this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.export.progress", new Object[]{clientId, i + 1, assetList.length});
                        DiscordAsset asset = assetList[i];
                        String assetUrl = DiscordAssetUtils.getDiscordAssetUrl(clientId, asset.getId()) + urlMeta;
                        String assetName = asset.getName() + ".png";
                        if (doFullCopy) {
                            FileUtils.downloadFile((String)assetUrl, (File)new File(filePath + assetName));
                        }
                        bw.write("* " + assetName + " => " + assetUrl);
                        bw.newLine();
                    }
                }
                catch (Throwable ex) {
                    Constants.LOG.debugError(ex);
                    hasError = true;
                }
                this.executionString = !hasError ? Constants.TRANSLATOR.translate("craftpresence.command.export.post", new Object[]{assetList.length, clientId, doFullCopy}) : Constants.TRANSLATOR.translate("craftpresence.command.export.exception", new Object[]{clientId});
            } else {
                this.executionString = Constants.TRANSLATOR.translate("craftpresence.command.export.exception", new Object[]{clientId});
            }
            this.blockInteractions = false;
        }).start();
    }
}

