/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.item;

import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.item.IItemPlatform;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.platform.Services;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1743;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1766;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1819;
import net.minecraft.class_1826;
import net.minecraft.class_1829;
import net.minecraft.class_1834;
import net.minecraft.class_1835;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_3468;
import net.minecraft.class_3861;
import net.minecraft.class_3956;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class ItemHelper {
    private static final IItemPlatform PLATFORM = Services.load(IItemPlatform.class);
    private static final float MINECRAFT_WEAPON_ENCHANT_CHANCE = 0.25f;
    private static final float MINECRAFT_ARMOR_PIECE_ENCHANT_CHANCE = 0.5f;

    public static Decorator decorate(class_1799 itemStack) {
        return new Decorator(itemStack);
    }

    public static Optional<SmeltResult> tryToSmelt(class_1937 level, class_1799 itemStack) {
        Optional recipe = level.method_8433().method_8132(class_3956.field_17546, (class_1263)new class_1277(new class_1799[]{itemStack}), level);
        if (recipe.isPresent()) {
            float experience = ((class_3861)recipe.get()).method_8171() * (float)itemStack.method_7947();
            class_1799 result = ((class_3861)recipe.get()).method_8110(level.method_30349()).method_7972();
            result.method_7939(result.method_7947() * itemStack.method_7947());
            return Optional.of(new SmeltResult(result, experience));
        }
        return Optional.empty();
    }

    public static void giveToPlayer(class_1799 itemStack, class_1657 player) {
        if (!player.method_31548().method_7394(itemStack)) {
            player.method_37908().method_8649((class_1297)new class_1542(player.method_37908(), player.method_23317(), player.method_23318() + 1.0, player.method_23321(), itemStack));
        }
    }

    public static void damage(class_1309 entity, class_1304 slot, int damage) {
        entity.method_6118(slot).method_7956(damage, entity, subentity -> subentity.method_20235(slot));
    }

    public static void damage(class_1309 entity, class_1268 hand, int damage) {
        entity.method_5998(hand).method_7956(damage, entity, subentity -> subentity.method_20236(hand));
    }

    @Nullable
    public static class_1304 equip(class_1308 mob, class_1799 itemStack) {
        if (!mob.method_5939(itemStack)) {
            return null;
        }
        class_1304 equipmentSlot = class_1308.method_32326((class_1799)itemStack);
        equipmentSlot = equipmentSlot.method_46643() ? equipmentSlot : class_1304.field_6173;
        mob.method_5673(equipmentSlot, itemStack);
        return equipmentSlot;
    }

    public static void consumeItemOnUse(class_1799 itemStack, class_1657 player) {
        player.method_7259(class_3468.field_15372.method_14956((Object)itemStack.method_7909()));
        if (!EntityHelper.isOnCreativeMode(player)) {
            itemStack.method_7934(1);
        }
    }

    public static void addCooldown(class_1657 player, int duration, class_1792 ... items) {
        for (class_1792 item : items) {
            player.method_7357().method_7906(item, duration);
        }
    }

    public static <Type extends class_1299<? extends class_1308>> Supplier<class_1826> createEgg(Supplier<Type> type, int backgroundColor, int highlightColor) {
        return PLATFORM.createEgg(type, backgroundColor, highlightColor);
    }

    public static class_1799 getHandItem(class_1309 entity, Predicate<class_1799> predicate) {
        return predicate.test(entity.method_6047()) ? entity.method_6047() : entity.method_6079();
    }

    public static class_1799 getCurrentlyUsedItem(class_1309 entity) {
        return entity.method_6115() ? entity.method_5998(entity.method_6058()) : class_1799.field_8037;
    }

    public static boolean isOnCooldown(class_1657 player, class_1792 ... items) {
        for (class_1792 item : items) {
            if (!player.method_7357().method_7904(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean isShield(class_1792 item) {
        return item instanceof class_1819;
    }

    public static boolean isRangedWeapon(class_1792 item) {
        return item instanceof class_1753 || item instanceof class_1764;
    }

    public static boolean isMeleeWeapon(class_1792 item) {
        return item instanceof class_1829 || item instanceof class_1835 || item instanceof class_1743;
    }

    public static boolean isGoldenToolOrArmor(class_1792 item) {
        class_1738 armorItem;
        class_1766 diggerItem;
        class_1829 swordItem;
        return item instanceof class_1829 && (swordItem = (class_1829)item).method_8022() == class_1834.field_8929 || item instanceof class_1766 && (diggerItem = (class_1766)item).method_8022() == class_1834.field_8929 || item instanceof class_1738 && (armorItem = (class_1738)item).method_7686() == class_1740.field_7895;
    }

    public static boolean isAnyTool(class_1792 item) {
        return item instanceof class_1829 || item instanceof class_1835 || item instanceof class_1766 || item instanceof class_1753 || item instanceof class_1764;
    }

    public static boolean isFishingRod(class_1792 item) {
        return item instanceof class_1787;
    }

    public static class Decorator {
        private final class_1799 itemStack;
        private final List<Runnable> modifications = new ArrayList<Runnable>();
        private boolean isTreasureAllowed = false;
        private float enchantChance = 1.0f;

        public Decorator damage(float ratio) {
            this.modifications.add(() -> {
                if (!this.itemStack.method_7963()) {
                    return;
                }
                this.itemStack.method_7974((int)(ratio * (float)this.itemStack.method_7936()));
            });
            return this;
        }

        public Decorator damage(Range<Float> ratio) {
            this.damage(Random.nextFloat(ratio));
            return this;
        }

        public Decorator allowTreasureEnchantments() {
            this.isTreasureAllowed = true;
            return this;
        }

        public Decorator withVanillaEnchantmentChance() {
            this.enchantChance = this.itemStack.method_7909() instanceof class_1738 ? 0.5f : 0.25f;
            return this;
        }

        public Decorator enchant(double clampedRegionalDifficulty) {
            this.modifications.add(() -> {
                if (!this.itemStack.method_7923() || !Random.check(this.enchantChance)) {
                    return;
                }
                int level = (int)(5.0 + clampedRegionalDifficulty * (double)Random.nextInt(18));
                class_1890.method_8233((class_5819)Random.getThreadSafe(), (class_1799)this.itemStack, (int)level, (boolean)this.isTreasureAllowed);
            });
            return this;
        }

        public class_1799 apply() {
            this.modifications.forEach(Runnable::run);
            return this.itemStack;
        }

        private Decorator(class_1799 itemStack) {
            this.itemStack = itemStack;
        }
    }

    public record SmeltResult(class_1799 itemStack, float experience) {
    }
}

