/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.hooks.fluid.fabric;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.fabric.FluidStackHooksFabric;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class FluidStackHooksImpl {
    public static class_2561 getName(FluidStack stack) {
        return FluidVariantAttributes.getName((FluidVariant)FluidStackHooksFabric.toFabric(stack));
    }

    public static String getTranslationKey(FluidStack stack) {
        class_2960 id = class_7923.field_41173.method_10221((Object)stack.getFluid());
        return "block." + id.method_12836() + "." + id.method_12832();
    }

    public static FluidStack read(class_2540 buf) {
        class_3611 fluid = Objects.requireNonNull((class_3611)class_7923.field_41173.method_10223(buf.method_10810()));
        long amount = buf.method_10792();
        class_2487 tag = buf.method_10798();
        if (fluid == class_3612.field_15906) {
            return FluidStack.empty();
        }
        return FluidStack.create(fluid, amount, tag);
    }

    public static void write(FluidStack stack, class_2540 buf) {
        buf.method_10812(class_7923.field_41173.method_10221((Object)stack.getFluid()));
        buf.method_10791(stack.getAmount());
        buf.method_10794(stack.getTag());
    }

    public static FluidStack read(class_2487 tag) {
        if (tag == null || !tag.method_10573("id", 8)) {
            return FluidStack.empty();
        }
        class_3611 fluid = (class_3611)class_7923.field_41173.method_10223(new class_2960(tag.method_10558("id")));
        if (fluid == null || fluid == class_3612.field_15906) {
            return FluidStack.empty();
        }
        long amount = tag.method_10537("amount");
        FluidStack stack = FluidStack.create(fluid, amount);
        if (tag.method_10573("tag", 10)) {
            stack.setTag(tag.method_10562("tag"));
        }
        return stack;
    }

    public static class_2487 write(FluidStack stack, class_2487 tag) {
        tag.method_10582("id", class_7923.field_41173.method_10221((Object)stack.getFluid()).toString());
        tag.method_10544("amount", stack.getAmount());
        if (stack.hasTag()) {
            tag.method_10566("tag", (class_2520)stack.getTag());
        }
        return tag;
    }

    public static long bucketAmount() {
        return 81000L;
    }

    @Environment(value=EnvType.CLIENT)
    @Nullable
    public static class_1058 getStillTexture(@Nullable class_1920 level, @Nullable class_2338 pos, class_3610 state) {
        if (state.method_15772() == class_3612.field_15906) {
            return null;
        }
        FluidRenderHandler handler = FluidRenderHandlerRegistry.INSTANCE.get(state.method_15772());
        if (handler == null) {
            return null;
        }
        class_1058[] sprites = handler.getFluidSprites(level, pos, state);
        if (sprites == null) {
            return null;
        }
        return sprites[0];
    }

    @Environment(value=EnvType.CLIENT)
    @Nullable
    public static class_1058 getStillTexture(FluidStack stack) {
        class_1058[] sprites = FluidVariantRendering.getSprites((FluidVariant)FluidStackHooksFabric.toFabric(stack));
        return sprites == null ? null : sprites[0];
    }

    @Environment(value=EnvType.CLIENT)
    @Nullable
    public static class_1058 getStillTexture(class_3611 fluid) {
        class_1058[] sprites = FluidVariantRendering.getSprites((FluidVariant)FluidVariant.of((class_3611)fluid));
        return sprites == null ? null : sprites[0];
    }

    @Environment(value=EnvType.CLIENT)
    @Nullable
    public static class_1058 getFlowingTexture(@Nullable class_1920 level, @Nullable class_2338 pos, class_3610 state) {
        if (state.method_15772() == class_3612.field_15906) {
            return null;
        }
        FluidRenderHandler handler = FluidRenderHandlerRegistry.INSTANCE.get(state.method_15772());
        if (handler == null) {
            return null;
        }
        class_1058[] sprites = handler.getFluidSprites(level, pos, state);
        if (sprites == null) {
            return null;
        }
        return sprites[1];
    }

    @Environment(value=EnvType.CLIENT)
    @Nullable
    public static class_1058 getFlowingTexture(FluidStack stack) {
        class_1058[] sprites = FluidVariantRendering.getSprites((FluidVariant)FluidStackHooksFabric.toFabric(stack));
        return sprites == null ? null : sprites[1];
    }

    @Environment(value=EnvType.CLIENT)
    @Nullable
    public static class_1058 getFlowingTexture(class_3611 fluid) {
        class_1058[] sprites = FluidVariantRendering.getSprites((FluidVariant)FluidVariant.of((class_3611)fluid));
        return sprites == null ? null : sprites[1];
    }

    @Environment(value=EnvType.CLIENT)
    public static int getColor(@Nullable class_1920 level, @Nullable class_2338 pos, class_3610 state) {
        if (state.method_15772() == class_3612.field_15906) {
            return -1;
        }
        FluidRenderHandler handler = FluidRenderHandlerRegistry.INSTANCE.get(state.method_15772());
        if (handler == null) {
            return -1;
        }
        return handler.getFluidColor(level, pos, state);
    }

    @Environment(value=EnvType.CLIENT)
    public static int getColor(FluidStack stack) {
        return FluidVariantRendering.getColor((FluidVariant)FluidStackHooksFabric.toFabric(stack));
    }

    @Environment(value=EnvType.CLIENT)
    public static int getColor(class_3611 fluid) {
        if (fluid == class_3612.field_15906) {
            return -1;
        }
        FluidRenderHandler handler = FluidRenderHandlerRegistry.INSTANCE.get(fluid);
        if (handler == null) {
            return -1;
        }
        return handler.getFluidColor(null, null, fluid.method_15785());
    }

    public static int getLuminosity(FluidStack fluid, @Nullable class_1937 level, @Nullable class_2338 pos) {
        return FluidVariantAttributes.getLuminance((FluidVariant)FluidStackHooksFabric.toFabric(fluid));
    }

    public static int getLuminosity(class_3611 fluid, @Nullable class_1937 level, @Nullable class_2338 pos) {
        return FluidVariantAttributes.getLuminance((FluidVariant)FluidVariant.of((class_3611)fluid));
    }

    public static int getTemperature(FluidStack fluid, @Nullable class_1937 level, @Nullable class_2338 pos) {
        return FluidVariantAttributes.getTemperature((FluidVariant)FluidStackHooksFabric.toFabric(fluid));
    }

    public static int getTemperature(class_3611 fluid, @Nullable class_1937 level, @Nullable class_2338 pos) {
        return FluidVariantAttributes.getTemperature((FluidVariant)FluidVariant.of((class_3611)fluid));
    }

    public static int getViscosity(FluidStack fluid, @Nullable class_1937 level, @Nullable class_2338 pos) {
        return FluidVariantAttributes.getViscosity((FluidVariant)FluidStackHooksFabric.toFabric(fluid), (class_1937)level);
    }

    public static int getViscosity(class_3611 fluid, @Nullable class_1937 level, @Nullable class_2338 pos) {
        return FluidVariantAttributes.getViscosity((FluidVariant)FluidVariant.of((class_3611)fluid), (class_1937)level);
    }
}

