/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity.core.ai.navigation;

import net.minecraft.class_1308;
import net.minecraft.class_1330;
import net.minecraft.class_3532;

public class SmartBodyHelper
extends class_1330 {
    private static final int HISTORY_SIZE = 10;
    private static final double MOVE_THRESHOLD = 2.5E-7;
    public float bodyLagMoving;
    public float headLag;
    public float bodyLagStill;
    public float bodyMax;
    public float headMax;
    private final double[] histPosX = new double[10];
    private final double[] histPosZ = new double[10];
    protected final class_1308 entity;

    public SmartBodyHelper(class_1308 entity) {
        super(entity);
        this.entity = entity;
        this.bodyLagMoving = 0.3f;
        this.headLag = 0.2f;
        this.bodyLagStill = 0.05f;
        this.bodyMax = 45.0f;
        this.headMax = 22.5f;
    }

    public void method_6224() {
        for (int i = 9; i > 0; --i) {
            this.histPosX[i] = this.histPosX[i - 1];
            this.histPosZ[i] = this.histPosZ[i - 1];
        }
        this.histPosX[0] = this.entity.method_23317();
        this.histPosZ[0] = this.entity.method_23321();
        double dx = this.avgDelta(this.histPosX);
        double dz = this.avgDelta(this.histPosZ);
        double distSq = dx * dx + dz * dz;
        if (this.entity.method_5968() != null) {
            double tx = this.entity.method_5968().method_23317() - this.entity.method_23317();
            double tz = this.entity.method_5968().method_23321() - this.entity.method_23321();
            float targetAngle = (float)(class_3532.method_15349((double)tz, (double)tx) * 57.29577951308232) - 90.0f;
            this.entity.field_6283 = this.approachAngle(this.entity.field_6283, targetAngle, this.bodyLagMoving, this.bodyMax);
            this.entity.field_6241 = this.approachAngle(this.entity.field_6241, targetAngle, this.headLag, this.headMax);
            this.clampHeadBodyDifference();
        } else if (distSq > 2.5E-7) {
            float moveAngle = (float)(Math.toDegrees(Math.atan2(dz, dx)) - 90.0);
            this.entity.field_6283 = this.approachAngle(this.entity.field_6283, moveAngle, this.bodyLagMoving, this.bodyMax);
            this.entity.field_6241 = this.approachAngle(this.entity.field_6241, this.entity.field_6283, this.headLag, this.headMax);
            this.clampHeadBodyDifference();
        } else {
            this.entity.field_6283 = this.approachAngle(this.entity.field_6283, this.entity.field_6241, this.bodyLagStill, this.bodyMax);
            this.clampHeadBodyDifference();
        }
    }

    private double avgDelta(double[] arr) {
        return this.mean(arr, 0) - this.mean(arr, 5);
    }

    private double mean(double[] arr, int start) {
        double s = 0.0;
        int half = 5;
        for (int i = 0; i < half; ++i) {
            s += arr[start + i];
        }
        return s / (double)half;
    }

    private float approachAngle(float current, float target, float factor, float maxDelta) {
        float d = class_3532.method_15393((float)(target - current));
        if (d < -maxDelta) {
            d = -maxDelta;
        } else if (d > maxDelta) {
            d = maxDelta;
        }
        return current + d * factor;
    }

    private void clampHeadBodyDifference() {
        float diff = class_3532.method_15393((float)(this.entity.field_6241 - this.entity.field_6283));
        float clamped = class_3532.method_15363((float)diff, (float)(-this.headMax), (float)this.headMax);
        this.entity.field_6241 = this.entity.field_6283 + clamped;
    }
}

