/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import java.util.Map;
import net.mehvahdjukaar.amendments.common.block.CommonCauldronCode;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.amendments.reg.ModBlockProperties;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1920;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2275;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public abstract class ModCauldronBlock
extends class_2275
implements class_2343 {
    public static final class_2746 BOILING = ModBlockProperties.BOILING;
    private final int maxLevel;

    public ModCauldronBlock(class_4970.class_2251 properties) {
        super(properties, Map.of());
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)BOILING, (Comparable)Boolean.valueOf(false)));
        this.maxLevel = this.getLevelProperty().method_11898().size();
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{BOILING});
    }

    public boolean method_32766(class_2680 state) {
        return (Integer)state.method_11654((class_2769)this.getLevelProperty()) == this.maxLevel;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 currentPos, class_2338 neighborPos) {
        class_2680 newState = super.method_9559(state, direction, neighborState, level, currentPos, neighborPos);
        return CommonCauldronCode.updateBoilingState(direction, neighborState, level, neighborPos, newState, currentPos);
    }

    public class_1792 method_8389() {
        return class_1802.field_8638;
    }

    public abstract class_2758 getLevelProperty();

    public int method_9572(class_2680 state, class_1937 level, class_2338 pos) {
        return (Integer)state.method_11654((class_2769)this.getLevelProperty());
    }

    public void method_9504(class_2680 state, class_1937 level, class_2338 pos, class_1959.class_1963 precipitation) {
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new LiquidCauldronBlockTile(pos, state);
    }

    protected double method_31615(class_2680 state) {
        double start = 0.5625;
        double end = 0.9375;
        class_2758 levelProperty = this.getLevelProperty();
        int level = (Integer)state.method_11654((class_2769)levelProperty);
        if (this.maxLevel <= 1) {
            return start;
        }
        return start + (end - start) * (double)(level - 1) / (double)(this.maxLevel - 1);
    }

    public void method_9554(class_1937 level, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        if (this.method_31616(state, pos, entity)) {
            CommonCauldronCode.onEntityFallOnContent(level, state, entity, this.method_31615(state));
            super.method_9554(level, state, pos, entity, 0.0f);
        } else {
            super.method_9554(level, state, pos, entity, fallDistance);
        }
    }

    public void method_9548(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity) {
        if (this.method_31616(state, pos, entity)) {
            CommonCauldronCode.entityInside(state, level, pos, entity, () -> this.method_31615(state));
            this.handleEntityInsideFluidSpecial(state, level, pos, entity);
        }
    }

    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        class_2586 class_25862;
        super.method_9496(state, level, pos, random);
        if (((Boolean)state.method_11654((class_2769)BOILING)).booleanValue() && (class_25862 = level.method_8321(pos)) instanceof LiquidCauldronBlockTile) {
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)class_25862;
            SoftFluidTank tank = te.getSoftFluidTank();
            int color = tank.getCachedParticleColor((class_1920)level, pos);
            int light = tank.getFluidValue().getEmissivity();
            CommonCauldronCode.playBubblingAnimation(level, pos, this.method_31615(state), random, color, light);
        }
    }

    protected abstract void handleEntityInsideFluidSpecial(class_2680 var1, class_1937 var2, class_2338 var3, class_1297 var4);

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof LiquidCauldronBlockTile) {
            SoftFluidStack currentFluid;
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)class_25862;
            if (te.handleInteraction(player, hand)) {
                return class_1269.method_29236((boolean)level.field_9236);
            }
            SoftFluidTank tank = te.getSoftFluidTank();
            int tankCapacity = tank.getCapacity();
            if (CommonCauldronCode.attemptPlayerCrafting(state, level, pos, player, hand, tankCapacity, currentFluid = tank.getFluid())) {
                return class_1269.method_29236((boolean)level.field_9236);
            }
        }
        return class_1269.field_5811;
    }

    public class_2680 updateStateOnFluidChange(class_2680 state, class_1937 level, class_2338 pos, SoftFluidStack fluid) {
        int height = fluid.getCount();
        state = fluid.isEmpty() ? class_2246.field_10593.method_9564() : (class_2680)state.method_11657((class_2769)this.getLevelProperty(), (Comparable)Integer.valueOf(height));
        return state;
    }
}

