/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.vmp.mixins.ticketsystem.ticketpropagator;

import com.ishland.vmp.mixins.access.IChunkHolder;
import com.ishland.vmp.mixins.access.IChunkTicket;
import com.ishland.vmp.mixins.access.IThreadedAnvilChunkStorage;
import io.papermc.paper.util.misc.Delayed8WayDistancePropagator2D;
import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayFIFOQueue;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ConcurrentModificationException;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import net.minecraft.class_3193;
import net.minecraft.class_3204;
import net.minecraft.class_3228;
import net.minecraft.class_3898;
import net.minecraft.class_3900;
import net.minecraft.class_3906;
import net.minecraft.class_4706;
import net.minecraft.class_8563;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3204.class})
public abstract class MixinChunkTicketManager {
    @Mutable
    @Shadow
    @Final
    private class_3204.class_4077 field_18252;
    @Shadow
    @Final
    private class_3204.class_3948 field_17455;
    @Shadow
    @Final
    private Set<class_3193> field_16210;
    @Shadow
    @Final
    private Executor field_17460;
    @Shadow
    @Final
    private LongSet field_17459;
    @Shadow
    @Final
    private class_3906<class_3900.class_3947> field_17458;
    @Shadow
    private long field_13894;
    @Shadow
    @Final
    private Long2ObjectOpenHashMap<class_4706<class_3228<?>>> field_13895;
    @Unique
    protected Long2IntLinkedOpenHashMap ticketLevelUpdates;
    @Unique
    protected Delayed8WayDistancePropagator2D ticketLevelPropagator;
    @Unique
    private ObjectArrayFIFOQueue<class_3193> pendingChunkHolderUpdates;

    @Shadow
    @Nullable
    protected abstract class_3193 method_14038(long var1);

    @Shadow
    @Nullable
    protected abstract class_3193 method_14053(long var1, int var3, @Nullable class_3193 var4, int var5);

    @Shadow
    protected abstract class_4706<class_3228<?>> method_14050(long var1);

    @Shadow
    protected static int method_14046(class_4706<class_3228<?>> sortedArraySet) {
        throw new AbstractMethodError();
    }

    @Unique
    private static int convertBetweenTicketLevels(int level) {
        return class_8563.field_44849 - level + 1;
    }

    @Unique
    protected final void updateTicketLevel(long coordinate, int ticketLevel) {
        if (ticketLevel > class_8563.field_44849) {
            this.ticketLevelPropagator.removeSource(coordinate);
        } else {
            this.ticketLevelPropagator.setSource(coordinate, MixinChunkTicketManager.convertBetweenTicketLevels(ticketLevel));
        }
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(Executor workerExecutor, Executor mainThreadExecutor, CallbackInfo ci) {
        this.field_18252 = null;
        this.ticketLevelUpdates = new Long2IntLinkedOpenHashMap(){

            protected void rehash(int newN) {
                if (newN < this.n) {
                    return;
                }
                super.rehash(newN);
            }
        };
        this.ticketLevelPropagator = new Delayed8WayDistancePropagator2D((coordinate, oldLevel, newLevel) -> this.ticketLevelUpdates.putAndMoveToLast(coordinate, MixinChunkTicketManager.convertBetweenTicketLevels(newLevel)));
        this.pendingChunkHolderUpdates = new ObjectArrayFIFOQueue();
    }

    @Redirect(method={"purge", "addTicket(JLnet/minecraft/server/world/ChunkTicket;)V", "removeTicket(JLnet/minecraft/server/world/ChunkTicket;)V", "removePersistentTickets"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/world/ChunkTicketManager$TicketDistanceLevelPropagator;updateLevel(JIZ)V"), require=3, expect=3)
    private void redirectUpdate(class_3204.class_4077 instance, long l, int i, boolean b) {
        this.updateTicketLevel(l, i);
    }

    @Overwrite
    public void method_14045() {
        ++this.field_13894;
        Predicate<class_3228> predicate = chunkTicket -> ((IChunkTicket)chunkTicket).invokeIsExpired1(this.field_13894);
        ObjectIterator objectIterator = this.field_13895.long2ObjectEntrySet().fastIterator();
        while (objectIterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)objectIterator.next();
            if (((class_4706)entry.getValue()).removeIf(predicate)) {
                this.updateTicketLevel(entry.getLongKey(), MixinChunkTicketManager.method_14046((class_4706)entry.getValue()));
            }
            if (!((class_4706)entry.getValue()).isEmpty()) continue;
            objectIterator.remove();
        }
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/world/ChunkTicketManager$TicketDistanceLevelPropagator;update(I)I"))
    public int tickTickets(class_3204.class_4077 __, int distance, class_3898 threadedAnvilChunkStorage) {
        if (!((IThreadedAnvilChunkStorage)threadedAnvilChunkStorage).getMainThreadExecutor().method_18854()) {
            throw new ConcurrentModificationException("Attempted to tick tickets asynchronously");
        }
        boolean hasUpdates = this.ticketLevelPropagator.propagateUpdates();
        if (hasUpdates) {
            // empty if block
        }
        while (!this.ticketLevelUpdates.isEmpty()) {
            class_3193 holder;
            int currentLevel;
            hasUpdates = true;
            long key = this.ticketLevelUpdates.firstLongKey();
            int newLevel = this.ticketLevelUpdates.removeFirstInt();
            if (newLevel == (currentLevel = (holder = this.method_14038(key)) == null ? class_8563.field_44849 + 1 : holder.method_14005())) continue;
            if ((holder = this.method_14053(key, newLevel, holder, currentLevel)) == null) {
                if (newLevel > class_8563.field_44849) continue;
                throw new IllegalStateException("Chunk holder not created");
            }
            this.pendingChunkHolderUpdates.enqueue((Object)holder);
        }
        while (!this.pendingChunkHolderUpdates.isEmpty()) {
            ((IChunkHolder)this.pendingChunkHolderUpdates.dequeue()).invokeTick1(threadedAnvilChunkStorage, this.field_17460);
        }
        return hasUpdates ? distance - 1 : distance;
    }
}

