/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.dye_depot.client;

import com.ninni.dye_depot.DyeDepot;
import com.ninni.dye_depot.client.particles.PoofParticleProvider;
import com.ninni.dye_depot.registry.DDBlockEntityType;
import com.ninni.dye_depot.registry.DDBlocks;
import com.ninni.dye_depot.registry.DDParticles;
import java.util.stream.Stream;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.BlockEntityRendererRegistry;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_5614;
import net.minecraft.class_823;
import net.minecraft.class_825;
import net.minecraft.class_834;

public class DyeDepotClient
implements ClientModInitializer {
    public void onInitializeClient() {
        DyeDepotClient.addResourcePacks();
        DyeDepotClient.registerModelLayers();
        DyeDepotClient.registerBlockRenderLayers();
        DyeDepotClient.registerParticles();
    }

    public static void addResourcePacks() {
        ModContainer modContainer = (ModContainer)FabricLoader.getInstance().getModContainer("dye_depot").orElseThrow(() -> new IllegalStateException("Dye Depot's ModContainer couldn't be found!"));
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)DyeDepot.modLoc("dye_override"), (ModContainer)modContainer, (ResourcePackActivationType)ResourcePackActivationType.DEFAULT_ENABLED);
    }

    private static <E extends class_2586> void registerRenderer(class_2591<? extends E> type, class_5614<E> renderer) {
        BlockEntityRendererRegistry.register(type, renderer);
    }

    private static void registerModelLayers() {
        DyeDepotClient.registerRenderer(DDBlockEntityType.SHULKER_BOX, class_834::new);
        DyeDepotClient.registerRenderer(DDBlockEntityType.BED, class_825::new);
        DyeDepotClient.registerRenderer(DDBlockEntityType.BANNER, class_823::new);
    }

    private static void registerParticles() {
        ParticleFactoryRegistry.getInstance().register(DDParticles.DYE_POOF, PoofParticleProvider::new);
    }

    private static void registerBlockRenderLayers() {
        BlockRenderLayerMap.INSTANCE.putBlocks(class_1921.method_23583(), (class_2248[])Stream.concat(DDBlocks.STAINED_GLASS.values(), DDBlocks.STAINED_GLASS_PANES.values()).toArray(class_2248[]::new));
    }
}

