/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.dye_depot.data.client;

import com.ninni.dye_depot.data.ModCompat;
import com.ninni.dye_depot.registry.DDBlocks;
import io.github.fabricators_of_create.porting_lib.data.ExistingFileHelper;
import io.github.fabricators_of_create.porting_lib.models.generators.ConfiguredModel;
import io.github.fabricators_of_create.porting_lib.models.generators.ModelFile;
import io.github.fabricators_of_create.porting_lib.models.generators.block.BlockModelBuilder;
import io.github.fabricators_of_create.porting_lib.models.generators.block.BlockStateProvider;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PresentBlock;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2389;
import net.minecraft.class_2504;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5544;
import net.minecraft.class_5545;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7784;
import net.minecraft.class_7924;

public class DDBlockModels
extends BlockStateProvider {
    private final CompletableFuture<class_7225.class_7874> lookup;

    public DDBlockModels(class_7784 output, CompletableFuture<class_7225.class_7874> lookup, ExistingFileHelper fileHelper) {
        super(output, "dye_depot", fileHelper);
        this.lookup = lookup;
    }

    protected void registerStatesAndModels() {
        class_7225.class_7874 lookup = this.lookup.join();
        class_7225.class_7226 blockLookup = lookup.method_46762(class_7924.field_41254);
        DDBlocks.WOOL.values().forEach(arg_0 -> ((DDBlockModels)this).simpleBlock(arg_0));
        DDBlocks.CARPETS.forEach(this::carpet);
        DDBlocks.TERRACOTTA.values().forEach(arg_0 -> ((DDBlockModels)this).simpleBlock(arg_0));
        DDBlocks.CONCRETE.values().forEach(arg_0 -> ((DDBlockModels)this).simpleBlock(arg_0));
        DDBlocks.CONCRETE_POWDER.values().forEach(arg_0 -> ((DDBlockModels)this).simpleBlock(arg_0));
        DDBlocks.GLAZED_TERRACOTTA.holders().forEach(this::glazedTerracotta);
        DDBlocks.STAINED_GLASS.values().forEach(arg_0 -> ((DDBlockModels)this).simpleBlock(arg_0));
        DDBlocks.STAINED_GLASS_PANES.forEach(this::stainedGlassPane);
        DDBlocks.SHULKER_BOXES.holders().forEach(this::particleOnly);
        DDBlocks.CANDLES.holders().forEach(this::candle);
        DDBlocks.CANDLE_CAKES.forEach(this::candleCake);
        DDBlocks.BANNERS.holders().forEach(this::banner);
        DDBlocks.WALL_BANNERS.holders().forEach(this::banner);
        DDBlocks.BEDS.holders().forEach(this::bed);
        DDBlocks.DYE_BASKETS.holders().forEach(this::basket);
        ModCompat.supplementariesHolders(blockLookup, "flag").holders().forEach(this::flag);
        ModCompat.supplementariesHolders(blockLookup, "present").forEach(this::present);
        ModCompat.supplementariesHolders(blockLookup, "trapped_present").forEach(this::present);
        ModCompat.supplementariesHolders(blockLookup, "candle_holder").forEach(this::candleHolder);
        ModCompat.supplementariesSquaredHolders(blockLookup, "gold_candle_holder").forEach(this::candleHolder);
    }

    private void carpet(class_1767 color, class_6880<? extends class_2248> block) {
        class_6880<class_2248> wool = DDBlocks.WOOL.holderOrThrow(color);
        this.simpleBlock((class_2248)block.comp_349(), (ModelFile)this.models().carpet(this.name(block), this.blockTexture(wool)));
    }

    private void glazedTerracotta(class_6880<? extends class_2248> block) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.vanillaResource("template_glazed_terracotta"))).texture("pattern", this.blockTexture(block));
        this.horizontalBlock((class_2248)block.comp_349(), (ModelFile)model);
    }

    private void stainedGlassPane(class_1767 color, class_6880<? extends class_2504> block) {
        this.paneBlock((class_2389)block.comp_349(), this.blockTexture(DDBlocks.STAINED_GLASS.getOrNull(color)), this.blockTexture(block).method_48331("_top"));
    }

    private void particleOnly(class_6880<? extends class_2248> block) {
        class_2960 texture = this.blockTexture(block);
        this.simpleBlock((class_2248)block.comp_349(), (ModelFile)((BlockModelBuilder)this.models().getBuilder(this.name(block))).texture("particle", texture));
    }

    private void candle(class_6880<? extends class_2248> block) {
        this.getVariantBuilder((class_2248)block.comp_349()).forAllStatesExcept(state -> {
            Boolean lit = (Boolean)state.method_11654((class_2769)class_5544.field_27175);
            Integer count = (Integer)state.method_11654((class_2769)class_5544.field_27174);
            String litSuffix = lit != false ? "_lit" : "";
            String countSuffix = List.of("_candle", "_two_candles", "_three_candles", "_four_candles").get(count - 1);
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_" + count + litSuffix, this.vanillaResource("template" + countSuffix))).texture("all", String.valueOf(this.blockTexture(block)) + litSuffix)).texture("particle", String.valueOf(this.blockTexture(block)) + litSuffix);
            return ConfiguredModel.builder().modelFile((ModelFile)model).build();
        }, new class_2769[]{class_2741.field_12508});
    }

    private void candleCake(class_1767 color, class_6880<? extends class_2248> block) {
        this.getVariantBuilder((class_2248)block.comp_349()).forAllStates(state -> {
            Boolean lit = (Boolean)state.method_11654((class_2769)class_5545.field_27183);
            String suffix = lit != false ? "_lit" : "";
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + suffix, this.vanillaResource("template_cake_with_candle"))).texture("candle", this.blockTexture(DDBlocks.CANDLES.getOrThrow(color)).method_48331(suffix))).texture("bottom", this.vanillaResource("cake_bottom"))).texture("top", this.vanillaResource("cake_top"))).texture("side", this.vanillaResource("cake_side"))).texture("particle", this.vanillaResource("cake_side"));
            return ConfiguredModel.builder().modelFile((ModelFile)model).build();
        });
    }

    private void banner(class_6880<? extends class_2248> block) {
        this.simpleBlock((class_2248)block.comp_349(), (ModelFile)this.models().getExistingFile(this.vanillaResource("banner")));
    }

    private void bed(class_6880<? extends class_2248> block) {
        this.simpleBlock((class_2248)block.comp_349(), (ModelFile)this.models().getExistingFile(this.vanillaResource("bed")));
    }

    private void basket(class_6880<? extends class_2248> block) {
        class_2960 texture = this.blockTexture(block);
        BlockModelBuilder model = (BlockModelBuilder)this.models().orientableWithBottom(this.name(block), texture.method_48331("_side"), texture.method_48331("_front"), texture.method_48331("_bottom"), texture.method_48331("_top"));
        this.horizontalBlock((class_2248)block.comp_349(), (ModelFile)model);
    }

    private void candleHolder(class_1767 color, class_6880<? extends class_2248> block) {
        this.getVariantBuilder((class_2248)block.comp_349()).forAllStatesExcept(state -> {
            Boolean lit = (Boolean)state.method_11654((class_2769)class_2741.field_12548);
            Integer candles = (Integer)state.method_11654((class_2769)class_2741.field_27220);
            class_2350 facing = (class_2350)state.method_11654((class_2769)class_2383.field_11177);
            class_2738 face = (class_2738)state.method_11654((class_2769)class_2741.field_12555);
            String suffix = face.method_15434() + "_" + candles;
            String litSuffix = lit != false ? "_lit" : "";
            String namespace = this.key(block).method_12836();
            class_2960 parent = new class_2960(namespace, "block/candle_holders/" + suffix);
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(namespace + ":block/candle_holders/" + String.valueOf(color) + "_" + suffix + litSuffix, parent)).texture("all", String.valueOf(this.blockTexture(DDBlocks.CANDLES.getOrNull(color))) + litSuffix);
            return ConfiguredModel.builder().modelFile((ModelFile)model).rotationY((int)facing.method_10144() + 180).build();
        }, new class_2769[]{class_2741.field_12508});
    }

    private void flag(class_6880<? extends class_2248> block) {
        this.simpleBlock((class_2248)block.comp_349(), (ModelFile)this.models().getExistingFile(new class_2960("supplementaries", "block/flag")));
    }

    private void present(class_1767 color, class_6880<? extends class_2248> block) {
        String type = this.name(block).replace("_" + String.valueOf(color), "");
        this.getVariantBuilder((class_2248)block.comp_349()).forAllStatesExcept(state -> {
            Boolean packed = (Boolean)state.method_11654((class_2769)PresentBlock.PACKED);
            String suffix = packed != false ? "_closed" : "_opened";
            class_2960 parent = new class_2960("supplementaries", "block/present" + suffix + "_template");
            class_2960 sideTexture = new class_2960("supplementaries", "block/" + type + "s/side_" + String.valueOf(color));
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("supplementaries:block/" + type + "s/" + String.valueOf(color) + suffix, parent)).texture("bottom", new class_2960("supplementaries", "block/presents/bottom_" + String.valueOf(color)))).texture("top", new class_2960("supplementaries", "block/presents/top_" + String.valueOf(color)))).texture("side", sideTexture)).texture("particle", sideTexture);
            return ConfiguredModel.builder().modelFile((ModelFile)model).build();
        }, new class_2769[]{class_2741.field_12508});
    }

    private class_2960 vanillaResource(String name) {
        return new class_2960("block/" + name);
    }

    private class_2960 key(class_6880<? extends class_2248> block) {
        return ((class_5321)block.method_40230().orElseThrow()).method_29177();
    }

    private String name(class_6880<? extends class_2248> block) {
        return this.key(block).method_12832();
    }

    private class_2960 blockTexture(class_6880<? extends class_2248> block) {
        return ((class_5321)block.method_40230().orElseThrow()).method_29177().method_45138("block/");
    }
}

