/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.dye_depot.registry;

import com.google.common.collect.ImmutableMap;
import com.ninni.dye_depot.registry.DDDyes;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1767;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public final class DyedHolders<TImplementation extends RRegistry, RRegistry> {
    private final Map<class_1767, class_6880<TImplementation>> entries;

    private DyedHolders(Map<class_1767, class_6880<TImplementation>> entries) {
        this.entries = entries;
    }

    public static <T extends R, R> DyedHolders<T, R> create(Stream<class_1767> colors, Function<class_1767, class_6880<T>> mapper) {
        Map entries = colors.collect(Collectors.toMap(Function.identity(), mapper));
        return new DyedHolders(entries);
    }

    public static <T extends R, R> DyedHolders<T, R> createModded(Function<class_1767, class_6880<T>> mapper) {
        return DyedHolders.create(Arrays.stream(DDDyes.values()).map(DDDyes::get), mapper);
    }

    @SafeVarargs
    public static <T extends R, R> DyedHolders<T, R> merge(DyedHolders<T, R> ... from) {
        ImmutableMap.Builder entries = ImmutableMap.builder();
        for (DyedHolders<T, R> holders : from) {
            entries.putAll(holders.entries);
        }
        return new DyedHolders(entries.build());
    }

    public static Stream<class_1767> vanillaColors() {
        return Arrays.stream(class_1767.values()).filter((? super T it) -> it.method_7789() < 16);
    }

    public static Stream<class_1767> modColors() {
        return Arrays.stream(DDDyes.values()).map(DDDyes::get);
    }

    public static <T extends R, R> DyedHolders<T, R> createWithVanilla(Function<class_1767, class_6880<T>> mapper) {
        return DyedHolders.create(Stream.concat(DyedHolders.vanillaColors(), DyedHolders.modColors()), mapper);
    }

    public static <T extends R, R> DyedHolders<T, R> fromRegistry(class_7225.class_7226<R> registry, Stream<class_1767> colors, class_2960 baseName) {
        return DyedHolders.fromRegistry(registry, colors, (class_1767 color) -> baseName.method_45138(String.valueOf(color) + "_"));
    }

    public static <T extends R, R> DyedHolders<T, R> fromRegistry(class_7225.class_7226<R> registry, Stream<class_1767> colors, Function<class_1767, class_2960> idMapper) {
        class_5321 registryKey = registry.method_46765();
        Function<class_1767, class_5321<R>> keyMapper = idMapper.andThen(id -> class_5321.method_29179((class_5321)registryKey, (class_2960)id));
        return DyedHolders.fromLookup(registry, colors, keyMapper);
    }

    public static <T extends R, R> DyedHolders<T, R> fromLookup(class_7225<R> registry, Stream<class_1767> colors, Function<class_1767, class_5321<R>> idMapper) {
        return DyedHolders.create(colors, color -> registry.method_46747((class_5321)idMapper.apply((class_1767)color)));
    }

    @Nullable
    public class_6880<TImplementation> holderOrNull(class_1767 color) {
        return this.entries.get(color);
    }

    public Optional<class_6880<TImplementation>> holder(class_1767 color) {
        return Optional.ofNullable(this.holderOrNull(color));
    }

    @Nullable
    public TImplementation getOrNull(class_1767 color) {
        return this.get(color).orElse(null);
    }

    public Optional<TImplementation> get(class_1767 color) {
        return this.holder(color).map(class_6880::comp_349);
    }

    public class_6880<TImplementation> holderOrThrow(class_1767 color) {
        return Objects.requireNonNull(this.holderOrNull(color), () -> "holders does not contain block of color " + String.valueOf(color));
    }

    public TImplementation getOrThrow(class_1767 color) {
        return (TImplementation)this.holderOrThrow(color).comp_349();
    }

    public Stream<class_6880<TImplementation>> holders() {
        return this.entries.entrySet().stream().sorted(Comparator.comparing(it -> ((class_1767)it.getKey()).method_7789())).map(Map.Entry::getValue);
    }

    public Stream<TImplementation> values() {
        return this.holders().map(class_6880::comp_349);
    }

    public void forEach(BiConsumer<class_1767, class_6880<TImplementation>> consumer) {
        this.entries.entrySet().stream().sorted(Comparator.comparing(it -> ((class_1767)it.getKey()).method_7789())).forEach((? super T it) -> consumer.accept((class_1767)it.getKey(), (class_6880)it.getValue()));
    }

    public <R> Stream<R> map(BiFunction<class_1767, TImplementation, R> mapper) {
        return this.entries.entrySet().stream().map((? super T it) -> mapper.apply((class_1767)it.getKey(), ((class_6880)it.getValue()).comp_349()));
    }

    public DyedHolders<TImplementation, RRegistry> filter(Supplier<Stream<class_1767>> colors) {
        return this.filter((class_1767 color, class_6880<TImplementation> $) -> ((Stream)colors.get()).anyMatch(it -> it == color));
    }

    public DyedHolders<TImplementation, RRegistry> filter(BiPredicate<class_1767, class_6880<TImplementation>> predicate) {
        ImmutableMap.Builder entries = ImmutableMap.builder();
        this.forEach((color, value) -> {
            if (predicate.test((class_1767)color, (class_6880)value)) {
                entries.put(color, value);
            }
        });
        return new DyedHolders<TImplementation, RRegistry>(entries.build());
    }

    public String detectBaseName() {
        Map.Entry entry = (Map.Entry)this.entries.entrySet().stream().findFirst().orElseThrow(() -> new NoSuchElementException("DyedHolders is empty"));
        class_2960 id = ((class_5321)((class_6880)entry.getValue()).method_40230().orElseThrow()).method_29177();
        return Pattern.compile("_?" + String.valueOf(entry.getKey()) + "_?").matcher(id.method_12832()).replaceFirst("");
    }

    public DyedHolders<TImplementation, RRegistry> mergeVanilla(class_7225.class_7226<RRegistry> registry) {
        String base = this.detectBaseName();
        DyedHolders vanillaVariants = DyedHolders.fromRegistry(registry, DyedHolders.vanillaColors(), new class_2960(base));
        return DyedHolders.merge(vanillaVariants, this);
    }
}

