/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.networking;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.frozenblock.lib.cape.api.CapeUtil;
import net.frozenblock.lib.cape.client.impl.ClientCapeData;
import net.frozenblock.lib.cape.impl.networking.CapeCustomizePacket;
import net.frozenblock.lib.cape.impl.networking.LoadCapeRepoPacket;
import net.frozenblock.lib.config.api.instance.Config;
import net.frozenblock.lib.config.api.registry.ConfigRegistry;
import net.frozenblock.lib.config.frozenlib_config.FrozenLibConfig;
import net.frozenblock.lib.config.impl.network.ConfigSyncPacket;
import net.frozenblock.lib.image_transfer.FileTransferPacket;
import net.frozenblock.lib.image_transfer.client.ServerTexture;
import net.frozenblock.lib.item.impl.network.CooldownChangePacket;
import net.frozenblock.lib.item.impl.network.CooldownTickCountPacket;
import net.frozenblock.lib.item.impl.network.ForcedCooldownPacket;
import net.frozenblock.lib.networking.FrozenNetworking;
import net.frozenblock.lib.screenshake.api.client.ScreenShaker;
import net.frozenblock.lib.screenshake.impl.network.EntityScreenShakePacket;
import net.frozenblock.lib.screenshake.impl.network.RemoveEntityScreenShakePacket;
import net.frozenblock.lib.screenshake.impl.network.RemoveScreenShakePacket;
import net.frozenblock.lib.screenshake.impl.network.ScreenShakePacket;
import net.frozenblock.lib.sound.api.instances.distance_based.FadingDistanceSwitchingSound;
import net.frozenblock.lib.sound.api.instances.distance_based.RestrictedMovingFadingDistanceSwitchingSoundLoop;
import net.frozenblock.lib.sound.api.networking.FlyBySoundPacket;
import net.frozenblock.lib.sound.api.networking.LocalPlayerSoundPacket;
import net.frozenblock.lib.sound.api.networking.LocalSoundPacket;
import net.frozenblock.lib.sound.api.networking.MovingRestrictionSoundPacket;
import net.frozenblock.lib.sound.api.networking.StartingMovingRestrictionSoundLoopPacket;
import net.frozenblock.lib.sound.api.predicate.SoundPredicate;
import net.frozenblock.lib.spotting_icons.impl.EntitySpottingIconInterface;
import net.frozenblock.lib.spotting_icons.impl.SpottingIconPacket;
import net.frozenblock.lib.spotting_icons.impl.SpottingIconRemovePacket;
import net.frozenblock.lib.wind.api.ClientWindManager;
import net.frozenblock.lib.wind.api.ClientWindManagerExtension;
import net.frozenblock.lib.wind.api.WindDisturbance;
import net.frozenblock.lib.wind.api.WindDisturbanceLogic;
import net.frozenblock.lib.wind.impl.networking.WindDisturbancePacket;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1796;
import net.minecraft.class_2338;
import net.minecraft.class_2359;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_642;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.apache.commons.io.FileUtils;

@Environment(value=EnvType.CLIENT)
public final class FrozenClientNetworking {
    public static void registerClientReceivers() {
        ClientPlayNetworking.registerGlobalReceiver(LocalSoundPacket.PACKET_TYPE, LocalSoundPacket::receive);
        ClientPlayNetworking.registerGlobalReceiver(MovingRestrictionSoundPacket.PACKET_TYPE, MovingRestrictionSoundPacket::receive);
        ClientPlayNetworking.registerGlobalReceiver(StartingMovingRestrictionSoundLoopPacket.PACKET_TYPE, StartingMovingRestrictionSoundLoopPacket::receive);
        FrozenClientNetworking.receiveMovingRestrictionLoopingFadingDistanceSoundPacket();
        FrozenClientNetworking.receiveMovingFadingDistanceSoundPacket();
        FrozenClientNetworking.receiveFadingDistanceSoundPacket();
        ClientPlayNetworking.registerGlobalReceiver(FlyBySoundPacket.PACKET_TYPE, FlyBySoundPacket::receive);
        FrozenClientNetworking.receiveCooldownChangePacket();
        FrozenClientNetworking.receiveForcedCooldownPacket();
        FrozenClientNetworking.receiveCooldownTickCountPacket();
        FrozenClientNetworking.receiveScreenShakePacket();
        FrozenClientNetworking.receiveScreenShakeFromEntityPacket();
        FrozenClientNetworking.receiveRemoveScreenShakePacket();
        FrozenClientNetworking.receiveRemoveScreenShakeFromEntityPacket();
        FrozenClientNetworking.receiveIconPacket();
        FrozenClientNetworking.receiveIconRemovePacket();
        FrozenClientNetworking.receiveWindSyncPacket();
        FrozenClientNetworking.receiveWindDisturbancePacket();
        ClientPlayNetworking.registerGlobalReceiver(LocalPlayerSoundPacket.PACKET_TYPE, LocalPlayerSoundPacket::receive);
        FrozenClientNetworking.receiveCapePacket();
        FrozenClientNetworking.receiveCapeRepoPacket();
        ClientPlayNetworking.registerGlobalReceiver(ConfigSyncPacket.PACKET_TYPE, (packet, ctx, sender) -> ConfigSyncPacket.receive(packet, null));
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            for (Config<?> config : ConfigRegistry.getAllConfigs()) {
                ConfigRegistry.setSyncData(config, null);
                config.setSynced(false);
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(FileTransferPacket.PACKET_TYPE, (packet, player, sender) -> {
            if (!FrozenLibConfig.FILE_TRANSFER_CLIENT) {
                return;
            }
            if (packet.request()) {
                Path path = class_310.method_1551().field_1697.toPath().resolve(packet.transferPath()).resolve(packet.fileName());
                try {
                    FileTransferPacket fileTransferPacket = FileTransferPacket.create(packet.transferPath(), path.toFile());
                    ClientPlayNetworking.send((FabricPacket)fileTransferPacket);
                }
                catch (IOException fileTransferPacket) {}
            } else {
                try {
                    Path path = class_310.method_1551().field_1697.toPath().resolve(packet.transferPath()).resolve(packet.fileName());
                    FileUtils.copyInputStreamToFile((InputStream)new ByteArrayInputStream(packet.bytes()), (File)path.toFile());
                    ServerTexture serverTexture = ServerTexture.WAITING_TEXTURES.get(packet.transferPath() + "/" + packet.fileName());
                    if (serverTexture != null) {
                        serverTexture.runFutureForTexture();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    private static <T extends class_1297> void receiveMovingRestrictionLoopingFadingDistanceSoundPacket() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)FrozenNetworking.MOVING_RESTRICTION_LOOPING_FADING_DISTANCE_SOUND_PACKET, (ctx, handler, byteBuf, responseSender) -> {
            int id = byteBuf.method_10816();
            class_3414 sound = (class_3414)byteBuf.method_42064((class_2359)class_7923.field_41172);
            class_3414 sound2 = (class_3414)byteBuf.method_42064((class_2359)class_7923.field_41172);
            class_3419 category = (class_3419)byteBuf.method_10818(class_3419.class);
            float volume = byteBuf.readFloat();
            float pitch = byteBuf.readFloat();
            float fadeDist = byteBuf.readFloat();
            float maxDist = byteBuf.readFloat();
            class_2960 predicateId = byteBuf.method_10810();
            boolean stopOnDeath = byteBuf.readBoolean();
            ctx.execute(() -> {
                class_1297 entity;
                class_638 level = ctx.field_1687;
                if (level != null && (entity = level.method_8469(id)) != null) {
                    SoundPredicate.LoopPredicate predicate = SoundPredicate.getPredicate(predicateId);
                    ctx.method_1483().method_4873(new RestrictedMovingFadingDistanceSwitchingSoundLoop<class_1297>(entity, sound, category, volume, pitch, predicate, stopOnDeath, fadeDist, maxDist, volume, false));
                    ctx.method_1483().method_4873(new RestrictedMovingFadingDistanceSwitchingSoundLoop<class_1297>(entity, sound2, category, volume, pitch, predicate, stopOnDeath, fadeDist, maxDist, volume, true));
                }
            });
        });
    }

    private static <T extends class_1297> void receiveMovingFadingDistanceSoundPacket() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)FrozenNetworking.MOVING_FADING_DISTANCE_SOUND_PACKET, (ctx, handler, byteBuf, responseSender) -> {
            int id = byteBuf.method_10816();
            class_3414 sound = (class_3414)byteBuf.method_42064((class_2359)class_7923.field_41172);
            class_3414 sound2 = (class_3414)byteBuf.method_42064((class_2359)class_7923.field_41172);
            class_3419 category = (class_3419)byteBuf.method_10818(class_3419.class);
            float volume = byteBuf.readFloat();
            float pitch = byteBuf.readFloat();
            float fadeDist = byteBuf.readFloat();
            float maxDist = byteBuf.readFloat();
            class_2960 predicateId = byteBuf.method_10810();
            boolean stopOnDeath = byteBuf.readBoolean();
            ctx.execute(() -> {
                class_1297 entity;
                class_638 level = ctx.field_1687;
                if (level != null && (entity = level.method_8469(id)) != null) {
                    SoundPredicate.LoopPredicate predicate = SoundPredicate.getPredicate(predicateId);
                    ctx.method_1483().method_4873(new RestrictedMovingFadingDistanceSwitchingSoundLoop<class_1297>(entity, sound, category, volume, pitch, predicate, stopOnDeath, fadeDist, maxDist, volume, false));
                    ctx.method_1483().method_4873(new RestrictedMovingFadingDistanceSwitchingSoundLoop<class_1297>(entity, sound2, category, volume, pitch, predicate, stopOnDeath, fadeDist, maxDist, volume, true));
                }
            });
        });
    }

    private static void receiveFadingDistanceSoundPacket() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)FrozenNetworking.FADING_DISTANCE_SOUND_PACKET, (ctx, handler, byteBuf, responseSender) -> {
            double x = byteBuf.readDouble();
            double y = byteBuf.readDouble();
            double z = byteBuf.readDouble();
            class_3414 sound = (class_3414)byteBuf.method_42064((class_2359)class_7923.field_41172);
            class_3414 sound2 = (class_3414)byteBuf.method_42064((class_2359)class_7923.field_41172);
            class_3419 category = (class_3419)byteBuf.method_10818(class_3419.class);
            float volume = byteBuf.readFloat();
            float pitch = byteBuf.readFloat();
            float fadeDist = byteBuf.readFloat();
            float maxDist = byteBuf.readFloat();
            ctx.execute(() -> {
                class_638 level = ctx.field_1687;
                if (level != null) {
                    ctx.method_1483().method_4873((class_1113)new FadingDistanceSwitchingSound(sound, category, volume, pitch, fadeDist, maxDist, volume, false, x, y, z));
                    ctx.method_1483().method_4873((class_1113)new FadingDistanceSwitchingSound(sound2, category, volume, pitch, fadeDist, maxDist, volume, true, x, y, z));
                }
            });
        });
    }

    private static void receiveCooldownChangePacket() {
        ClientPlayNetworking.registerGlobalReceiver(CooldownChangePacket.PACKET_TYPE, (packet, player, responseSender) -> {
            class_1792 item = packet.item();
            int additional = packet.additional();
            if (player != null) {
                player.method_7357().frozenLib$changeCooldown(item, additional);
            }
        });
    }

    private static void receiveForcedCooldownPacket() {
        ClientPlayNetworking.registerGlobalReceiver(ForcedCooldownPacket.PACKET_TYPE, (packet, player, responseSender) -> {
            class_1792 item = packet.item();
            int startTime = packet.startTime();
            int endTime = packet.endTime();
            if (player != null) {
                player.method_7357().field_8024.put(item, new class_1796.class_1797(startTime, endTime));
            }
        });
    }

    private static void receiveCooldownTickCountPacket() {
        ClientPlayNetworking.registerGlobalReceiver(CooldownTickCountPacket.PACKET_TYPE, (packet, player, responseSender) -> {
            if (player != null) {
                player.method_7357().field_8025 = packet.count();
            }
        });
    }

    private static void receiveScreenShakePacket() {
        ClientPlayNetworking.registerGlobalReceiver(ScreenShakePacket.PACKET_TYPE, (packet, player, responseSender) -> {
            float intensity = packet.intensity();
            int duration = packet.duration();
            int fallOffStart = packet.falloffStart();
            double x = packet.x();
            double y = packet.y();
            double z = packet.z();
            float maxDistance = packet.maxDistance();
            int ticks = packet.ticks();
            class_638 level = player.field_17892;
            class_243 pos = new class_243(x, y, z);
            ScreenShaker.addShake(level, intensity, duration, fallOffStart, pos, maxDistance, ticks);
        });
    }

    private static void receiveScreenShakeFromEntityPacket() {
        ClientPlayNetworking.registerGlobalReceiver(EntityScreenShakePacket.PACKET_TYPE, (packet, player, responseSender) -> {
            int id = packet.entityId();
            float intensity = packet.intensity();
            int duration = packet.duration();
            int fallOffStart = packet.falloffStart();
            float maxDistance = packet.maxDistance();
            int ticks = packet.ticks();
            class_638 level = player.field_17892;
            class_1297 entity = level.method_8469(id);
            if (entity != null) {
                ScreenShaker.addShake(entity, intensity, duration, fallOffStart, maxDistance, ticks);
            }
        });
    }

    private static void receiveRemoveScreenShakePacket() {
        ClientPlayNetworking.registerGlobalReceiver(RemoveScreenShakePacket.PACKET_TYPE, (packet, player, responseSender) -> ScreenShaker.SCREEN_SHAKES.removeIf(clientScreenShake -> !(clientScreenShake instanceof ScreenShaker.ClientEntityScreenShake)));
    }

    private static void receiveRemoveScreenShakeFromEntityPacket() {
        ClientPlayNetworking.registerGlobalReceiver(RemoveEntityScreenShakePacket.PACKET_TYPE, (packet, player, responseSender) -> {
            class_638 level = player.field_17892;
            int id = packet.entityId();
            class_1297 entity = level.method_8469(id);
            if (entity != null) {
                ScreenShaker.SCREEN_SHAKES.removeIf(clientScreenShake -> {
                    ScreenShaker.ClientEntityScreenShake entityScreenShake;
                    return clientScreenShake instanceof ScreenShaker.ClientEntityScreenShake && (entityScreenShake = (ScreenShaker.ClientEntityScreenShake)clientScreenShake).getEntity() == entity;
                });
            }
        });
    }

    private static void receiveIconPacket() {
        ClientPlayNetworking.registerGlobalReceiver(SpottingIconPacket.PACKET_TYPE, (packet, player, responseSender) -> {
            int id = packet.entityId();
            class_2960 texture = packet.texture();
            float startFade = packet.startFade();
            float endFade = packet.endFade();
            class_2960 predicate = packet.restrictionID();
            class_638 level = player.field_17892;
            class_1297 entity = level.method_8469(id);
            if (entity instanceof EntitySpottingIconInterface) {
                EntitySpottingIconInterface livingEntity = (EntitySpottingIconInterface)entity;
                livingEntity.getSpottingIconManager().setIcon(texture, startFade, endFade, predicate);
            }
        });
    }

    private static void receiveIconRemovePacket() {
        ClientPlayNetworking.registerGlobalReceiver(SpottingIconRemovePacket.PACKET_TYPE, (packet, player, responseSender) -> {
            class_638 level = player.field_17892;
            int id = packet.entityId();
            class_1297 entity = level.method_8469(id);
            if (entity instanceof EntitySpottingIconInterface) {
                EntitySpottingIconInterface livingEntity = (EntitySpottingIconInterface)entity;
                livingEntity.getSpottingIconManager().icon = null;
            }
        });
    }

    private static void receiveWindSyncPacket() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)FrozenNetworking.WIND_SYNC_PACKET, (ctx, handler, byteBuf, responseSender) -> {
            long windTime = byteBuf.readLong();
            long seed = byteBuf.readLong();
            boolean override = byteBuf.readBoolean();
            double commandX = byteBuf.readDouble();
            double commandY = byteBuf.readDouble();
            double commandZ = byteBuf.readDouble();
            ctx.execute(() -> {
                if (ctx.field_1687 != null) {
                    ClientWindManager.time = windTime;
                    ClientWindManager.setSeed(seed);
                    ClientWindManager.overrideWind = override;
                    ClientWindManager.commandWind = new class_243(commandX, commandY, commandZ);
                    ClientWindManager.hasInitialized = true;
                }
            });
            for (ClientWindManagerExtension extension : ClientWindManager.EXTENSIONS) {
                extension.receiveSyncPacket(byteBuf, ctx);
            }
        });
    }

    private static void receiveWindDisturbancePacket() {
        ClientPlayNetworking.registerGlobalReceiver(WindDisturbancePacket.PACKET_TYPE, (packet, player, sender) -> {
            class_638 level = player.field_17892;
            long posOrID = packet.posOrID();
            Optional<WindDisturbanceLogic<?>> disturbanceLogic = WindDisturbanceLogic.getWindDisturbanceLogic(packet.id());
            if (disturbanceLogic.isPresent()) {
                WindDisturbanceLogic.SourceType sourceType = packet.disturbanceSourceType();
                Optional<Object> source = Optional.empty();
                if (sourceType == WindDisturbanceLogic.SourceType.ENTITY) {
                    source = Optional.ofNullable(level.method_8469((int)posOrID));
                } else if (sourceType == WindDisturbanceLogic.SourceType.BLOCK_ENTITY) {
                    source = Optional.ofNullable(level.method_8321(class_2338.method_10092((long)posOrID)));
                }
                ClientWindManager.addWindDisturbance(new WindDisturbance(source, packet.origin(), packet.affectedArea(), disturbanceLogic.get()));
            }
        });
    }

    private static void receiveCapePacket() {
        ClientPlayNetworking.registerGlobalReceiver(CapeCustomizePacket.PACKET_TYPE, (packet, ctx, sender) -> {
            UUID uuid = packet.getPlayerUUID();
            if (packet.isEnabled()) {
                ClientCapeData.setCapeForUUID(uuid, packet.getCapeId());
            } else {
                ClientCapeData.removeCapeForUUID(uuid);
            }
        });
    }

    private static void receiveCapeRepoPacket() {
        ClientPlayNetworking.registerGlobalReceiver(LoadCapeRepoPacket.PACKET_TYPE, (packet, ctx, sender) -> CapeUtil.registerCapesFromURL(packet.capeRepo()));
    }

    public static boolean notConnected() {
        class_310 minecraft = class_310.method_1551();
        class_634 listener = minecraft.method_1562();
        if (listener == null) {
            return true;
        }
        class_746 player = class_310.method_1551().field_1724;
        return player == null;
    }

    public static boolean connectedToLan() {
        if (FrozenClientNetworking.notConnected()) {
            return false;
        }
        class_642 serverData = class_310.method_1551().method_1558();
        if (serverData == null) {
            return false;
        }
        return serverData.method_2994();
    }
}

