/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.personthecat.fresult;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.CheckReturnValue;
import net.frozenblock.lib.shadow.personthecat.fresult.OptionalResult;
import net.frozenblock.lib.shadow.personthecat.fresult.Result;
import net.frozenblock.lib.shadow.personthecat.fresult.Shorthand;
import net.frozenblock.lib.shadow.personthecat.fresult.Void;
import net.frozenblock.lib.shadow.personthecat.fresult.functions.ThrowingOptionalSupplier;
import net.frozenblock.lib.shadow.personthecat.fresult.functions.ThrowingRunnable;
import net.frozenblock.lib.shadow.personthecat.fresult.functions.ThrowingSupplier;

public final class Protocol {
    private final Set<Procedure<? extends Throwable>> procedures = new HashSet<Procedure<? extends Throwable>>();

    Protocol() {
    }

    @CheckReturnValue
    public <E extends Throwable> Protocol define(Class<E> type, Consumer<E> func) {
        this.procedures.add(new Procedure<E>(type, func));
        return this;
    }

    @CheckReturnValue
    public <T> Result<T, Throwable> suppress(ThrowingSupplier<T, Throwable> attempt) {
        T value;
        try {
            value = attempt.get();
        }
        catch (Throwable e) {
            if (this.tryHandle(e)) {
                return Result.err(e);
            }
            throw Shorthand.missingProcedureEx(e);
        }
        return Result.ok(Objects.requireNonNull(value, "nonnull attempt"));
    }

    @CheckReturnValue
    public Result<Void, Throwable> suppress(ThrowingRunnable<Throwable> attempt) {
        return this.suppress(Result.wrapVoid(attempt));
    }

    public <T> OptionalResult<T, Throwable> nullable(ThrowingSupplier<T, Throwable> attempt) {
        try {
            return Result.nullable(attempt.get());
        }
        catch (Throwable e) {
            if (this.tryHandle(e)) {
                return Result.err(e);
            }
            throw Shorthand.missingProcedureEx(e);
        }
    }

    public <T> OptionalResult<T, Throwable> nullable(ThrowingOptionalSupplier<T, Throwable> attempt) {
        return this.nullable(() -> attempt.get().orElse(null));
    }

    @CheckReturnValue
    public <T> Optional<T> get(ThrowingSupplier<T, Throwable> attempt) {
        return this.nullable(attempt).get();
    }

    public void run(ThrowingRunnable<Throwable> attempt) {
        block2: {
            try {
                attempt.run();
            }
            catch (Throwable e) {
                if (this.tryHandle(e)) break block2;
                throw Shorthand.missingProcedureEx(e);
            }
        }
    }

    private boolean tryHandle(Throwable e) {
        return this.procedures.stream().anyMatch(proc -> {
            if (proc.clazz.isInstance(e)) {
                proc.func.accept(this.cast(e));
                return true;
            }
            return false;
        });
    }

    private <E extends Throwable> E cast(Throwable e) {
        return (E)e;
    }

    private record Procedure<T>(Class<T> clazz, Consumer<T> func) {
    }
}

