/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.personthecat.fresult;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.CheckReturnValue;
import net.frozenblock.lib.shadow.personthecat.fresult.OptionalResult;
import net.frozenblock.lib.shadow.personthecat.fresult.Result;
import net.frozenblock.lib.shadow.personthecat.fresult.Shorthand;
import net.frozenblock.lib.shadow.personthecat.fresult.functions.ThrowingOptionalSupplier;
import net.frozenblock.lib.shadow.personthecat.fresult.functions.ThrowingSupplier;

public class Resolver<T> {
    private final Set<Procedure<Throwable, T>> procedures = new HashSet<Procedure<Throwable, T>>();

    Resolver() {
    }

    @CheckReturnValue
    public <E extends Throwable> Resolver<T> resolve(Class<E> type, Function<E, T> func) {
        this.procedures.add(new Procedure<E, T>(type, func));
        return this;
    }

    @CheckReturnValue
    public Result.Value<T, Throwable> suppress(ThrowingSupplier<T, Throwable> attempt) {
        T value;
        try {
            value = attempt.get();
        }
        catch (Throwable e) {
            value = this.tryHandle(e);
        }
        return Result.ok(Objects.requireNonNull(value, "nonnull attempt"));
    }

    public OptionalResult<T, Throwable> nullable(ThrowingSupplier<T, Throwable> attempt) {
        try {
            return Result.nullable(attempt.get());
        }
        catch (Throwable e) {
            return Result.nullable(this.tryHandle(e));
        }
    }

    public OptionalResult<T, Throwable> nullable(ThrowingOptionalSupplier<T, Throwable> attempt) {
        return this.nullable(() -> attempt.get().orElse(null));
    }

    @CheckReturnValue
    public Optional<T> get(ThrowingSupplier<T, Throwable> attempt) {
        return this.nullable(attempt).get();
    }

    public T expose(ThrowingSupplier<T, Throwable> attempt) {
        return this.suppress(attempt).expose();
    }

    private T tryHandle(Throwable e) {
        for (Procedure<Throwable, T> proc : this.procedures) {
            if (!proc.clazz.isInstance(e)) continue;
            return (T)proc.func.apply((Throwable)proc.clazz.cast(e));
        }
        throw Shorthand.missingProcedureEx(e);
    }

    private <E extends Throwable> E cast(Throwable e) {
        return (E)e;
    }

    private static class Procedure<E extends Throwable, R> {
        final Class<E> clazz;
        final Function<E, R> func;

        Procedure(Class<E> clazz, Function<E, R> func) {
            this.clazz = clazz;
            this.func = func;
        }
    }
}

