/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.compat.serialization.writer;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import net.frozenblock.lib.shadow.xjs.data.JsonContainer;
import net.frozenblock.lib.shadow.xjs.data.JsonReference;
import net.frozenblock.lib.shadow.xjs.data.JsonValue;
import net.frozenblock.lib.shadow.xjs.data.StringType;
import net.frozenblock.lib.shadow.xjs.data.comments.CommentType;
import net.frozenblock.lib.shadow.xjs.data.serialization.writer.DjsWriter;
import net.frozenblock.lib.shadow.xjs.data.serialization.writer.JsonWriterOptions;

public class HjsonWriter
extends DjsWriter {
    public HjsonWriter(File file, boolean format) throws IOException {
        super(file, format);
    }

    public HjsonWriter(Writer writer, boolean format) {
        super(writer, format);
    }

    public HjsonWriter(File file, JsonWriterOptions options) throws IOException {
        super(file, options);
    }

    public HjsonWriter(Writer writer, JsonWriterOptions options) {
        super(writer, options);
    }

    @Override
    protected boolean shouldSeparateOpener() {
        JsonContainer c = this.parent();
        return this.format && this.allowCondense && this.level > 0 && c.size() > 0 && this.getLinesAbove(this.getFirst(this.parent())) == 0;
    }

    @Override
    protected boolean shouldSeparateCloser() {
        return this.level > 0 && this.isCondensed();
    }

    @Override
    protected void delimit() throws IOException {
        if (this.peek == null) {
            return;
        }
        if (!this.format) {
            this.tw.write(44);
        } else if (this.allowCondense && this.getLinesAbove(this.peek()) == 0) {
            this.tw.write(44);
            this.tw.write(this.separator);
        }
    }

    @Override
    protected StringType getKeyType(String key) {
        if (key.isEmpty()) {
            return StringType.SINGLE;
        }
        boolean whitespaceFound = false;
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (c == '\'') {
                return StringType.DOUBLE;
            }
            if (c == '\"') {
                return StringType.SINGLE;
            }
            whitespaceFound |= Character.isWhitespace(c);
        }
        return whitespaceFound ? StringType.SINGLE : StringType.IMPLICIT;
    }

    @Override
    protected void writeString(JsonValue value) throws IOException {
        switch (this.getStringType(value)) {
            case SINGLE: {
                this.writeQuoted(value.asString(), '\'');
                break;
            }
            case DOUBLE: {
                this.writeQuoted(value.asString(), '\"');
                break;
            }
            case MULTI: {
                this.writeMulti(value.asString());
                break;
            }
            case IMPLICIT: {
                this.tw.write(value.asString());
                break;
            }
            default: {
                throw new IllegalStateException("unreachable");
            }
        }
    }

    @Override
    protected StringType getStringType(JsonValue value) {
        StringType type = StringType.fromValue(value);
        String s = value.asString();
        if (this.isCondensed() && (type == StringType.IMPLICIT || type == StringType.NONE)) {
            return s.contains("'") ? StringType.DOUBLE : StringType.SINGLE;
        }
        if (type == StringType.MULTI) {
            return type;
        }
        if (type == StringType.SINGLE || type == StringType.DOUBLE) {
            return this.omitQuotes && this.canBeImplicit(s) ? StringType.IMPLICIT : type;
        }
        if (type == StringType.IMPLICIT) {
            return this.checkImplicitString(value, s);
        }
        if (type == StringType.NONE) {
            return this.selectStringType(s);
        }
        return type;
    }

    protected boolean canBeImplicit(String s) {
        return !s.isEmpty() && this.isValidFirstChar(s.charAt(0)) && !s.contains("\n");
    }

    protected StringType checkImplicitString(JsonValue value, String s) {
        if (s.contains("\n")) {
            return StringType.MULTI;
        }
        if (value.hasComment(CommentType.EOL)) {
            return s.contains("'") ? StringType.DOUBLE : StringType.SINGLE;
        }
        return StringType.IMPLICIT;
    }

    protected StringType selectStringType(String s) {
        if (s.isEmpty()) {
            return StringType.SINGLE;
        }
        if (s.contains("\n")) {
            return StringType.MULTI;
        }
        return StringType.IMPLICIT;
    }

    protected boolean isValidFirstChar(char c) {
        return c != '{' && c != '}' && c != '[' && c != ']' && c != ',' && c != ':';
    }

    @Override
    protected boolean isCondensed(JsonContainer c) {
        if (!this.format) {
            return true;
        }
        if (c == null || !this.allowCondense) {
            return false;
        }
        if (this.level < 1) {
            return this.isOpenRootCondensed(c);
        }
        for (JsonReference reference : c.references()) {
            if (reference.getOnly().getLinesAbove() != 0) continue;
            return true;
        }
        return false;
    }

    protected boolean isOpenRootCondensed(JsonContainer c) {
        if (c.size() < 2) {
            return false;
        }
        for (int i = 1; i < c.size(); ++i) {
            if (c.getReference(i).getOnly().getLinesAbove() != 0) continue;
            return true;
        }
        return false;
    }
}

