/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Objects;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.Nullable;
import net.frozenblock.lib.shadow.xjs.data.JsonArray;
import net.frozenblock.lib.shadow.xjs.data.JsonContainer;
import net.frozenblock.lib.shadow.xjs.data.JsonFormat;
import net.frozenblock.lib.shadow.xjs.data.JsonObject;
import net.frozenblock.lib.shadow.xjs.data.JsonType;
import net.frozenblock.lib.shadow.xjs.data.comments.CommentHolder;
import net.frozenblock.lib.shadow.xjs.data.comments.CommentStyle;
import net.frozenblock.lib.shadow.xjs.data.comments.CommentType;
import net.frozenblock.lib.shadow.xjs.data.serialization.JsonContext;
import net.frozenblock.lib.shadow.xjs.data.serialization.writer.DjsWriter;
import net.frozenblock.lib.shadow.xjs.data.serialization.writer.JsonWriter;
import net.frozenblock.lib.shadow.xjs.data.serialization.writer.JsonWriterOptions;

public abstract class JsonValue
implements Serializable {
    protected int linesAbove = -1;
    protected int linesBetween = -1;
    @Nullable
    protected CommentHolder comments = null;

    protected JsonValue() {
    }

    public int getLinesAbove() {
        return this.linesAbove;
    }

    public JsonValue setLinesAbove(int linesAbove) {
        this.linesAbove = linesAbove;
        return this;
    }

    public int getLinesBetween() {
        return this.linesBetween;
    }

    public JsonValue setLinesBetween(int linesBetween) {
        this.linesBetween = linesBetween;
        return this;
    }

    public CommentHolder getComments() {
        if (this.comments == null) {
            this.comments = new CommentHolder();
            return this.comments;
        }
        return this.comments;
    }

    public JsonValue setComments(@Nullable CommentHolder comments) {
        this.comments = comments;
        return this;
    }

    public boolean hasComments() {
        return this.comments != null && this.comments.hasAny();
    }

    public boolean hasComment(CommentType type) {
        return this.comments != null && this.comments.has(type);
    }

    public JsonValue setComment(String text) {
        return this.setComment(CommentType.HEADER, JsonContext.getDefaultCommentStyle(), text);
    }

    public JsonValue setComment(CommentType type, String text) {
        return this.setComment(type, JsonContext.getDefaultCommentStyle(), text);
    }

    public JsonValue setComment(CommentType type, CommentStyle style, String text) {
        this.getComments().set(type, style, text);
        return this;
    }

    public JsonValue setComment(CommentType type, CommentStyle style, String text, int lines) {
        this.getComments().set(type, style, text, lines);
        return this;
    }

    public JsonValue prependComment(String text) {
        this.getComments().prepend(CommentType.HEADER, JsonContext.getDefaultCommentStyle(), text);
        return this;
    }

    public JsonValue prependComment(CommentType type, String text) {
        this.getComments().prepend(type, JsonContext.getDefaultCommentStyle(), text);
        return this;
    }

    public JsonValue appendComment(String text) {
        this.getComments().append(CommentType.HEADER, JsonContext.getDefaultCommentStyle(), text);
        return this;
    }

    public JsonValue appendComment(CommentType type, String text) {
        this.getComments().append(type, JsonContext.getDefaultCommentStyle(), text);
        return this;
    }

    public String getComment(CommentType type) {
        return this.getComments().get(type);
    }

    public JsonValue setDefaultMetadata(JsonValue metadata) {
        if (this.linesAbove < 0) {
            this.linesAbove = metadata.linesAbove;
        }
        if (this.linesBetween < 0) {
            this.linesBetween = metadata.linesBetween;
        }
        if (this.comments == null) {
            if (metadata.comments != null) {
                this.comments = metadata.comments.copy();
            }
        } else if (metadata.comments != null) {
            this.comments.appendAll(metadata.comments);
        }
        return this;
    }

    public abstract JsonType getType();

    public abstract Object unwrap();

    public boolean isPrimitive() {
        return true;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isTrue() {
        return false;
    }

    public boolean isFalse() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isContainer() {
        return false;
    }

    public boolean isObject() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isNull() {
        return false;
    }

    public long asLong() {
        throw new UnsupportedOperationException("Not a long: " + this);
    }

    public int asInt() {
        throw new UnsupportedOperationException("Not an int: " + this);
    }

    public double asDouble() {
        throw new UnsupportedOperationException("Not a double: " + this);
    }

    public float asFloat() {
        throw new UnsupportedOperationException("Not a float: " + this);
    }

    public boolean asBoolean() {
        throw new UnsupportedOperationException("Not a boolean: " + this);
    }

    public String asString() {
        throw new UnsupportedOperationException("Not a string: " + this);
    }

    public JsonContainer asContainer() {
        throw new UnsupportedOperationException("Not a container: " + this);
    }

    public JsonObject asObject() {
        throw new UnsupportedOperationException("Not an object: " + this);
    }

    public JsonArray asArray() {
        throw new UnsupportedOperationException("Not an array: " + this);
    }

    public long intoLong() {
        return (long)this.intoDouble();
    }

    public int intoInt() {
        return (int)this.intoDouble();
    }

    public abstract double intoDouble();

    public float intoFloat() {
        return (float)this.intoDouble();
    }

    public boolean intoBoolean() {
        return this.intoDouble() != 0.0;
    }

    public String intoString() {
        return this.toString();
    }

    public JsonContainer intoContainer() {
        return this.intoArray();
    }

    public JsonObject intoObject() {
        return new JsonObject().add("value", this);
    }

    public JsonArray intoArray() {
        return new JsonArray().add(this);
    }

    public JsonValue shallowCopy() {
        return this.copy(26);
    }

    public JsonValue deepCopy() {
        return this.copy(28);
    }

    public JsonValue deepCopy(boolean tracking) {
        return this.copy(tracking ? 29 : 28);
    }

    public JsonValue unformatted() {
        return this.copy(4);
    }

    public JsonValue trim() {
        return this.setLinesAbove(-1).setLinesBetween(-1);
    }

    public abstract JsonValue copy(int var1);

    protected static <V extends JsonValue> V withMetadata(V copy, V source, int options) {
        if ((options & 0x10) == 16 && source.comments != null) {
            copy.comments = source.comments.copy();
        }
        if ((options & 8) == 8) {
            copy.linesAbove = source.linesAbove;
            copy.linesBetween = source.linesBetween;
        }
        return copy;
    }

    public int valueHashCode() {
        return this.unwrap().hashCode();
    }

    public int metaHashCode() {
        int result = 1;
        result = 31 * result + this.linesAbove;
        result = 31 * result + this.linesBetween;
        if (this.comments != null) {
            result = 31 * result + this.comments.hashCode();
        }
        return result;
    }

    public int hashCode() {
        return 31 * this.metaHashCode() + this.valueHashCode();
    }

    public boolean matches(JsonValue other) {
        return Objects.equals(this.unwrap(), other.unwrap());
    }

    protected boolean matchesMetadata(JsonValue other) {
        return this.linesAbove == other.linesAbove && this.linesBetween == other.linesBetween && Objects.equals(this.comments, other.comments);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.getClass().equals(o.getClass())) {
            JsonValue other = (JsonValue)o;
            return this.matches(other) && this.matchesMetadata(other);
        }
        return false;
    }

    public void write(File file) throws IOException {
        JsonContext.autoWrite(file, this);
    }

    public void write(Writer writer) throws IOException {
        new DjsWriter(writer, JsonContext.getDefaultFormatting()).write(this);
    }

    public String toString() {
        if (this.isPrimitive()) {
            return this.unwrap().toString();
        }
        return this.toString(JsonFormat.JSON);
    }

    public String toString(JsonFormat format) {
        StringWriter sw = new StringWriter();
        try {
            switch (format) {
                case JSON: {
                    new JsonWriter((Writer)sw, false).write(this);
                    break;
                }
                case JSON_FORMATTED: {
                    new JsonWriter((Writer)sw, true).write(this);
                    break;
                }
                case DJS: {
                    new DjsWriter((Writer)sw, false).write(this);
                    break;
                }
                case DJS_FORMATTED: {
                    new DjsWriter((Writer)sw, true).write(this);
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Encoding error", e);
        }
        return sw.toString();
    }

    public String toString(JsonWriterOptions options) {
        StringWriter sw = new StringWriter();
        try {
            new DjsWriter((Writer)sw, options).write(this);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Encoding error", e);
        }
        return sw.toString();
    }
}

