/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data.comments;

import java.util.HashMap;
import java.util.Map;
import net.frozenblock.lib.shadow.xjs.data.comments.Comment;
import net.frozenblock.lib.shadow.xjs.data.comments.CommentData;
import net.frozenblock.lib.shadow.xjs.data.comments.CommentStyle;
import net.frozenblock.lib.shadow.xjs.data.comments.CommentType;

public class CommentHolder {
    private static final CommentData EMPTY_COMMENT = CommentData.immutable();
    private final Map<CommentType, CommentData> map = new HashMap<CommentType, CommentData>();

    public boolean hasAny() {
        return !this.map.isEmpty();
    }

    public boolean has(CommentType type) {
        return this.map.containsKey((Object)type);
    }

    public String get(CommentType type) {
        return this.getData(type).toString();
    }

    public CommentData getData(CommentType type) {
        return this.map.getOrDefault((Object)type, EMPTY_COMMENT);
    }

    public CommentData getOrCreate(CommentType type) {
        return this.map.computeIfAbsent(type, t -> new CommentData());
    }

    public CommentHolder set(CommentType type, CommentStyle style, String text) {
        CommentData data = new CommentData();
        data.append(new Comment(style, text));
        return this.setData(type, data);
    }

    public CommentHolder set(CommentType type, CommentStyle style, String text, int lines) {
        CommentData data = new CommentData();
        data.append(new Comment(style, text));
        data.append(lines);
        return this.setData(type, data);
    }

    public CommentHolder append(CommentType type, CommentStyle style, String text) {
        CommentData data = this.getOrCreate(type);
        data.append(1);
        data.append(new Comment(style, text));
        return this;
    }

    public CommentHolder appendAll(CommentHolder comments) {
        comments.map.forEach((type, otherData) -> this.getOrCreate((CommentType)((Object)type)).append((CommentData)otherData));
        return this;
    }

    public CommentHolder prepend(CommentType type, CommentStyle style, String text) {
        CommentData data = this.getOrCreate(type);
        data.prepend(1);
        data.prepend(new Comment(style, text));
        return this;
    }

    public CommentHolder setData(CommentType type, CommentData data) {
        this.map.put(type, data);
        return this;
    }

    public CommentHolder setLinesAfter(CommentType type, int lines) {
        this.map.computeIfAbsent(type, t -> new CommentData()).setLinesAfter(lines);
        return this;
    }

    public CommentHolder copy() {
        CommentHolder copy = new CommentHolder();
        this.map.forEach((type, data) -> copy.map.put((CommentType)((Object)type), data.copy()));
        return copy;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CommentHolder) {
            return this.map.equals(((CommentHolder)o).map);
        }
        return false;
    }
}

