/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data.serialization.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.NotNull;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.Nullable;
import net.frozenblock.lib.shadow.xjs.data.Json;
import net.frozenblock.lib.shadow.xjs.data.JsonArray;
import net.frozenblock.lib.shadow.xjs.data.JsonLiteral;
import net.frozenblock.lib.shadow.xjs.data.JsonNumber;
import net.frozenblock.lib.shadow.xjs.data.JsonObject;
import net.frozenblock.lib.shadow.xjs.data.JsonString;
import net.frozenblock.lib.shadow.xjs.data.JsonValue;
import net.frozenblock.lib.shadow.xjs.data.comments.CommentType;
import net.frozenblock.lib.shadow.xjs.data.exception.SyntaxException;
import net.frozenblock.lib.shadow.xjs.data.serialization.parser.CommentedTokenParser;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.DjsTokenizer;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.NumberToken;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.StringToken;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.SymbolToken;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.Token;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.TokenStream;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.TokenType;
import net.frozenblock.lib.shadow.xjs.data.serialization.util.PositionTrackingReader;

public class DjsParser
extends CommentedTokenParser {
    public DjsParser(File file) throws IOException {
        this(DjsTokenizer.stream(new FileInputStream(file)));
    }

    public DjsParser(String text) {
        this(DjsTokenizer.stream(text));
    }

    public DjsParser(PositionTrackingReader reader) throws IOException {
        this(DjsTokenizer.stream(reader));
    }

    public DjsParser(TokenStream root) {
        super(root);
    }

    @Override
    @NotNull
    public JsonValue parse() {
        if (this.root.type() == TokenType.OPEN) {
            this.read();
        }
        this.readWhitespace();
        if (this.isEndOfContainer() || this.isOpenRoot()) {
            return this.readOpenRoot();
        }
        return this.readClosedRoot();
    }

    protected boolean isOpenRoot() {
        TokenType type = (TokenType)((Object)this.current.type());
        if (type == TokenType.SYMBOL) {
            return false;
        }
        Token peek = this.peekWhitespace();
        if (peek == null) {
            return false;
        }
        return peek.isSymbol(':');
    }

    @Nullable
    protected Token peekWhitespace() {
        Token peek = this.iterator.peek();
        int peekAmount = 1;
        block3: while (peek != null) {
            switch ((TokenType)((Object)peek.type())) {
                case BREAK: 
                case COMMENT: {
                    peek = this.iterator.peek(++peekAmount);
                    continue block3;
                }
            }
            return peek;
        }
        return null;
    }

    protected JsonObject readOpenRoot() {
        JsonValue top;
        JsonObject object = new JsonObject();
        this.readAboveOpenRoot(object);
        while (true) {
            this.readWhitespace(false);
            if (this.isEndOfContainer()) break;
            this.readNextMember(object);
        }
        if (!object.isEmpty() && (top = object.get(0)).getLinesAbove() == 0) {
            top.setLinesAbove(-1);
        }
        this.readBottom();
        return this.takeFormatting(object);
    }

    protected JsonValue readClosedRoot() {
        this.readAbove();
        JsonValue result = this.readValue();
        this.readAfter();
        this.readBottom();
        return this.takeFormatting(result);
    }

    protected JsonValue readValue() {
        if (this.current.isSymbol('{')) {
            return this.readObject();
        }
        if (this.current.isSymbol('[')) {
            return this.readArray();
        }
        JsonValue value = this.readSingle();
        this.read();
        return value;
    }

    protected JsonObject readObject() {
        JsonObject object = new JsonObject();
        if (!this.open('{', '}')) {
            return this.close(object, '}');
        }
        do {
            this.readWhitespace(false);
            if (!this.isEndOfContainer('}')) continue;
            return this.close(object, '}');
        } while (this.readNextMember(object));
        return this.close(object, '}');
    }

    protected boolean readNextMember(JsonObject object) {
        this.setAbove();
        String key = this.readKey();
        this.readBetween(':');
        JsonValue value = this.readValue();
        object.add(key, value);
        boolean delimiter = this.readDelimiter();
        this.takeFormatting(value);
        return delimiter;
    }

    protected String readKey() {
        Token t = this.current;
        TokenType type = (TokenType)((Object)t.type());
        if (this.isLegalKeyType(type)) {
            Token peek = this.peekWhitespace();
            if (peek != null && this.isLegalKeyType((TokenType)((Object)peek.type()))) {
                throw this.whitespaceInKey();
            }
            this.read();
            return t.parsed();
        }
        if (t.isSymbol(':')) {
            throw this.emptyKey();
        }
        if (t.hasText()) {
            throw this.illegalToken(t.parsed());
        }
        if (t instanceof SymbolToken) {
            SymbolToken s = (SymbolToken)t;
            throw this.punctuationInKey(s.symbol);
        }
        throw this.illegalToken(type.name());
    }

    protected JsonArray readArray() {
        JsonArray array = new JsonArray();
        if (!this.open('[', ']')) {
            return this.close(array, ']');
        }
        do {
            this.readWhitespace(false);
            if (!this.isEndOfContainer(']')) continue;
            return this.close(array, ']');
        } while (this.readNextElement(array));
        return this.close(array, ']');
    }

    protected boolean readNextElement(JsonArray array) {
        this.setAbove();
        JsonValue value = this.readValue();
        array.add(value);
        boolean delimiter = this.readDelimiter();
        this.takeFormatting(value);
        return delimiter;
    }

    protected boolean readDelimiter() {
        this.readLineWhitespace();
        if (this.readIf(',')) {
            this.readLineWhitespace();
            this.readNl();
            this.setComment(CommentType.EOL);
            return true;
        }
        if (this.readNl()) {
            this.setComment(CommentType.EOL);
            this.readWhitespace(false);
            this.readIf(',');
            return true;
        }
        if (this.isEndOfText()) {
            this.setComment(CommentType.EOL);
        }
        return false;
    }

    protected JsonValue readSingle() {
        String text;
        Token t = this.current;
        if (t instanceof NumberToken) {
            NumberToken n = (NumberToken)t;
            return Json.value(n.number);
        }
        if (t instanceof StringToken) {
            StringToken s = (StringToken)t;
            return new JsonString(s.parsed(), s.stringType());
        }
        if (!t.hasText()) {
            if (t.isSymbol(',')) {
                throw this.leadingDelimiter();
            }
            if (t instanceof SymbolToken) {
                SymbolToken s = (SymbolToken)t;
                throw this.punctuationInValue(s.symbol);
            }
            if (this.isEndOfContainer()) {
                throw this.endOfContainer();
            }
            throw this.unexpected(((TokenType)((Object)t.type())).name());
        }
        return switch (text = t.parsed()) {
            case "infinity", "Infinity" -> new JsonNumber(Double.POSITIVE_INFINITY);
            case "-infinity", "-Infinity" -> new JsonNumber(Double.NEGATIVE_INFINITY);
            case "true" -> JsonLiteral.jsonTrue();
            case "false" -> JsonLiteral.jsonFalse();
            case "null" -> JsonLiteral.jsonNull();
            case "" -> throw this.expected("tokens");
            default -> throw this.illegalToken(text);
        };
    }

    protected boolean isLegalKeyType(TokenType type) {
        return type == TokenType.STRING || type == TokenType.WORD || type == TokenType.NUMBER;
    }

    protected SyntaxException emptyKey() {
        return this.expected("key (for an empty key name use quotes)");
    }

    protected SyntaxException whitespaceInKey() {
        return this.unexpected("whitespace in key (use quotes to include)");
    }

    protected SyntaxException punctuationInKey(char c) {
        return this.unexpected("punctuation ('" + c + "') in key (use quotes to include)");
    }

    protected SyntaxException leadingDelimiter() {
        return this.unexpected("leading delimiter (use quotes to include): ','");
    }

    protected SyntaxException punctuationInValue(char c) {
        return this.unexpected("punctuation ('" + c + "') in value (use quotes to include)");
    }

    protected SyntaxException endOfContainer() {
        return this.unexpected("end of container when expecting a value (use empty double quotes for empty string)");
    }

    @Override
    public void close() throws IOException {
        this.root.close();
    }
}

