/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.qsl.frozenblock.core.registry.impl.sync.client;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.ApiStatus;
import net.minecraft.class_124;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.class_7417;
import org.quiltmc.qsl.frozenblock.core.registry.api.sync.ModProtocol;
import org.quiltmc.qsl.frozenblock.core.registry.api.sync.ModProtocolDef;
import org.quiltmc.qsl.frozenblock.core.registry.impl.sync.ClientPackets;
import org.quiltmc.qsl.frozenblock.core.registry.impl.sync.ProtocolVersions;
import org.quiltmc.qsl.frozenblock.core.registry.impl.sync.RegistrySyncText;
import org.quiltmc.qsl.frozenblock.core.registry.impl.sync.ServerPackets;
import org.quiltmc.qsl.frozenblock.core.registry.impl.sync.client.LogBuilder;
import org.quiltmc.qsl.frozenblock.core.registry.impl.sync.server.ServerRegistrySync;
import org.slf4j.Logger;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public final class ClientRegistrySync {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static int syncVersion = -1;
    private static int currentCount;
    private static byte currentFlags;
    private static class_2561 errorStyleHeader;
    private static class_2561 errorStyleFooter;
    private static boolean showErrorDetails;
    private static class_2561 disconnectMainReason;
    private static LogBuilder builder;
    private static boolean mustDisconnect;

    public static void registerHandlers() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ServerPackets.Handshake.PACKET_TYPE.getId(), ClientRegistrySync::handleHelloPacket);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ServerPackets.End.PACKET_TYPE.getId(), ClientRegistrySync::handleEndPacket);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ServerPackets.ErrorStyle.PACKET_TYPE.getId(), ClientRegistrySync::handleErrorStylePacket);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ServerPackets.ModProtocol.PACKET_TYPE.getId(), ClientRegistrySync::handleModProtocol);
    }

    private static void handleModProtocol(class_310 client, class_634 handler, class_2540 buf, PacketSender sender) {
        ServerPackets.ModProtocol modProtocol = new ServerPackets.ModProtocol(buf);
        String prioritizedId = modProtocol.prioritizedId();
        Collection<ModProtocolDef> protocols = modProtocol.protocols();
        Object2IntOpenHashMap values = new Object2IntOpenHashMap(protocols.size());
        ArrayList<ModProtocolDef> unsupportedList = new ArrayList<ModProtocolDef>();
        ModProtocolDef missingPrioritized = null;
        boolean disconnect = false;
        for (ModProtocolDef protocol : protocols) {
            IntList local = ModProtocol.getVersion(protocol.id());
            int latest = protocol.latestMatchingVersion((IntCollection)local);
            LOGGER.info(String.valueOf(latest));
            if (latest != -1) {
                values.put((Object)protocol.id(), latest);
                continue;
            }
            if (protocol.optional()) continue;
            unsupportedList.add(protocol);
            disconnect = true;
            if (!prioritizedId.equals(protocol.id())) continue;
            missingPrioritized = protocol;
        }
        if (disconnect) {
            ClientRegistrySync.markDisconnected(RegistrySyncText.unsupportedModVersion(unsupportedList, missingPrioritized));
            builder.pushT("unsupported_protocol", "Unsupported Mod Protocol", new Object[0]);
            for (ModProtocolDef entry : unsupportedList) {
                builder.textEntry((class_2561)class_2561.method_43470((String)entry.displayName()).method_10852((class_2561)class_2561.method_43470((String)(" (" + entry.id() + ")")).method_27692(class_124.field_1063)).method_27693(" | Server: ").method_27693(ClientRegistrySync.stringifyVersions(entry.versions())).method_27693(", Client: ").method_27693(ClientRegistrySync.stringifyVersions(ModProtocol.getVersion(entry.id()))));
            }
        } else {
            ClientRegistrySync.sendSupportedModProtocol(sender, (Object2IntOpenHashMap<String>)values);
        }
    }

    private static void handleEndPacket(class_310 client, class_634 handler, class_2540 buf, PacketSender sender) {
        syncVersion = -1;
        if (mustDisconnect) {
            class_5250 entry = class_2561.method_43473();
            entry.method_10852(errorStyleHeader);
            if (disconnectMainReason != null && showErrorDetails && !ClientRegistrySync.isTextEmpty(disconnectMainReason)) {
                entry.method_27693("\n");
                entry.method_10852(disconnectMainReason);
            }
            if (!ClientRegistrySync.isTextEmpty(errorStyleFooter)) {
                entry.method_27693("\n");
                entry.method_10852(errorStyleFooter);
            }
            handler.method_48296().method_10747((class_2561)entry);
            LOGGER.warn(builder.asString());
        } else {
            sender.sendPacket((FabricPacket)new ClientPackets.End());
        }
    }

    private static String stringifyVersions(IntList versions) {
        if (versions == null || versions.isEmpty()) {
            return "Missing!";
        }
        StringBuilder b = new StringBuilder().append('[');
        IntListIterator iter = versions.iterator();
        while (iter.hasNext()) {
            b.append(iter.nextInt());
            if (!iter.hasNext()) continue;
            b.append(", ");
        }
        return b.append(']').toString();
    }

    private static void sendSupportedModProtocol(PacketSender sender, Object2IntOpenHashMap<String> values) {
        sender.sendPacket((FabricPacket)new ClientPackets.ModProtocol(values));
    }

    private static void handleErrorStylePacket(class_310 client, class_634 handler, class_2540 buf, PacketSender sender) {
        ServerPackets.ErrorStyle errorStyle = new ServerPackets.ErrorStyle(buf);
        errorStyleHeader = errorStyle.errorHeader();
        errorStyleFooter = errorStyle.errorFooter();
        showErrorDetails = errorStyle.showError();
    }

    private static void handleHelloPacket(class_310 client, class_634 handler, class_2540 buf, PacketSender sender) {
        syncVersion = ProtocolVersions.getHighestSupportedLocal(new ServerPackets.Handshake(buf).supportedVersions());
        sender.sendPacket((FabricPacket)new ClientPackets.Handshake(syncVersion));
        builder.clear();
    }

    private static void markDisconnected(class_2561 reason) {
        if (disconnectMainReason == null) {
            disconnectMainReason = reason;
        }
        mustDisconnect = true;
    }

    private static boolean isTextEmpty(class_2561 text) {
        class_2585 literalContents;
        class_7417 class_74172;
        return (text.method_10851() == class_7417.field_39004 || (class_74172 = text.method_10851()) instanceof class_2585 && (literalContents = (class_2585)class_74172).comp_737().isEmpty()) && text.method_10855().isEmpty();
    }

    public static void disconnectCleanup(class_310 client) {
        errorStyleHeader = ServerRegistrySync.errorStyleHeader;
        errorStyleFooter = ServerRegistrySync.errorStyleFooter;
        showErrorDetails = ServerRegistrySync.showErrorDetails;
        disconnectMainReason = null;
    }

    static {
        errorStyleHeader = ServerRegistrySync.errorStyleHeader;
        errorStyleFooter = ServerRegistrySync.errorStyleFooter;
        showErrorDetails = ServerRegistrySync.showErrorDetails;
        disconnectMainReason = null;
        builder = new LogBuilder();
    }
}

