/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.displayLink.source;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.redstone.displayLink.DisplayBehaviour;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.target.DisplayBoardTarget;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTarget;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.simibubi.create.content.trains.display.FlapDisplayBlockEntity;
import com.simibubi.create.content.trains.display.FlapDisplayLayout;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.NBTProcessors;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public abstract class DisplaySource
extends DisplayBehaviour {
    public static final List<class_5250> EMPTY = ImmutableList.of((Object)Components.empty());
    public static final class_5250 EMPTY_LINE = Components.empty();
    public static final class_5250 WHITESPACE = Components.literal(" ");

    public abstract List<class_5250> provideText(DisplayLinkContext var1, DisplayTargetStats var2);

    public void transferData(DisplayLinkContext context, DisplayTarget activeTarget, int line) {
        List<class_5250> text;
        DisplayTargetStats stats = activeTarget.provideStats(context);
        if (activeTarget instanceof DisplayBoardTarget) {
            DisplayBoardTarget fddt = (DisplayBoardTarget)activeTarget;
            List<List<class_5250>> flapDisplayText = this.provideFlapDisplayText(context, stats);
            fddt.acceptFlapText(line, flapDisplayText, context);
        }
        if ((text = this.provideText(context, stats)).isEmpty()) {
            text = EMPTY;
        }
        if (activeTarget.requiresComponentSanitization()) {
            for (class_5250 component : text) {
                if (!NBTProcessors.textComponentHasClickEvent((class_2561)component)) continue;
                return;
            }
        }
        activeTarget.acceptText(line, text, context);
    }

    public void onSignalReset(DisplayLinkContext context) {
    }

    public void populateData(DisplayLinkContext context) {
    }

    public int getPassiveRefreshTicks() {
        return 100;
    }

    public boolean shouldPassiveReset() {
        return true;
    }

    protected String getTranslationKey() {
        return this.id.method_12832();
    }

    public class_2561 getName() {
        return Components.translatable(this.id.method_12836() + ".display_source." + this.getTranslationKey());
    }

    public void loadFlapDisplayLayout(DisplayLinkContext context, FlapDisplayBlockEntity flapDisplay, FlapDisplayLayout layout, int lineIndex) {
        this.loadFlapDisplayLayout(context, flapDisplay, layout);
    }

    public void loadFlapDisplayLayout(DisplayLinkContext context, FlapDisplayBlockEntity flapDisplay, FlapDisplayLayout layout) {
        if (!layout.isLayout("Default")) {
            layout.loadDefault(flapDisplay.getMaxCharCount());
        }
    }

    public List<List<class_5250>> provideFlapDisplayText(DisplayLinkContext context, DisplayTargetStats stats) {
        return this.provideText(context, stats).stream().map(xva$0 -> Arrays.asList(xva$0)).toList();
    }

    @Environment(value=EnvType.CLIENT)
    public void initConfigurationWidgets(DisplayLinkContext context, ModularGuiLineBuilder builder, boolean isFirstLine) {
    }
}

