/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class RaycastHelper {
    public static class_3965 rayTraceRange(class_1937 worldIn, class_1657 playerIn, double range) {
        class_243 origin = RaycastHelper.getTraceOrigin(playerIn);
        class_243 target = RaycastHelper.getTraceTarget(playerIn, range, origin);
        class_3959 context = new class_3959(origin, target, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)playerIn);
        return worldIn.method_17742(context);
    }

    public static PredicateTraceResult rayTraceUntil(class_1657 playerIn, double range, Predicate<class_2338> predicate) {
        class_243 origin = RaycastHelper.getTraceOrigin(playerIn);
        class_243 target = RaycastHelper.getTraceTarget(playerIn, range, origin);
        return RaycastHelper.rayTraceUntil(origin, target, predicate);
    }

    public static class_243 getTraceTarget(class_1657 playerIn, double range, class_243 origin) {
        float f = playerIn.method_36455();
        float f1 = playerIn.method_36454();
        float f2 = class_3532.method_15362((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = class_3532.method_15374((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -class_3532.method_15362((float)(-f * ((float)Math.PI / 180)));
        float f5 = class_3532.method_15374((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d3 = range;
        class_243 Vector3d1 = origin.method_1031((double)f6 * d3, (double)f5 * d3, (double)f7 * d3);
        return Vector3d1;
    }

    public static class_243 getTraceOrigin(class_1657 playerIn) {
        double d0 = playerIn.method_23317();
        double d1 = playerIn.method_23318() + (double)playerIn.method_5751();
        double d2 = playerIn.method_23321();
        class_243 Vector3d2 = new class_243(d0, d1, d2);
        return Vector3d2;
    }

    public static PredicateTraceResult rayTraceUntil(class_243 start, class_243 end, Predicate<class_2338> predicate) {
        int z;
        int y;
        if (Double.isNaN(start.field_1352) || Double.isNaN(start.field_1351) || Double.isNaN(start.field_1350)) {
            return null;
        }
        if (Double.isNaN(end.field_1352) || Double.isNaN(end.field_1351) || Double.isNaN(end.field_1350)) {
            return null;
        }
        int dx = class_3532.method_15357((double)end.field_1352);
        int dy = class_3532.method_15357((double)end.field_1351);
        int dz = class_3532.method_15357((double)end.field_1350);
        int x = class_3532.method_15357((double)start.field_1352);
        class_2338.class_2339 currentPos = new class_2338(x, y = class_3532.method_15357((double)start.field_1351), z = class_3532.method_15357((double)start.field_1350)).method_25503();
        if (predicate.test((class_2338)currentPos)) {
            return new PredicateTraceResult(currentPos.method_10062(), class_2350.method_10147((float)(dx - x), (float)(dy - y), (float)(dz - z)));
        }
        int remainingDistance = 200;
        while (remainingDistance-- >= 0) {
            class_2350 enumfacing;
            if (Double.isNaN(start.field_1352) || Double.isNaN(start.field_1351) || Double.isNaN(start.field_1350)) {
                return null;
            }
            if (x == dx && y == dy && z == dz) {
                return new PredicateTraceResult();
            }
            boolean flag2 = true;
            boolean flag = true;
            boolean flag1 = true;
            double d0 = 999.0;
            double d1 = 999.0;
            double d2 = 999.0;
            if (dx > x) {
                d0 = (double)x + 1.0;
            } else if (dx < x) {
                d0 = (double)x + 0.0;
            } else {
                flag2 = false;
            }
            if (dy > y) {
                d1 = (double)y + 1.0;
            } else if (dy < y) {
                d1 = (double)y + 0.0;
            } else {
                flag = false;
            }
            if (dz > z) {
                d2 = (double)z + 1.0;
            } else if (dz < z) {
                d2 = (double)z + 0.0;
            } else {
                flag1 = false;
            }
            double d3 = 999.0;
            double d4 = 999.0;
            double d5 = 999.0;
            double d6 = end.field_1352 - start.field_1352;
            double d7 = end.field_1351 - start.field_1351;
            double d8 = end.field_1350 - start.field_1350;
            if (flag2) {
                d3 = (d0 - start.field_1352) / d6;
            }
            if (flag) {
                d4 = (d1 - start.field_1351) / d7;
            }
            if (flag1) {
                d5 = (d2 - start.field_1350) / d8;
            }
            if (d3 == -0.0) {
                d3 = -1.0E-4;
            }
            if (d4 == -0.0) {
                d4 = -1.0E-4;
            }
            if (d5 == -0.0) {
                d5 = -1.0E-4;
            }
            if (d3 < d4 && d3 < d5) {
                enumfacing = dx > x ? class_2350.field_11039 : class_2350.field_11034;
                start = new class_243(d0, start.field_1351 + d7 * d3, start.field_1350 + d8 * d3);
            } else if (d4 < d5) {
                enumfacing = dy > y ? class_2350.field_11033 : class_2350.field_11036;
                start = new class_243(start.field_1352 + d6 * d4, d1, start.field_1350 + d8 * d4);
            } else {
                enumfacing = dz > z ? class_2350.field_11043 : class_2350.field_11035;
                start = new class_243(start.field_1352 + d6 * d5, start.field_1351 + d7 * d5, d2);
            }
            x = class_3532.method_15357((double)start.field_1352) - (enumfacing == class_2350.field_11034 ? 1 : 0);
            y = class_3532.method_15357((double)start.field_1351) - (enumfacing == class_2350.field_11036 ? 1 : 0);
            z = class_3532.method_15357((double)start.field_1350) - (enumfacing == class_2350.field_11035 ? 1 : 0);
            currentPos.method_10103(x, y, z);
            if (!predicate.test((class_2338)currentPos)) continue;
            return new PredicateTraceResult(currentPos.method_10062(), enumfacing);
        }
        return new PredicateTraceResult();
    }

    public static class PredicateTraceResult {
        private class_2338 pos;
        private class_2350 facing;

        public PredicateTraceResult(class_2338 pos, class_2350 facing) {
            this.pos = pos;
            this.facing = facing;
        }

        public PredicateTraceResult() {
        }

        public class_2350 getFacing() {
            return this.facing;
        }

        public class_2338 getPos() {
            return this.pos;
        }

        public boolean missed() {
            return this.pos == null;
        }
    }
}

