/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.ponder.scenes.fluid;

import com.simibubi.create.content.fluids.hosePulley.HosePulleyBlockEntity;
import com.simibubi.create.content.fluids.pump.PumpBlock;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.element.WorldSectionElement;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import java.util.Collections;
import java.util.LinkedList;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class HosePulleyScenes {
    public static void intro(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("hose_pulley", "Source Filling and Draining using Hose Pulleys");
        scene.configureBasePlate(0, 0, 3);
        scene.setSceneOffsetY(-1.0f);
        scene.scaleSceneView(0.9f);
        scene.showBasePlate();
        scene.idle(5);
        Selection cogs = util.select.fromTo(3, 1, 2, 3, 2, 2);
        Selection pipes = util.select.fromTo(3, 1, 1, 3, 5, 1).add(util.select.position(2, 5, 1));
        class_2338 hosePos = util.grid.at(1, 5, 1);
        Selection hose = util.select.position(1, 5, 1);
        Selection crank = util.select.position(0, 5, 1);
        ElementLink<WorldSectionElement> hoselink = scene.world.showIndependentSection(hose, class_2350.field_11036);
        scene.world.moveSection(hoselink, util.vector.of(0.0, -1.0, 0.0), 0);
        scene.idle(10);
        class_243 shaftInput = util.vector.blockSurface(hosePos.method_10074(), class_2350.field_11039);
        scene.overlay.showText(70).text("Hose Pulleys can be used to fill or drain large bodies of Fluid").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(hosePos.method_10074()));
        scene.idle(80);
        scene.overlay.showText(80).text("With the Kinetic Input, the height of the pulleys' hose can be controlled").attachKeyFrame().placeNearTarget().pointAt(shaftInput);
        scene.idle(40);
        scene.world.showSectionAndMerge(crank, class_2350.field_11034, hoselink);
        scene.idle(20);
        Selection kinetics = util.select.fromTo(1, 5, 1, 0, 5, 1);
        scene.world.setKineticSpeed(kinetics, 32.0f);
        scene.idle(50);
        scene.world.setKineticSpeed(kinetics, 0.0f);
        scene.overlay.showText(80).text("The Pulley retracts while the input rotation is inverted").attachKeyFrame().placeNearTarget().pointAt(util.vector.centerOf(hosePos.method_10087(3)));
        scene.idle(30);
        scene.world.setKineticSpeed(kinetics, -32.0f);
        scene.idle(16);
        scene.world.setKineticSpeed(kinetics, 0.0f);
        scene.idle(10);
        scene.rotateCameraY(70.0f);
        scene.idle(40);
        scene.overlay.showText(60).text("On the opposite side, pipes can be connected").attachKeyFrame().placeNearTarget().pointAt(util.vector.blockSurface(hosePos.method_10074(), class_2350.field_11034));
        scene.idle(70);
        scene.rotateCameraY(-70.0f);
        scene.idle(10);
        scene.world.showSectionAndMerge(cogs, class_2350.field_11043, hoselink);
        scene.world.showSectionAndMerge(pipes, class_2350.field_11039, hoselink);
        scene.world.showSection(util.select.fromTo(0, 1, 0, 2, 2, 2), class_2350.field_11036);
        scene.idle(10);
        scene.overlay.showText(70).text("Attached pipe networks can either provide fluid to the hose...").attachKeyFrame().pointAt(util.vector.centerOf(util.grid.at(3, 1, 1)));
        scene.idle(40);
        LinkedList<class_2338> blocks = new LinkedList<class_2338>();
        for (int y = 1; y < 3; ++y) {
            blocks.add(util.grid.at(1, y, 1));
            blocks.add(util.grid.at(0, y, 1));
            blocks.add(util.grid.at(1, y, 0));
            blocks.add(util.grid.at(2, y, 1));
            blocks.add(util.grid.at(1, y, 2));
            blocks.add(util.grid.at(0, y, 0));
            blocks.add(util.grid.at(2, y, 0));
            blocks.add(util.grid.at(2, y, 2));
            blocks.add(util.grid.at(0, y, 2));
        }
        for (class_2338 blockPos : blocks) {
            scene.world.setBlock(blockPos, class_2246.field_10382.method_9564(), false);
            scene.idle(3);
        }
        scene.world.modifyBlockEntity(util.grid.at(1, 5, 1), HosePulleyBlockEntity.class, be -> TransferUtil.insert(be.getFluidStorage(null), (Object)FluidVariant.of((class_3611)class_3612.field_15910), (long)810000L));
        scene.idle(20);
        scene.world.modifyBlock(util.grid.at(3, 2, 1), s -> (class_2680)s.method_11657((class_2769)PumpBlock.FACING, (Comparable)class_2350.field_11033), true);
        scene.world.propagatePipeChange(util.grid.at(3, 2, 1));
        scene.idle(20);
        scene.world.setKineticSpeed(kinetics, 32.0f);
        scene.idle(16);
        scene.world.setKineticSpeed(kinetics, 0.0f);
        scene.idle(5);
        scene.overlay.showText(70).text("...or pull from it, draining the pool instead").attachKeyFrame().pointAt(util.vector.centerOf(util.grid.at(3, 1, 1)));
        scene.idle(40);
        Collections.reverse(blocks);
        for (class_2338 blockPos : blocks) {
            scene.world.destroyBlock(blockPos);
            scene.idle(3);
        }
        scene.idle(20);
        scene.overlay.showText(120).text("Fill and Drain speed of the pulley depends entirely on the fluid networks' throughput").placeNearTarget().colored(PonderPalette.MEDIUM).attachKeyFrame().pointAt(util.vector.centerOf(util.grid.at(3, 1, 1)));
        scene.idle(40);
        scene.markAsFinished();
    }

    public static void level(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("hose_pulley_level", "Fill and Drain level of Hose Pulleys");
        scene.configureBasePlate(0, 0, 3);
        scene.setSceneOffsetY(-1.5f);
        scene.scaleSceneView(0.9f);
        scene.showBasePlate();
        LinkedList<class_2338> blocks = new LinkedList<class_2338>();
        for (int y = 1; y < 4; ++y) {
            blocks.add(util.grid.at(1, y, 1));
            blocks.add(util.grid.at(0, y, 1));
            blocks.add(util.grid.at(1, y, 0));
            blocks.add(util.grid.at(2, y, 1));
            blocks.add(util.grid.at(1, y, 2));
            blocks.add(util.grid.at(0, y, 0));
            blocks.add(util.grid.at(2, y, 0));
            blocks.add(util.grid.at(2, y, 2));
            blocks.add(util.grid.at(0, y, 2));
        }
        for (class_2338 blockPos : blocks) {
            scene.world.setBlock(blockPos, class_2246.field_10382.method_9564(), false);
        }
        scene.idle(5);
        Selection water = util.select.fromTo(2, 1, 0, 0, 4, 2);
        scene.world.showSection(water, class_2350.field_11036);
        scene.idle(10);
        Selection cogs = util.select.fromTo(3, 1, 2, 3, 2, 2);
        Selection pipes = util.select.fromTo(3, 1, 1, 3, 6, 1).add(util.select.position(2, 6, 1));
        class_2338 hosePos = util.grid.at(1, 6, 1);
        Selection hose = util.select.position(1, 6, 1);
        Selection crank = util.select.position(0, 6, 1);
        ElementLink<WorldSectionElement> hoselink = scene.world.showIndependentSection(hose, class_2350.field_11033);
        scene.world.moveSection(hoselink, util.vector.of(0.0, -1.0, 0.0), 0);
        scene.idle(10);
        scene.world.showSectionAndMerge(crank, class_2350.field_11034, hoselink);
        scene.idle(20);
        scene.overlay.showSelectionWithText(util.select.position(hosePos.method_10074()), 50).text("While fully retracted, the Hose Pulley cannot operate").placeNearTarget().colored(PonderPalette.RED).attachKeyFrame().pointAt(util.vector.blockSurface(hosePos.method_10074(), class_2350.field_11036));
        scene.idle(55);
        scene.world.modifyBlock(util.grid.at(3, 2, 1), s -> (class_2680)s.method_11657((class_2769)PumpBlock.FACING, (Comparable)class_2350.field_11033), false);
        Selection kinetics = util.select.fromTo(1, 6, 1, 0, 6, 1);
        scene.world.setKineticSpeed(kinetics, 32.0f);
        scene.idle(50);
        scene.world.setKineticSpeed(kinetics, 0.0f);
        scene.overlay.showText(40).text("Draining runs from top to bottom").attachKeyFrame().placeNearTarget().pointAt(util.vector.centerOf(hosePos.method_10087(3)));
        scene.idle(10);
        scene.world.showSectionAndMerge(cogs, class_2350.field_11043, hoselink);
        scene.world.showSectionAndMerge(pipes, class_2350.field_11039, hoselink);
        scene.world.modifyBlockEntity(util.grid.at(1, 6, 1), HosePulleyBlockEntity.class, be -> TransferUtil.insert(be.getFluidStorage(null), (Object)FluidVariant.of((class_3611)class_3612.field_15910), (long)81000L));
        scene.world.propagatePipeChange(util.grid.at(3, 2, 1));
        class_243 surface = util.vector.topOf(1, 3, 1).method_1023(0.0, 0.25, 0.0);
        class_238 bb = new class_238(surface, surface).method_1009(1.5, 0.0, 1.5);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.MEDIUM, bb, bb, 3);
        scene.idle(3);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.MEDIUM, bb, bb.method_1012(0.0, -2.0, 0.0), 70);
        scene.idle(20);
        Collections.reverse(blocks);
        int i = 0;
        for (class_2338 blockPos : blocks) {
            if (i++ == 18) break;
            scene.world.destroyBlock(blockPos);
            scene.idle(3);
        }
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.WHITE, bb, bb.method_989(0.0, -2.0, 0.0), 60);
        scene.overlay.showText(60).text("The surface level will end up just below where the hose ends").attachKeyFrame().placeNearTarget().pointAt(util.vector.of(0.0, 1.875, 1.5));
        scene.idle(30);
        scene.idle(30);
        scene.world.hideSection(water, class_2350.field_11035);
        scene.idle(15);
        for (class_2338 blockPos : blocks) {
            scene.world.destroyBlock(blockPos);
        }
        scene.world.showSection(water, class_2350.field_11036);
        scene.idle(15);
        scene.world.setKineticSpeed(kinetics, -32.0f);
        scene.world.modifyBlock(util.grid.at(3, 2, 1), s -> (class_2680)s.method_11657((class_2769)PumpBlock.FACING, (Comparable)class_2350.field_11036), true);
        scene.world.propagatePipeChange(util.grid.at(3, 2, 1));
        scene.idle(16);
        scene.world.setKineticSpeed(kinetics, 0.0f);
        scene.overlay.showText(40).text("Filling runs from bottom to top").attachKeyFrame().placeNearTarget().pointAt(util.vector.centerOf(hosePos.method_10087(3)));
        scene.idle(10);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.MEDIUM, bb, bb.method_989(0.0, -2.75, 0.0), 3);
        scene.idle(3);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.MEDIUM, bb, bb.method_1012(0.0, -2.75, 0.0), 120);
        scene.idle(20);
        scene.world.setBlock(util.grid.at(1, 3, 1), class_2246.field_10382.method_9564(), false);
        scene.idle(3);
        scene.world.setBlock(util.grid.at(1, 2, 1), class_2246.field_10382.method_9564(), false);
        scene.idle(3);
        Collections.reverse(blocks);
        for (class_2338 blockPos : blocks) {
            scene.world.setBlock(blockPos, class_2246.field_10382.method_9564(), false);
            scene.idle(3);
        }
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.WHITE, bb, bb, 100);
        scene.overlay.showText(100).text("The filled pool will not grow beyond the layer above the hose end").attachKeyFrame().placeNearTarget().pointAt(util.vector.of(0.0, 3.875, 1.5));
        scene.idle(80);
    }

    public static void infinite(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("hose_pulley_infinite", "Passively Filling and Draining large bodies of Fluid");
        scene.configureBasePlate(0, 0, 5);
        scene.setSceneOffsetY(-0.5f);
        scene.scaleSceneView(0.9f);
        scene.showBasePlate();
        scene.idle(5);
        Selection tank = util.select.fromTo(4, 1, 1, 4, 3, 1);
        Selection pipes = util.select.fromTo(3, 1, 1, 2, 3, 2);
        Selection kinetics = util.select.fromTo(5, 1, 2, 4, 2, 2).add(util.select.position(5, 0, 2));
        Selection hose = util.select.fromTo(1, 3, 2, 0, 3, 2);
        class_2338 pumpPos = util.grid.at(3, 2, 2);
        scene.world.multiplyKineticSpeed(kinetics, 0.25f);
        scene.world.multiplyKineticSpeed(util.select.position(pumpPos), 0.25f);
        scene.world.showSection(hose, class_2350.field_11036);
        scene.idle(5);
        scene.world.showSection(tank, class_2350.field_11033);
        scene.idle(10);
        scene.world.showSection(pipes, class_2350.field_11043);
        scene.idle(5);
        scene.world.showSection(kinetics, class_2350.field_11033);
        scene.idle(10);
        scene.world.setKineticSpeed(hose, 32.0f);
        scene.idle(10);
        class_243 entryPoint = util.vector.topOf(1, 0, 2);
        scene.overlay.showText(60).text("When deploying the Hose Pulley into a large enough ocean...").attachKeyFrame().placeNearTarget().pointAt(entryPoint);
        scene.idle(40);
        scene.world.modifyBlockEntity(util.grid.at(1, 3, 2), HosePulleyBlockEntity.class, be -> TransferUtil.insertFluid(be.getFluidStorage(null), (FluidStack)new FluidStack((class_3611)class_3612.field_15910, 81000L)));
        scene.world.setKineticSpeed(hose, 0.0f);
        scene.world.modifyBlock(pumpPos, s -> (class_2680)s.method_11657((class_2769)PumpBlock.FACING, (Comparable)class_2350.field_11033), true);
        scene.world.propagatePipeChange(pumpPos);
        scene.idle(30);
        Selection pulleyPos = util.select.position(1, 3, 2);
        scene.overlay.showSelectionWithText(pulleyPos, 60).text("It will provide/dispose fluids without affecting the source").attachKeyFrame().colored(PonderPalette.BLUE).placeNearTarget().pointAt(util.vector.topOf(util.grid.at(1, 3, 2)));
        scene.idle(60);
        scene.world.modifyBlockEntity(util.grid.at(4, 1, 1), FluidTankBlockEntity.class, be -> TransferUtil.insertFluid((Storage)be.getTankInventory(), (FluidStack)new FluidStack((class_3611)class_3612.field_15910, 1944000L)));
        scene.idle(20);
        scene.overlay.showText(60).text("Pipe networks can limitlessly take fluids from/to such pulleys").attachKeyFrame().placeNearTarget().pointAt(util.vector.blockSurface(util.grid.at(3, 2, 2), class_2350.field_11039));
        scene.idle(40);
    }
}

