/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.events;

import com.ordana.spelunkery.Spelunkery;
import com.ordana.spelunkery.blocks.PortalFluidCauldronBlock;
import com.ordana.spelunkery.configs.CommonConfigs;
import com.ordana.spelunkery.items.PortalFluidBottleItem;
import com.ordana.spelunkery.reg.ModBlockProperties;
import com.ordana.spelunkery.reg.ModBlocks;
import com.ordana.spelunkery.reg.ModItems;
import com.ordana.spelunkery.reg.ModSoundEvents;
import com.ordana.spelunkery.reg.ModTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.mehvahdjukaar.moonlight.api.client.util.ParticleUtil;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_4848;
import net.minecraft.class_4969;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5328;
import net.minecraft.class_5556;
import net.minecraft.class_5945;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_8567;

public class ModEvents {
    private static final List<InteractionEvent> EVENTS = new ArrayList<InteractionEvent>();

    public static class_1269 onBlockCLicked(class_1799 stack, class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        if (stack.method_7960()) {
            return class_1269.field_5811;
        }
        class_1792 i = stack.method_7909();
        class_2338 pos = hitResult.method_17777();
        class_2680 state = level.method_8320(pos);
        for (InteractionEvent event : EVENTS) {
            class_1269 result = event.run(i, stack, pos, state, player, level, hand, hitResult);
            if (result == class_1269.field_5811) continue;
            return result;
        }
        return class_1269.field_5811;
    }

    private static class_1269 portalCauldronLogic(class_1792 item, class_1799 stack, class_2338 pos, class_2680 state, class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        if (item == class_1802.field_8469) {
            if (state.method_26204() instanceof PortalFluidCauldronBlock) {
                level.method_8396(player, pos, (class_3414)ModSoundEvents.PORTAL_FLUID_BOTTLE_FILL.get(), class_3419.field_15245, 1.0f, 1.0f);
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    class_1799 itemStack2 = class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)ModItems.PORTAL_FLUID_BOTTLE.get().method_7854());
                    player.method_6122(hand, itemStack2);
                    if ((Integer)state.method_11654((class_2769)class_5556.field_27206) > 1) {
                        level.method_8501(pos, (class_2680)ModBlocks.PORTAL_CAULDRON.get().method_9564().method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf((Integer)state.method_11654((class_2769)class_5556.field_27206) - 1)));
                    } else {
                        level.method_8501(pos, class_2246.field_10593.method_9564());
                    }
                    class_174.field_24478.method_23889(serverPlayer, pos, stack);
                }
                return class_1269.method_29236((boolean)level.field_9236);
            }
        } else if (item == class_1802.field_8550 && state.method_26204() instanceof PortalFluidCauldronBlock && (Integer)state.method_11654((class_2769)class_5556.field_27206) == 3) {
            level.method_8396(player, pos, (class_3414)ModSoundEvents.PORTAL_FLUID_BUCKET_FILL.get(), class_3419.field_15245, 1.0f, 1.0f);
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                class_1799 itemStack2 = class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)ModItems.PORTAL_FLUID_BUCKET.get().method_7854());
                player.method_6122(hand, itemStack2);
                level.method_8501(pos, class_2246.field_10593.method_9564());
                class_174.field_24478.method_23889(serverPlayer, pos, stack);
            }
            return class_1269.method_29236((boolean)level.field_9236);
        }
        return class_1269.field_5811;
    }

    private static class_1269 saltBoiling(class_1792 item, class_1799 stack, class_2338 pos, class_2680 state, class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        if (item == ModItems.SALT.get() && state.method_27852(class_2246.field_27097) && level.method_8320(pos.method_10074()).method_26164(ModTags.CAN_BOIL_WATER)) {
            level.method_8396(player, pos, class_3417.field_15102, class_3419.field_15245, 1.0f, 1.0f);
            level.method_8396(player, pos, class_3417.field_14737, class_3419.field_15245, 1.0f, 1.0f);
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                class_1799 itemStack2 = class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)ModItems.ROCK_SALT.get().method_7854());
                player.method_6122(hand, itemStack2);
                if ((Integer)state.method_11654((class_2769)class_5556.field_27206) > 1) {
                    level.method_8501(pos, (class_2680)class_2246.field_27097.method_9564().method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf((Integer)state.method_11654((class_2769)class_5556.field_27206) - 1)));
                } else {
                    level.method_8501(pos, class_2246.field_10593.method_9564());
                }
                class_174.field_24478.method_23889(serverPlayer, pos, stack);
            }
            return class_1269.method_29236((boolean)level.field_9236);
        }
        return class_1269.field_5811;
    }

    private static class_1269 obsidianDraining(class_1792 item, class_1799 stack, class_2338 pos, class_2680 state, class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        if (item == ModItems.PORTAL_FLUID_BOTTLE.get()) {
            if (state.method_27852(class_2246.field_10593) || state.method_26204() instanceof PortalFluidCauldronBlock && (Integer)state.method_11654((class_2769)class_5556.field_27206) < 3) {
                level.method_8396(player, pos, (class_3414)ModSoundEvents.PORTAL_FLUID_BOTTLE_EMPTY.get(), class_3419.field_15245, 1.0f, 1.0f);
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    class_1799 itemStack2 = class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)class_1802.field_8469.method_7854());
                    player.method_6122(hand, itemStack2);
                    if (state.method_27852(class_2246.field_10593)) {
                        level.method_8501(pos, (class_2680)ModBlocks.PORTAL_CAULDRON.get().method_9564().method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(1)));
                    } else {
                        level.method_8501(pos, (class_2680)ModBlocks.PORTAL_CAULDRON.get().method_9564().method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf((Integer)state.method_11654((class_2769)class_5556.field_27206) + 1)));
                    }
                    class_174.field_24478.method_23889(serverPlayer, pos, stack);
                }
                return class_1269.method_29236((boolean)level.field_9236);
            }
            return class_1269.field_5811;
        }
        if (item == class_1802.field_8469) {
            if (state.method_26204() instanceof class_4848 && CommonConfigs.CRYING_OBSIDIAN_PORTAL_FLUID.get().booleanValue()) {
                level.method_8396(player, pos, (class_3414)ModSoundEvents.PORTAL_FLUID_BOTTLE_FILL.get(), class_3419.field_15245, 1.0f, 1.0f);
                class_5945.method_34682((class_1937)level, (class_2338)pos, (class_2394)class_2398.field_22447, (class_6017)class_6019.method_35017((int)3, (int)5));
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    class_1799 itemStack2 = class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)ModItems.PORTAL_FLUID_BOTTLE.get().method_7854());
                    player.method_6122(hand, itemStack2);
                    level.method_8501(pos, class_2246.field_10540.method_9564());
                    class_174.field_24478.method_23889(serverPlayer, pos, stack);
                }
                return class_1269.method_29236((boolean)level.field_9236);
            }
            if (state.method_26204() instanceof class_4969 && (Integer)state.method_11654((class_2769)class_4969.field_23153) > 0 && CommonConfigs.RESPAWN_ANCHOR_PORTAL_FLUID.get().booleanValue()) {
                level.method_8396(player, pos, (class_3414)ModSoundEvents.PORTAL_FLUID_BOTTLE_FILL.get(), class_3419.field_15245, 1.0f, 1.0f);
                class_5945.method_34682((class_1937)level, (class_2338)pos, (class_2394)class_2398.field_22447, (class_6017)class_6019.method_35017((int)3, (int)5));
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    class_1799 itemStack2 = new class_1799((class_1935)ModItems.PORTAL_FLUID_BOTTLE.get());
                    PortalFluidBottleItem.addLocationTags((class_5321<class_1937>)level.method_27983(), pos, itemStack2.method_7948());
                    if (!player.method_31548().method_7394(itemStack2)) {
                        player.method_7328(itemStack2, false);
                    }
                    stack.method_7934(1);
                    level.method_8501(pos, (class_2680)state.method_11657((class_2769)class_4969.field_23153, (Comparable)Integer.valueOf((Integer)state.method_11654((class_2769)class_4969.field_23153) - 1)));
                    class_174.field_24478.method_23889(serverPlayer, pos, stack);
                }
                return class_1269.method_29236((boolean)level.field_9236);
            }
        }
        return class_1269.field_5811;
    }

    private static class_1269 anvilRepairing(class_1792 item, class_1799 stack, class_2338 pos, class_2680 state, class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        if (stack.method_31573(ModTags.ANVIL_REPAIR_ITEM) && state.method_26164(class_3481.field_15486) && !state.method_27852(class_2246.field_10535)) {
            level.method_8396(player, pos, class_3417.field_14927, class_3419.field_15245, 1.0f, 1.0f);
            level.method_8396(player, pos, class_3417.field_14785, class_3419.field_15245, 1.0f, 1.0f);
            class_5945.method_34682((class_1937)level, (class_2338)pos, (class_2394)new class_2388(class_2398.field_11217, state), (class_6017)class_6019.method_35017((int)3, (int)5));
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                if (!player.method_31549().field_7477) {
                    stack.method_7934(1);
                }
                if (state.method_27852(class_2246.field_10105)) {
                    level.method_8501(pos, class_2246.field_10535.method_9564().method_26204().method_34725(state));
                } else if (state.method_27852(class_2246.field_10414)) {
                    level.method_8501(pos, class_2246.field_10105.method_9564().method_26204().method_34725(state));
                }
                class_174.field_24478.method_23889(serverPlayer, pos, stack);
            }
            return class_1269.method_29236((boolean)level.field_9236);
        }
        return class_1269.field_5811;
    }

    private static class_1269 disenchant(class_1792 item, class_1799 stack, class_2338 pos, class_2680 state, class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        boolean depleted;
        boolean bl = depleted = state.method_27852(ModBlocks.DIAMOND_GRINDSTONE.get()) && (Integer)state.method_11654((class_2769)ModBlockProperties.DEPLETION) == 3 || state.method_27852(class_2246.field_16337);
        if (!player.method_18276()) {
            return class_1269.field_5811;
        }
        if (!state.method_27852(class_2246.field_16337) && !state.method_27852(ModBlocks.DIAMOND_GRINDSTONE.get())) {
            return class_1269.field_5811;
        }
        if (stack.method_7942()) {
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                class_1303.method_31493((class_3218)serverLevel, (class_243)class_243.method_24953((class_2382)pos), (int)ModEvents.getExperienceFromItem(stack, depleted));
            }
            player.method_6122(hand, ModEvents.removeEnchants(stack, stack.method_7919(), depleted));
            return class_1269.field_5812;
        }
        if (stack.method_31573(ModTags.GRINDSTONE_REPAIR_ITEM) && state.method_27852(ModBlocks.DIAMOND_GRINDSTONE.get()) && (Integer)state.method_11654((class_2769)ModBlockProperties.DEPLETION) > 0) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                class_174.field_24478.method_23889(serverPlayer, pos, stack);
            }
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)ModBlockProperties.DEPLETION, (Comparable)Integer.valueOf(0)));
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public static class_1269 useGrindstone(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit, boolean diamondGrindstone) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_7909() == class_1802.field_8162) {
            player.method_17355(state.method_26196(level, pos));
            return class_1269.field_5812;
        }
        boolean success = false;
        boolean depleted = true;
        if (diamondGrindstone) {
            depleted = (Integer)state.method_11654((class_2769)ModBlockProperties.DEPLETION) == 3;
        }
        String itemName = Utils.getID((class_1792)itemStack.method_7909()).method_12832();
        if (!level.method_8608()) {
            class_8567.class_8568 builder;
            class_2960 tablePath = Spelunkery.res("gameplay/" + (diamondGrindstone && !depleted ? "diamond_" : "") + "grindstone_polishing/" + itemName);
            class_52 lootTable = level.method_8503().method_3857().getLootTable(tablePath);
            ObjectArrayList lootItem = lootTable.method_51878((builder = new class_8567.class_8568((class_3218)level).method_51874(class_181.field_1224, (Object)level.method_8320(pos)).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)pos)).method_51874(class_181.field_1229, (Object)class_1799.field_8037)).method_51875(class_173.field_1172));
            if (lootItem.isEmpty()) {
                tablePath = Spelunkery.res("gameplay/grindstone_polishing/" + itemName);
                class_52 lootTable2 = level.method_8503().method_3857().getLootTable(tablePath);
                lootItem = lootTable2.method_51878(builder.method_51875(class_173.field_1172));
            }
            if (lootItem.isEmpty()) {
                player.method_17355(state.method_26196(level, pos));
                player.method_7281(class_3468.field_21779);
                return class_1269.field_5812;
            }
            int deplChance = 0;
            for (class_1799 stack : lootItem) {
                if (stack.method_31574(class_1802.field_8287)) {
                    class_1303.method_31493((class_3218)((class_3218)level), (class_243)class_243.method_24953((class_2382)pos), (int)1);
                    continue;
                }
                if (stack.method_31574(class_1802.field_8542)) {
                    ++deplChance;
                    continue;
                }
                if (player.method_31548().method_7394(stack)) continue;
                player.method_7328(stack, false);
            }
            success = true;
            if (tablePath.method_12832().contains("diamond")) {
                Integer depl = CommonConfigs.DIAMOND_GRINDSTONE_DEPLETE_CHANCE.get();
                for (int i = 0; i < deplChance; ++i) {
                    int chance;
                    int n = chance = depl == 0 ? 0 : level.field_9229.method_43048(CommonConfigs.DIAMOND_GRINDSTONE_DEPLETE_CHANCE.get().intValue());
                    if (chance <= 0 || !diamondGrindstone || chance != 1 || depleted) continue;
                    level.method_8501(pos, (class_2680)state.method_11657((class_2769)ModBlockProperties.DEPLETION, (Comparable)Integer.valueOf((Integer)state.method_11654((class_2769)ModBlockProperties.DEPLETION) + 1)));
                }
            }
        }
        if (level.method_8608()) {
            if (itemStack.method_31573(ModTags.GRINDABLE) || itemStack.method_31573(ModTags.DIAMOND_GRINDABLE)) {
                ParticleUtil.spawnParticlesOnBlockFaces((class_1937)level, (class_2338)pos, (class_2394)new class_2392(class_2398.field_11218, itemStack), (class_6019)class_6019.method_35017((int)3, (int)5), (float)-0.05f, (float)0.05f, (boolean)false);
            }
            player.method_6104(hand);
        }
        if (success) {
            if (!player.method_31549().field_7477 && !level.method_8608()) {
                itemStack.method_7934(1);
            }
            level.method_8396(null, pos, class_3417.field_16865, class_3419.field_15245, 0.5f, 0.0f);
            player.method_6019(hand);
            player.method_6075();
            return class_1269.field_5812;
        }
        return class_1269.field_5812;
    }

    private static int getExperienceFromItem(class_1799 stack, boolean depleted) {
        int i = 0;
        Map map = class_1890.method_8222((class_1799)stack);
        for (Map.Entry enchantmentIntegerEntry : map.entrySet()) {
            class_1887 enchantment = (class_1887)enchantmentIntegerEntry.getKey();
            Integer integer = (Integer)enchantmentIntegerEntry.getValue();
            if (enchantment.method_8195() && depleted) continue;
            i += enchantment.method_8182(integer.intValue());
        }
        return i;
    }

    private static class_1799 removeEnchants(class_1799 stack, int damage, boolean depleted) {
        class_1799 itemStack = stack.method_7972();
        itemStack.method_7983("Enchantments");
        itemStack.method_7983("StoredEnchantments");
        if (damage > 0) {
            itemStack.method_7974(damage);
        } else {
            itemStack.method_7983("Damage");
        }
        itemStack.method_7939(1);
        Map<class_1887, Integer> map = class_1890.method_8222((class_1799)stack).entrySet().stream().filter(entry -> (depleted || !((class_1887)entry.getKey()).method_8195()) && ((class_1887)entry.getKey()).method_8195()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        class_1890.method_8214(map, (class_1799)itemStack);
        itemStack.method_7927(0);
        if (itemStack.method_31574(class_1802.field_8598) && map.size() == 0) {
            itemStack = new class_1799((class_1935)class_1802.field_8529);
            if (stack.method_7938()) {
                itemStack.method_7977(stack.method_7964());
            }
        }
        return itemStack;
    }

    static {
        EVENTS.add(ModEvents::obsidianDraining);
        EVENTS.add(ModEvents::portalCauldronLogic);
        EVENTS.add(ModEvents::saltBoiling);
        EVENTS.add(ModEvents::anvilRepairing);
        EVENTS.add(ModEvents::disenchant);
    }

    @FunctionalInterface
    public static interface InteractionEvent {
        public class_1269 run(class_1792 var1, class_1799 var2, class_2338 var3, class_2680 var4, class_1657 var5, class_1937 var6, class_1268 var7, class_3965 var8);
    }
}

