/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.items;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.ordana.spelunkery.configs.ClientConfigs;
import com.ordana.spelunkery.configs.CommonConfigs;
import com.ordana.spelunkery.utils.LevelHelper;
import com.ordana.spelunkery.utils.TranslationUtils;
import dev.architectury.injectables.annotations.PlatformOnly;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2424;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3675;
import net.minecraft.class_4174;
import net.minecraft.class_4208;
import net.minecraft.class_4480;
import net.minecraft.class_5321;
import net.minecraft.class_5328;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class PortalFluidBottleItem
extends class_4480 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private int tickCounter = 0;
    public static final class_4174 PORTAL_FLUID = new class_4174.class_4175().method_19238(0).method_19237(0.0f).method_19240().method_19242();

    public PortalFluidBottleItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @PlatformOnly(value={"fabric"})
    public boolean allowNbtUpdateAnimation(class_1657 player, class_1268 hand, class_1799 originalStack, class_1799 updatedStack) {
        return false;
    }

    public int setTickCounter(int tick) {
        this.tickCounter = tick;
        return this.tickCounter;
    }

    public void method_7888(@NotNull class_1799 stack, @NotNull class_1937 levelIn, @NotNull class_1297 entityIn, int itemSlot, boolean isSelected) {
        super.method_7888(stack, levelIn, entityIn, itemSlot, isSelected);
        ++this.tickCounter;
        if (this.tickCounter >= 200) {
            this.setBoolean(stack, !this.getBoolean(stack));
            this.setTickCounter(0);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 level, @NotNull List<class_2561> tooltip, @NotNull class_1836 context) {
        if (ClientConfigs.ENABLE_TOOLTIPS.get().booleanValue()) {
            class_2487 compoundTag = stack.method_7948();
            if (this.getBoolean(stack)) {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.spelunkery.rhymes_with_tears_0").method_10862(class_2583.field_24360.method_27706(class_124.field_1064)));
            } else {
                tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.spelunkery.rhymes_with_tears_1", (Object[])new Object[]{this.getBoolean(stack)}).method_10862(class_2583.field_24360.method_27706(class_124.field_1064)));
            }
            if (compoundTag.method_10545("anchorPos") && CommonConfigs.PORTAL_FLUID_DRINKING.get().booleanValue()) {
                class_2338 blockPos = class_2512.method_10691((class_2487)compoundTag.method_10562("anchorPos"));
                tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.spelunkery.portal_fluid_pos", (Object[])new Object[]{blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()}).method_10862(class_2583.field_24360.method_27706(class_124.field_1076)));
            }
            if (class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)class_310.method_1551().field_1690.field_1832.field_1655.method_1444())) {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.spelunkery.portal_fluid_1").method_10862(class_2583.field_24360.method_27706(class_124.field_1080)));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.spelunkery.portal_fluid_2").method_10862(class_2583.field_24360.method_27706(class_124.field_1080)));
                if (CommonConfigs.CRYING_OBSIDIAN_PORTAL_FLUID.get().booleanValue() && CommonConfigs.RESPAWN_ANCHOR_PORTAL_FLUID.get().booleanValue()) {
                    tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.spelunkery.portal_fluid_3c").method_10862(class_2583.field_24360.method_27706(class_124.field_1080)));
                } else if (CommonConfigs.CRYING_OBSIDIAN_PORTAL_FLUID.get().booleanValue()) {
                    tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.spelunkery.portal_fluid_3a").method_10862(class_2583.field_24360.method_27706(class_124.field_1080)));
                } else if (CommonConfigs.RESPAWN_ANCHOR_PORTAL_FLUID.get().booleanValue()) {
                    tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.spelunkery.portal_fluid_3b").method_10862(class_2583.field_24360.method_27706(class_124.field_1080)));
                }
            } else {
                tooltip.add((class_2561)TranslationUtils.CROUCH.component());
            }
        }
    }

    public void setBoolean(@NotNull class_1799 stack, boolean tears) {
        stack.method_7948().method_10556("bool", tears);
    }

    public boolean getBoolean(@NotNull class_1799 stack) {
        return stack.method_7948().method_10577("bool");
    }

    private static boolean inPortalDimension(@NotNull class_1937 level) {
        return level.method_27983() == class_1937.field_25179 || level.method_27983() == class_1937.field_25180;
    }

    @NotNull
    public class_1269 method_7884(@NotNull class_1838 context) {
        Optional optional;
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        class_1657 player = context.method_8036();
        class_1799 stack = context.method_8041();
        if (PortalFluidBottleItem.inPortalDimension(level) && (optional = class_2424.method_30485((class_1936)level, (class_2338)pos.method_10093(context.method_8038()), (class_2350.class_2351)class_2350.class_2351.field_11048)).isPresent()) {
            ((class_2424)optional.get()).method_10363();
            if (CommonConfigs.PORTAL_CREATION_SOUND.get().booleanValue()) {
                level.method_8396(null, pos, class_3417.field_23118, class_3419.field_15245, 1.0f, 1.0f);
            }
            class_1799 itemStack2 = class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)class_1802.field_8469.method_7854());
            player.method_6122(context.method_20287(), itemStack2);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public boolean method_7886(@NotNull class_1799 stack) {
        return true;
    }

    @NotNull
    public class_3414 method_21831() {
        return class_3417.field_20615;
    }

    @NotNull
    public class_3414 method_21830() {
        return class_3417.field_20615;
    }

    @NotNull
    public class_1799 method_7861(@NotNull class_1799 stack, @NotNull class_1937 level, @NotNull class_1309 livingEntity) {
        if (livingEntity instanceof class_1657) {
            class_1657 player = (class_1657)livingEntity;
            class_1799 itemStack2 = class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)class_1802.field_8469.method_7854());
            player.method_6122(player.method_6058(), itemStack2);
        }
        if (livingEntity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)livingEntity;
            if (CommonConfigs.PORTAL_FLUID_DRINKING.get().booleanValue()) {
                class_174.field_1198.method_8821(serverPlayer, stack);
                serverPlayer.method_7259(class_3468.field_15372.method_14956((Object)this));
                class_2487 compoundTag = stack.method_7948();
                boolean bl = compoundTag.method_10545("anchorPos");
                boolean bl2 = compoundTag.method_10545("anchorDimension");
                PortalFluidBottleItem.getDimension(compoundTag);
                if (bl && bl2) {
                    LevelHelper.teleportToAnchorPosition(serverPlayer, PortalFluidBottleItem.getAnchorPos(compoundTag));
                } else {
                    LevelHelper.teleportToSpawnPosition(serverPlayer);
                }
            }
        }
        return stack;
    }

    public static void addLocationTags(class_5321<class_1937> anchorDimension, class_2338 pos, class_2487 compoundTag) {
        if (!compoundTag.method_10545("anchorPos")) {
            compoundTag.method_10566("anchorPos", (class_2520)class_2512.method_10692((class_2338)pos));
        }
        DataResult var10000 = class_1937.field_25178.encodeStart((DynamicOps)class_2509.field_11560, anchorDimension);
        Logger var10001 = LOGGER;
        Objects.requireNonNull(var10001);
        var10000.resultOrPartial(arg_0 -> ((Logger)var10001).error(arg_0)).ifPresent(tag -> compoundTag.method_10566("anchorDimension", tag));
    }

    private static Optional<class_5321<class_1937>> getDimension(class_2487 compoundTag) {
        return class_1937.field_25178.parse((DynamicOps)class_2509.field_11560, (Object)compoundTag.method_10580("anchorDimension")).result();
    }

    public static class_4208 getAnchorPos(class_2487 compoundTag) {
        Optional<class_5321<class_1937>> optional;
        boolean bl = compoundTag.method_10545("anchorPos");
        boolean bl2 = compoundTag.method_10545("anchorDimension");
        if (bl && bl2 && (optional = PortalFluidBottleItem.getDimension(compoundTag)).isPresent()) {
            class_2338 blockPos = class_2512.method_10691((class_2487)compoundTag.method_10562("anchorPos"));
            return class_4208.method_19443(optional.get(), (class_2338)blockPos);
        }
        return null;
    }
}

