/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.machines.MachinePackets;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.machines.guicomponents.ShapeSelection;
import aztech.modern_industrialization.util.Rectangle;
import aztech.modern_industrialization.util.TextHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class ShapeSelectionClient
implements GuiComponentClient {
    private final ShapeSelection.LineInfo[] lines;
    final int[] currentData;
    private Renderer renderer;

    public ShapeSelectionClient(class_2540 buf) {
        this.lines = new ShapeSelection.LineInfo[buf.method_10816()];
        for (int i = 0; i < this.lines.length; ++i) {
            int numValues = buf.method_10816();
            ArrayList<class_2561> components = new ArrayList<class_2561>();
            for (int j = 0; j < numValues; ++j) {
                components.add(buf.method_10808());
            }
            this.lines[i] = new ShapeSelection.LineInfo(numValues, components, buf.readBoolean());
        }
        this.currentData = new int[this.lines.length];
        this.readCurrentData(buf);
    }

    @Override
    public void readCurrentData(class_2540 buf) {
        for (int i = 0; i < this.currentData.length; ++i) {
            this.currentData[i] = buf.method_10816();
        }
    }

    @Override
    public ClientComponentRenderer createRenderer(MachineScreen machineScreen) {
        int maxWidth = 1;
        for (ShapeSelection.LineInfo line : this.lines) {
            for (class_2561 class_25612 : line.translations()) {
                maxWidth = Math.max(maxWidth, class_310.method_1551().field_1772.method_27525((class_5348)class_25612));
            }
        }
        this.renderer = new Renderer(maxWidth);
        return this.renderer;
    }

    Renderer getRenderer() {
        return this.renderer;
    }

    @Environment(value=EnvType.CLIENT)
    class Renderer
    implements ClientComponentRenderer {
        boolean isPanelOpen = false;
        private final int btnSize = 12;
        private final int borderSize = 3;
        private final int outerPadding = 5;
        private final int innerPadding = 5;
        private final int textMaxWidth;
        private final int panelWidth;

        private Renderer(int textMaxWidth) {
            this.textMaxWidth = textMaxWidth;
            this.panelWidth = 25 + textMaxWidth + 5 + 12 + 5;
        }

        private static int getVerticalPos(int lineId) {
            return 46 + 16 * lineId;
        }

        @Override
        public void addButtons(ClientComponentRenderer.ButtonContainer container) {
            for (int i = 0; i < ShapeSelectionClient.this.lines.length; ++i) {
                int iCopy = i;
                ShapeSelection.LineInfo line = ShapeSelectionClient.this.lines[i];
                int baseU = line.useArrows() ? 174 : 150;
                int v = 58;
                container.addButton(-this.panelWidth + 3 + 5, Renderer.getVerticalPos(i), 12, 12, syncId -> ClientPlayNetworking.send((class_2960)MachinePackets.C2S.CHANGE_SHAPE, (class_2540)MachinePackets.C2S.encodeChangeShape(syncId, iCopy, true)), List::of, (screen, button, guiGraphics, mouseX, mouseY, delta) -> {
                    if (ShapeSelectionClient.this.currentData[iCopy] == 0) {
                        screen.blitButtonNoHighlight(button, guiGraphics, baseU, v + 12);
                    } else {
                        screen.blitButtonSmall(button, guiGraphics, baseU, v);
                    }
                }, () -> this.isPanelOpen);
                container.addButton(-17, Renderer.getVerticalPos(i), 12, 12, syncId -> ClientPlayNetworking.send((class_2960)MachinePackets.C2S.CHANGE_SHAPE, (class_2540)MachinePackets.C2S.encodeChangeShape(syncId, iCopy, false)), List::of, (screen, button, guiGraphics, mouseX, mouseY, delta) -> {
                    if (ShapeSelectionClient.this.currentData[iCopy] == line.numValues() - 1) {
                        screen.blitButtonNoHighlight(button, guiGraphics, baseU + 12, v + 12);
                    } else {
                        screen.blitButtonSmall(button, guiGraphics, baseU + 12, v);
                    }
                }, () -> this.isPanelOpen);
            }
            container.addButton(-24, 17, 20, 20, syncId -> {
                this.isPanelOpen = !this.isPanelOpen;
            }, () -> List.of(MIText.ShapeSelectionTitle.text(), MIText.ShapeSelectionDescription.text().method_10862(TextHelper.GRAY_TEXT)), (screen, button, guiGraphics, mouseX, mouseY, delta) -> screen.blitButton(button, guiGraphics, 138, 38));
        }

        @Override
        public void renderBackground(class_332 guiGraphics, int leftPos, int topPos) {
            Rectangle box = this.getBox(leftPos, topPos);
            guiGraphics.method_25302(MachineScreen.BACKGROUND, box.x(), box.y(), 0, 0, box.w(), box.h() - 4);
            guiGraphics.method_25302(MachineScreen.BACKGROUND, box.x(), box.y() + box.h() - 4, 0, 252, box.w(), 4);
            if (this.isPanelOpen) {
                RenderSystem.disableDepthTest();
                for (int i = 0; i < ShapeSelectionClient.this.lines.length; ++i) {
                    ShapeSelection.LineInfo line = ShapeSelectionClient.this.lines[i];
                    class_2561 tooltip = line.translations().get(ShapeSelectionClient.this.currentData[i]);
                    int width = class_310.method_1551().field_1772.method_27525((class_5348)tooltip);
                    guiGraphics.method_51439(class_310.method_1551().field_1772, tooltip, box.x() + 3 + 5 + 12 + 5 + (this.textMaxWidth - width) / 2, topPos + Renderer.getVerticalPos(i) + 2, 0x404040, false);
                }
                RenderSystem.enableDepthTest();
            }
        }

        public Rectangle getBox(int leftPos, int topPos) {
            if (this.isPanelOpen) {
                int topOffset = 10;
                return new Rectangle(leftPos - this.panelWidth, topPos + topOffset, this.panelWidth, Renderer.getVerticalPos(ShapeSelectionClient.this.lines.length - 1) - topOffset + 12 + 5 + 3);
            }
            return new Rectangle(leftPos - 31, topPos + 10, 31, 34);
        }

        @Override
        public void addExtraBoxes(List<Rectangle> rectangles, int leftPos, int topPos) {
            rectangles.add(this.getBox(leftPos, topPos));
        }
    }
}

