/*
 * Decompiled with CFR 0.152.
 */
package us.mikebartosh.minecraft;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_266;
import net.minecraft.class_267;
import net.minecraft.class_274;
import net.minecraft.class_2960;
import net.minecraft.class_2995;
import net.minecraft.class_3222;
import net.minecraft.class_4970;
import net.minecraft.class_5251;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.mikebartosh.minecraft.CoinBlock;
import us.mikebartosh.minecraft.CoinBlocks;
import us.mikebartosh.minecraft.CoinItems.Copper;
import us.mikebartosh.minecraft.CoinItems.Gold;
import us.mikebartosh.minecraft.CoinItems.Silver;
import us.mikebartosh.minecraft.Config;

public class CopperCoins
implements ModInitializer {
    public static final String MOD_ID = "copper-coins";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"copper-coins");
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("copper-coins.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static Config CONFIG;
    public static class_1792 COPPER_COIN;
    public static class_1792 SILVER_COIN;
    public static class_1792 GOLD_COIN;
    public static class_2248 COPPER_COIN_BLOCK;
    public static class_2248 SILVER_COIN_BLOCK;
    public static class_2248 GOLD_COIN_BLOCK;
    private static final String OBJ_JOINED_BEFORE = "joined_before";
    private static final String OBJ_DAILY_JOIN = "daily_joined";
    private static final String OBJ_TICKS_SINCE_JOIN = "ticks_since_join";
    private static final String OBJ_THIRTY_MIN = "thirty_min_done";
    private static final String OBJ_JIMS_BOARD = "daily_copper_total";
    public static class_1761 COPPER_COINS_GROUP;
    private long lastResetEpochDay;

    public void onInitialize() {
        this.loadConfig();
        this.lastResetEpochDay = CopperCoins.CONFIG.lastResetEpochDay;
        if (CopperCoins.CONFIG.enableCopper) {
            COPPER_COIN = new Copper(new class_1792.class_1793().method_7889(CopperCoins.CONFIG.maxCopperStack).method_7894(class_1814.field_8906));
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960(MOD_ID, "copper_coin"), (Object)COPPER_COIN);
            if (CopperCoins.CONFIG.enableCopperBlock) {
                COPPER_COIN_BLOCK = CoinBlocks.register((class_2248)new CoinBlock(class_4970.class_2251.method_9637().method_9626(class_2498.field_27204)), "copper_coins");
            }
        }
        if (CopperCoins.CONFIG.enableSilver) {
            SILVER_COIN = new Silver(new class_1792.class_1793().method_7889(CopperCoins.CONFIG.maxSilverStack).method_7894(class_1814.field_8907));
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960(MOD_ID, "silver_coin"), (Object)SILVER_COIN);
            if (CopperCoins.CONFIG.enableSilverBlock) {
                SILVER_COIN_BLOCK = CoinBlocks.register((class_2248)new CoinBlock(class_4970.class_2251.method_9637().method_9626(class_2498.field_11533)), "silver_coins");
            }
        }
        if (CopperCoins.CONFIG.enableGold) {
            GOLD_COIN = new Gold(new class_1792.class_1793().method_7889(CopperCoins.CONFIG.maxGoldStack).method_7894(class_1814.field_8904));
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960(MOD_ID, "gold_coin"), (Object)GOLD_COIN);
            if (CopperCoins.CONFIG.enableGoldBlock) {
                GOLD_COIN_BLOCK = CoinBlocks.register((class_2248)new CoinBlock(class_4970.class_2251.method_9637().method_9626(class_2498.field_11533)), "gold_coins");
            }
        }
        COPPER_COINS_GROUP = (class_1761)class_2378.method_10230((class_2378)class_7923.field_44687, (class_2960)new class_2960(MOD_ID, "copper_coins"), (Object)FabricItemGroup.builder().method_47320(() -> new class_1799((class_1935)COPPER_COIN)).method_47321((class_2561)class_2561.method_43470((String)"Copper Coins")).method_47317((displayContext, entries) -> {
            if (CopperCoins.CONFIG.enableCopper && COPPER_COIN != null) {
                entries.method_45421((class_1935)COPPER_COIN);
            }
            if (CopperCoins.CONFIG.enableSilver && SILVER_COIN != null) {
                entries.method_45421((class_1935)SILVER_COIN);
            }
            if (CopperCoins.CONFIG.enableGold && GOLD_COIN != null) {
                entries.method_45421((class_1935)GOLD_COIN);
            }
        }).method_47324());
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            int dailyJoin;
            class_3222 player = handler.field_14140;
            this.ensureObjectives(server);
            String playerName = player.method_5820();
            int joinedBefore = CopperCoins.getScore(server, playerName, OBJ_JOINED_BEFORE);
            if (joinedBefore == 0) {
                CopperCoins.giveItemToPlayer(player, new class_1799((class_1935)SILVER_COIN, 1));
                CopperCoins.setScore(server, playerName, OBJ_JOINED_BEFORE, 1);
                server.method_3760().method_43514((class_2561)class_2561.method_43470((String)("Welcome " + playerName + " to L&M!")).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)8454118))), false);
                LOGGER.info("Gave first-join gift to {}", (Object)playerName);
            }
            if ((dailyJoin = CopperCoins.getScore(server, player.method_5820(), OBJ_DAILY_JOIN)) == 0) {
                this.giveDailyReward(server, player);
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (server.method_3780() % 20 != 0) {
                return;
            }
            ZoneId CST = ZoneId.of("America/Chicago");
            long todayEpoch = LocalDate.now(CST).toEpochDay();
            if (this.lastResetEpochDay != todayEpoch) {
                this.resetDailyScores(server);
                this.lastResetEpochDay = todayEpoch;
                CopperCoins.CONFIG.lastResetEpochDay = todayEpoch;
                this.saveConfig();
                LOGGER.info("[Copper Coins] Daily reset executed for {}", (Object)todayEpoch);
            }
            List players = server.method_3760().method_14571();
            for (class_3222 player : players) {
                String name = player.method_5820();
                if (CopperCoins.getScore(server, name, OBJ_DAILY_JOIN) != 1) continue;
                int ticks = CopperCoins.getScore(server, name, OBJ_TICKS_SINCE_JOIN);
                CopperCoins.setScore(server, name, OBJ_TICKS_SINCE_JOIN, ticks += 20);
                int thirtyMinuteStep = CopperCoins.getScore(server, player.method_5820(), OBJ_THIRTY_MIN);
                if (thirtyMinuteStep > 4 || ticks < 36000) continue;
                this.giveThirtyMinReward(server, player);
            }
        });
        LOGGER.info("Mike's Copper Coins Loaded!");
    }

    private void giveDailyReward(MinecraftServer server, class_3222 player) {
        player.method_7353((class_2561)class_2561.method_43470((String)"You received your daily login reward!").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFFAA00))), true);
        LOGGER.info("[Copper Coins] Daily reward given to {}", (Object)player.method_5820());
        CopperCoins.addScore(server, player.method_5820(), OBJ_JIMS_BOARD, 1);
        CopperCoins.setScore(server, player.method_5820(), OBJ_DAILY_JOIN, 1);
        CopperCoins.setScore(server, player.method_5820(), OBJ_TICKS_SINCE_JOIN, 0);
        CopperCoins.setScore(server, player.method_5820(), OBJ_THIRTY_MIN, 1);
    }

    private void giveThirtyMinReward(MinecraftServer server, class_3222 player) {
        if (CopperCoins.getScore(server, player.method_5820(), OBJ_JIMS_BOARD) >= 5) {
            player.method_43502((class_2561)class_2561.method_43470((String)"Jim is full of coins!\nPlease collect them to start gaining your daily coins.").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFFAA00))), false);
        } else {
            CopperCoins.addScore(server, player.method_5820(), OBJ_THIRTY_MIN, 1);
            CopperCoins.addScore(server, player.method_5820(), OBJ_JIMS_BOARD, 1);
            player.method_7353((class_2561)class_2561.method_43470((String)"You've been online 30 minutes and gained 1cc!").method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFFAA00))), true);
            LOGGER.info("[Copper Coins] 30-minute reward given to {}", (Object)player.method_5820());
        }
        CopperCoins.setScore(server, player.method_5820(), OBJ_TICKS_SINCE_JOIN, 0);
    }

    private static void giveItemToPlayer(class_3222 player, class_1799 stack) {
        class_1799 copy = stack.method_7972();
        boolean inserted = player.method_31548().method_7394(copy);
        if (!inserted) {
            player.method_7328(copy, false);
        }
    }

    private static int getScore(MinecraftServer server, String playerName, String objectiveName) {
        class_2995 scoreboard = server.method_3845();
        class_266 obj = scoreboard.method_1165(objectiveName);
        if (obj == null) {
            return 0;
        }
        return scoreboard.method_1180(playerName, obj).method_1126();
    }

    private static void addScore(MinecraftServer server, String playerName, String objectiveName, int valueToAdd) {
        class_2995 scoreboard = server.method_3845();
        class_266 obj = scoreboard.method_1165(objectiveName);
        if (obj == null) {
            obj = scoreboard.method_1168(objectiveName, class_274.field_1468, (class_2561)class_2561.method_43470((String)objectiveName), class_274.class_275.field_1472);
        }
        class_267 score = scoreboard.method_1180(playerName, obj);
        score.method_1128(score.method_1126() + valueToAdd);
    }

    private static void setScore(MinecraftServer server, String playerName, String objectiveName, int value) {
        class_2995 scoreboard = server.method_3845();
        class_266 obj = scoreboard.method_1165(objectiveName);
        if (obj == null) {
            obj = scoreboard.method_1168(objectiveName, class_274.field_1468, (class_2561)class_2561.method_43470((String)objectiveName), class_274.class_275.field_1472);
        }
        scoreboard.method_1180(playerName, obj).method_1128(value);
    }

    private void ensureObjectives(MinecraftServer server) {
        class_2995 scoreboard = server.method_3845();
        if (scoreboard.method_1165(OBJ_JOINED_BEFORE) == null) {
            scoreboard.method_1168(OBJ_JOINED_BEFORE, class_274.field_1468, (class_2561)class_2561.method_43470((String)OBJ_JOINED_BEFORE), class_274.class_275.field_1472);
        }
        if (scoreboard.method_1165(OBJ_DAILY_JOIN) == null) {
            scoreboard.method_1168(OBJ_DAILY_JOIN, class_274.field_1468, (class_2561)class_2561.method_43470((String)OBJ_DAILY_JOIN), class_274.class_275.field_1472);
        }
        if (scoreboard.method_1165(OBJ_TICKS_SINCE_JOIN) == null) {
            scoreboard.method_1168(OBJ_TICKS_SINCE_JOIN, class_274.field_1468, (class_2561)class_2561.method_43470((String)OBJ_TICKS_SINCE_JOIN), class_274.class_275.field_1472);
        }
        if (scoreboard.method_1165(OBJ_THIRTY_MIN) == null) {
            scoreboard.method_1168(OBJ_THIRTY_MIN, class_274.field_1468, (class_2561)class_2561.method_43470((String)OBJ_THIRTY_MIN), class_274.class_275.field_1472);
        }
        if (scoreboard.method_1165(OBJ_JIMS_BOARD) == null) {
            scoreboard.method_1168(OBJ_JIMS_BOARD, class_274.field_1468, (class_2561)class_2561.method_43470((String)OBJ_JIMS_BOARD), class_274.class_275.field_1472);
        }
    }

    private void clearObjectives(MinecraftServer server) {
        class_2995 scoreboard = server.method_3845();
        if (scoreboard.method_1165(OBJ_DAILY_JOIN) != null) {
            scoreboard.method_1194(scoreboard.method_1165(OBJ_DAILY_JOIN));
        }
        if (scoreboard.method_1165(OBJ_TICKS_SINCE_JOIN) != null) {
            scoreboard.method_1194(scoreboard.method_1165(OBJ_TICKS_SINCE_JOIN));
        }
        if (scoreboard.method_1165(OBJ_THIRTY_MIN) != null) {
            scoreboard.method_1194(scoreboard.method_1165(OBJ_THIRTY_MIN));
        }
    }

    private void resetDailyScores(MinecraftServer server) {
        this.clearObjectives(server);
        this.ensureObjectives(server);
    }

    private void loadConfig() {
        try {
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                String json = Files.readString(CONFIG_PATH);
                CONFIG = (Config)GSON.fromJson(json, Config.class);
                LOGGER.info("Loaded config: {}", (Object)CONFIG_PATH);
            } else {
                CONFIG = new Config();
                this.saveConfig();
                LOGGER.info("Created default config: {}", (Object)CONFIG_PATH);
            }
        }
        catch (JsonSyntaxException | IOException e) {
            LOGGER.error("Failed to load config, using defaults", e);
            CONFIG = new Config();
        }
    }

    private void saveConfig() {
        try {
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((Object)CONFIG), new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save config", (Throwable)e);
        }
    }
}

