/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.network;

import com.majruszlibrary.network.NetworkHandler;
import com.majruszlibrary.platform.Side;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class NetworkObject<Type> {
    final NetworkHandler networkHandler;
    final class_2960 id;
    final Class<Type> clazz;
    final Supplier<Type> instance;
    final List<Consumer<Type>> clientCallbacks = new ArrayList<Consumer<Type>>();
    final List<BiConsumer<Type, class_3222>> serverCallbacks = new ArrayList<BiConsumer<Type, class_3222>>();

    public NetworkObject(NetworkHandler networkHandler, class_2960 id, Class<Type> clazz, Supplier<Type> instance) {
        this.networkHandler = networkHandler;
        this.id = id;
        this.clazz = clazz;
        this.instance = instance;
    }

    public void sendToClients(List<class_3222> players, Type message) {
        NetworkHandler.PLATFORM.sendToClients(this, message, players);
    }

    public void sendToClients(List<class_3222> players) {
        this.sendToClients(players, this.instance.get());
    }

    public void sendToClients(Type message) {
        this.sendToClients(Side.getServer().method_3760().method_14571(), message);
    }

    public void sendToClients() {
        this.sendToClients(this.instance.get());
    }

    public void sendToClient(class_3222 player, Type message) {
        this.sendToClients(List.of(player), message);
    }

    public void sendToClient(class_3222 player) {
        this.sendToClient(player, this.instance.get());
    }

    public void sendToServer(Type message) {
        NetworkHandler.PLATFORM.sendToServer(this, message);
    }

    public void sendToServer() {
        this.sendToServer(this.instance.get());
    }

    public void broadcastOnClient(Type message) {
        this.clientCallbacks.forEach(consumer -> consumer.accept(message));
    }

    public void broadcastOnServer(Type message, class_3222 player) {
        this.serverCallbacks.forEach(consumer -> consumer.accept(message, player));
    }

    public void addClientCallback(Consumer<Type> callback) {
        this.clientCallbacks.add(callback);
    }

    public void addClientCallback(Runnable callback) {
        this.addClientCallback((Type data) -> callback.run());
    }

    public void addServerCallback(BiConsumer<Type, class_3222> callback) {
        this.serverCallbacks.add(callback);
    }

    public void addServerCallback(Consumer<class_3222> callback) {
        this.addServerCallback((Type data, class_3222 player) -> callback.accept((class_3222)player));
    }
}

