/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitminers.extendedgears.cogwheels;

import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.StitchedSprite;
import com.rabbitminers.extendedgears.cogwheels.CogwheelModelKey;
import com.rabbitminers.extendedgears.cogwheels.materials.ClientCogwheelMaterial;
import com.rabbitminers.extendedgears.cogwheels.materials.CogwheelMaterialManager;
import com.rabbitminers.extendedgears.registry.ExtendedCogwheelsPartials;
import com.simibubi.create.foundation.model.BakedModelHelper;
import com.simibubi.create.foundation.render.SuperByteBufferCache;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_777;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class DynamicCogwheelRenderer {
    public static final SuperByteBufferCache.Compartment<CogwheelModelKey> COGWHEEL = new SuperByteBufferCache.Compartment();
    public static final StitchedSprite STRIPPED_LOG_TEMPLATE = new StitchedSprite(new class_2960("block/stripped_spruce_log"));
    public static final StitchedSprite STRIPPED_LOG_TOP_TEMPLATE = new StitchedSprite(new class_2960("block/stripped_spruce_log_top"));
    public static final String[] LOG_SUFFIXES = new String[]{"_log", "_stem"};

    @NotNull
    public static class_1087 generateModel(CogwheelModelKey key) {
        ClientCogwheelMaterial material = CogwheelMaterialManager.clientOf(key.material());
        PartialModel model = material != null ? material.getModel(key.large()) : DynamicCogwheelRenderer.standardCogwheelModel(key.large());
        return DynamicCogwheelRenderer.generateModel(model.get(), key.material());
    }

    public static PartialModel standardCogwheelModel(boolean isLarge) {
        return isLarge ? ExtendedCogwheelsPartials.LARGE_COGWHEEL : ExtendedCogwheelsPartials.COGWHEEL;
    }

    public static class_1087 generateModel(class_1087 template, class_2960 id) {
        Reference2ReferenceOpenHashMap map = new Reference2ReferenceOpenHashMap();
        String path = id.method_12832();
        if (path.endsWith("_planks")) {
            String namespace = id.method_12836();
            String wood = path.substring(0, path.length() - 7);
            class_2680 logBlockState = DynamicCogwheelRenderer.getStrippedLogState(namespace, wood);
            map.put(STRIPPED_LOG_TEMPLATE.get(), DynamicCogwheelRenderer.getSpriteOnSide(logBlockState, class_2350.field_11035));
            map.put(STRIPPED_LOG_TOP_TEMPLATE.get(), DynamicCogwheelRenderer.getSpriteOnSide(logBlockState, class_2350.field_11036));
        } else {
            ClientCogwheelMaterial material = CogwheelMaterialManager.clientOf(id);
            if (material == null) {
                return BakedModelHelper.generateModel((class_1087)template, sprite -> null);
            }
            material.textures().forEach((arg_0, arg_1) -> DynamicCogwheelRenderer.lambda$generateModel$1((Map)map, arg_0, arg_1));
        }
        return BakedModelHelper.generateModel((class_1087)template, ((Map)map)::get);
    }

    public static class_2680 getStrippedLogState(String namespace, String wood) {
        for (String suffix : LOG_SUFFIXES) {
            Optional<class_2680> state = class_7923.field_41175.method_40264(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)new class_2960(namespace, "stripped_" + wood + suffix))).map(class_6880::comp_349).map(class_2248::method_9564);
            if (!state.isPresent()) continue;
            return state.get();
        }
        return class_2246.field_10431.method_9564();
    }

    public static class_1058 getSpriteOnSide(class_2680 state, class_2350 side) {
        class_1087 model = class_310.method_1551().method_1541().method_3349(state);
        if (model == null) {
            return null;
        }
        class_5819 random = class_5819.method_43047();
        random.method_43052(42L);
        List quads = model.method_4707(state, side, random);
        if (!quads.isEmpty()) {
            return ((class_777)quads.get(0)).method_35788();
        }
        random.method_43052(42L);
        quads = model.method_4707(state, null, random);
        if (!quads.isEmpty()) {
            for (class_777 quad : quads) {
                if (quad.method_3358() != side) continue;
                return quad.method_35788();
            }
        }
        return model.method_4711();
    }

    private static /* synthetic */ void lambda$generateModel$1(Map map, StitchedSprite old, StitchedSprite replacement) {
        map.put(old.get(), replacement.get());
    }
}

