/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitminers.extendedgears.mixin;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.core.model.BlockModel;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.rabbitminers.extendedgears.cogwheels.CogwheelModelKey;
import com.rabbitminers.extendedgears.cogwheels.DynamicCogwheelRenderer;
import com.rabbitminers.extendedgears.mixin_interface.IDynamicMaterialBlockEntity;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityInstance;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedCogInstance;
import com.simibubi.create.foundation.render.CachedBufferer;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1087;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EncasedCogInstance.class})
public class MixinEncasedCogInstance
extends KineticBlockEntityInstance<KineticBlockEntity> {
    @Shadow
    protected RotatingData rotatingModel;
    @Shadow
    protected Optional<RotatingData> rotatingTopShaft;
    @Shadow
    protected Optional<RotatingData> rotatingBottomShaft;
    protected ModelData casing;
    protected KineticBlockEntity blockEntity;
    protected boolean large;
    @Nullable
    protected CogwheelModelKey key;

    public MixinEncasedCogInstance(MaterialManager materialManager, KineticBlockEntity blockEntity) {
        super(materialManager, blockEntity);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void onInit(MaterialManager modelManager, KineticBlockEntity blockEntity, boolean large, CallbackInfo ci) {
        this.blockEntity = blockEntity;
        if (blockEntity instanceof IDynamicMaterialBlockEntity) {
            IDynamicMaterialBlockEntity dynamicMaterialBlockEntity = (IDynamicMaterialBlockEntity)blockEntity;
            if (!blockEntity.method_11010().method_27852((class_2248)AllBlocks.SHAFT.get())) {
                ICogWheel cogWheel;
                class_2248 class_22482 = blockEntity.method_11010().method_26204();
                this.large = class_22482 instanceof ICogWheel && (cogWheel = (ICogWheel)class_22482).isLargeCog();
                this.key = new CogwheelModelKey(large, blockEntity.method_11010(), dynamicMaterialBlockEntity.getMaterial());
            }
        }
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, remap=false)
    public void registerCasing(CallbackInfo ci) {
        Material mat = this.getTransformMaterial();
        this.casing = (ModelData)mat.getModel(this.blockEntity.method_11010()).createInstance();
        class_4587 msLocal = new class_4587();
        TransformStack msr = TransformStack.cast((class_4587)msLocal);
        msr.translate((class_2382)this.getInstancePosition());
        this.casing.setTransform(msLocal);
        msLocal.method_22909();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean shouldReset() {
        if (super.shouldReset()) return true;
        KineticBlockEntity kineticBlockEntity = this.blockEntity;
        if (!(kineticBlockEntity instanceof IDynamicMaterialBlockEntity)) return false;
        IDynamicMaterialBlockEntity dynamicMaterialBlockEntity = (IDynamicMaterialBlockEntity)kineticBlockEntity;
        if (this.key == null) return false;
        if (this.key.material() == dynamicMaterialBlockEntity.getMaterial()) return false;
        return true;
    }

    @Redirect(method={"getCogModel"}, at=@At(value="INVOKE", target="Lcom/jozufozu/flywheel/api/Material;getModel(Lcom/jozufozu/flywheel/core/PartialModel;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;Ljava/util/function/Supplier;)Lcom/jozufozu/flywheel/api/Instancer;"))
    public Instancer<RotatingData> changeCogwheelModel(Material<RotatingData> instance, PartialModel partial, class_2680 referenceState, class_2350 dir, Supplier<class_4587> modelTransform) {
        if (this.key == null) {
            return instance.getModel(partial);
        }
        return instance.model((Object)this.key, () -> {
            class_1087 model = DynamicCogwheelRenderer.generateModel(this.key);
            class_4587 transform = (class_4587)CachedBufferer.rotateToFaceVertical((class_2350)dir).get();
            return BlockModel.of((class_1087)model, (class_2680)class_2246.field_10124.method_9564(), (class_4587)transform);
        });
    }

    @Inject(method={"updateLight"}, at={@At(value="HEAD")}, remap=false)
    public void updateCasingLight(CallbackInfo ci) {
        this.relight(this.pos, new FlatLit[]{this.casing});
    }

    public void remove() {
        this.casing.delete();
        this.rotatingModel.delete();
        this.rotatingTopShaft.ifPresent(InstanceData::delete);
        this.rotatingBottomShaft.ifPresent(InstanceData::delete);
    }
}

