/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.fan;

import com.simibubi.create.AllTags;
import com.simibubi.create.content.decoration.copycat.CopycatBlock;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.kinetics.fan.AirCurrentSound;
import com.simibubi.create.content.kinetics.fan.AirFlowParticleData;
import com.simibubi.create.content.kinetics.fan.EncasedFanBlockEntity;
import com.simibubi.create.content.kinetics.fan.IAirCurrentSource;
import com.simibubi.create.content.kinetics.fan.processing.AllFanProcessingTypes;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessing;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.mixin.fabric.ServerGamePacketListenerImplAccessor;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.fabricators_of_create.porting_lib.util.EnvExecutor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import org.apache.commons.lang3.tuple.Pair;

public class AirCurrent {
    public final IAirCurrentSource source;
    public class_238 bounds = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public List<AirCurrentSegment> segments = new ArrayList<AirCurrentSegment>();
    public class_2350 direction;
    public boolean pushing;
    public float maxDistance;
    protected List<Pair<TransportedItemStackHandlerBehaviour, FanProcessingType>> affectedItemHandlers = new ArrayList<Pair<TransportedItemStackHandlerBehaviour, FanProcessingType>>();
    protected List<class_1297> caughtEntities = new ArrayList<class_1297>();
    private static final double[][] DEPTH_TEST_COORDINATES = new double[][]{{0.25, 0.25}, {0.25, 0.75}, {0.5, 0.5}, {0.75, 0.25}, {0.75, 0.75}};
    private static boolean isClientPlayerInAirCurrent;
    @Environment(value=EnvType.CLIENT)
    private static AirCurrentSound flyingSound;

    public AirCurrent(IAirCurrentSource source) {
        this.source = source;
    }

    public void tick() {
        class_1937 world;
        if (this.direction == null) {
            this.rebuild();
        }
        if ((world = this.source.getAirCurrentWorld()) != null && world.field_9236) {
            float offset = this.pushing ? 0.5f : this.maxDistance + 0.5f;
            class_243 pos = VecHelper.getCenterOf((class_2382)this.source.getAirCurrentPos()).method_1019(class_243.method_24954((class_2382)this.direction.method_10163()).method_1021((double)offset));
            if ((double)world.field_9229.method_43057() < (Double)AllConfigs.client().fanParticleDensity.get()) {
                world.method_8406((class_2394)new AirFlowParticleData((class_2382)this.source.getAirCurrentPos()), pos.field_1352, pos.field_1351, pos.field_1350, 0.0, 0.0, 0.0);
            }
        }
        this.tickAffectedEntities(world);
        this.tickAffectedHandlers();
    }

    protected void tickAffectedEntities(class_1937 world) {
        Iterator<class_1297> iterator = this.caughtEntities.iterator();
        while (iterator.hasNext()) {
            FanProcessingType processingType;
            class_1297 entity = iterator.next();
            if (!entity.method_5805() || !entity.method_5829().method_994(this.bounds) || AirCurrent.isPlayerCreativeFlying(entity)) {
                iterator.remove();
                continue;
            }
            class_2382 flow = (this.pushing ? this.direction : this.direction.method_10153()).method_10163();
            float speed = Math.abs(this.source.getSpeed());
            float sneakModifier = entity.method_5715() ? 4096.0f : 512.0f;
            double entityDistance = VecHelper.alignedDistanceToFace(entity.method_19538(), this.source.getAirCurrentPos(), this.direction);
            double entityDistanceOld = entity.method_19538().method_1022(VecHelper.getCenterOf((class_2382)this.source.getAirCurrentPos()));
            float acceleration = (float)((double)(speed / sneakModifier) / (entityDistanceOld / (double)this.maxDistance));
            class_243 previousMotion = entity.method_18798();
            float maxAcceleration = 5.0f;
            double xIn = class_3532.method_15350((double)((double)((float)flow.method_10263() * acceleration) - previousMotion.field_1352), (double)(-maxAcceleration), (double)maxAcceleration);
            double yIn = class_3532.method_15350((double)((double)((float)flow.method_10264() * acceleration) - previousMotion.field_1351), (double)(-maxAcceleration), (double)maxAcceleration);
            double zIn = class_3532.method_15350((double)((double)((float)flow.method_10260() * acceleration) - previousMotion.field_1350), (double)(-maxAcceleration), (double)maxAcceleration);
            entity.method_18799(previousMotion.method_1019(new class_243(xIn, yIn, zIn).method_1021(0.125)));
            entity.field_6017 = 0.0f;
            EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> AirCurrent.enableClientPlayerSound(entity, class_3532.method_15363((float)(speed / 128.0f * 0.4f), (float)0.01f, (float)0.4f)));
            if (entity instanceof class_3222) {
                ((ServerGamePacketListenerImplAccessor)((class_3222)entity).field_13987).create$setAboveGroundTickCount(0);
            }
            if ((processingType = this.getTypeAt((float)entityDistance)) == AllFanProcessingTypes.NONE) continue;
            if (entity instanceof class_1542) {
                IAirCurrentSource iAirCurrentSource;
                class_1542 itemEntity = (class_1542)entity;
                if (world != null && world.field_9236) {
                    processingType.spawnProcessingParticles(world, entity.method_19538());
                    continue;
                }
                if (!FanProcessing.canProcess(itemEntity, processingType) || !FanProcessing.applyProcessing(itemEntity, processingType) || !((iAirCurrentSource = this.source) instanceof EncasedFanBlockEntity)) continue;
                EncasedFanBlockEntity fan = (EncasedFanBlockEntity)iAirCurrentSource;
                fan.award(AllAdvancements.FAN_PROCESSING);
                continue;
            }
            if (world == null) continue;
            processingType.affectEntity(entity, world);
        }
    }

    public static boolean isPlayerCreativeFlying(class_1297 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            return player.method_7337() && player.method_31549().field_7479;
        }
        return false;
    }

    public void tickAffectedHandlers() {
        for (Pair<TransportedItemStackHandlerBehaviour, FanProcessingType> pair : this.affectedItemHandlers) {
            TransportedItemStackHandlerBehaviour handler = (TransportedItemStackHandlerBehaviour)pair.getKey();
            class_1937 world = handler.getWorld();
            FanProcessingType processingType = (FanProcessingType)pair.getRight();
            handler.handleProcessingOnAllItems(transported -> {
                IAirCurrentSource patt6450$temp;
                if (world.field_9236) {
                    processingType.spawnProcessingParticles(world, handler.getWorldPositionOf((TransportedItemStack)transported));
                    return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
                }
                TransportedItemStackHandlerBehaviour.TransportedResult applyProcessing = FanProcessing.applyProcessing(transported, world, processingType);
                if (!applyProcessing.doesNothing() && (patt6450$temp = this.source) instanceof EncasedFanBlockEntity) {
                    EncasedFanBlockEntity fan = (EncasedFanBlockEntity)patt6450$temp;
                    fan.award(AllAdvancements.FAN_PROCESSING);
                }
                return applyProcessing;
            });
        }
    }

    public void rebuild() {
        if (this.source.getSpeed() == 0.0f) {
            this.maxDistance = 0.0f;
            this.segments.clear();
            this.bounds = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            return;
        }
        this.direction = this.source.getAirflowOriginSide();
        this.pushing = this.source.getAirFlowDirection() == this.direction;
        this.maxDistance = this.source.getMaxDistance();
        class_1937 world = this.source.getAirCurrentWorld();
        class_2338 start = this.source.getAirCurrentPos();
        float max = this.maxDistance;
        class_2350 facing = this.direction;
        class_243 directionVec = class_243.method_24954((class_2382)facing.method_10163());
        this.maxDistance = AirCurrent.getFlowLimit(world, start, max, facing);
        this.segments.clear();
        AirCurrentSegment currentSegment = null;
        FanProcessingType type = AllFanProcessingTypes.NONE;
        int limit = this.getLimit();
        int searchStart = this.pushing ? 1 : limit;
        int searchEnd = this.pushing ? limit : 1;
        int searchStep = this.pushing ? 1 : -1;
        int toOffset = this.pushing ? -1 : 0;
        int i = searchStart;
        while (i * searchStep <= searchEnd * searchStep) {
            class_2338 currentPos = start.method_10079(this.direction, i);
            FanProcessingType newType = FanProcessingType.getAt(world, currentPos);
            if (newType != AllFanProcessingTypes.NONE) {
                type = newType;
            }
            if (currentSegment == null) {
                currentSegment = new AirCurrentSegment();
                currentSegment.startOffset = i + toOffset;
                currentSegment.type = type;
            } else if (currentSegment.type != type) {
                currentSegment.endOffset = i + toOffset;
                this.segments.add(currentSegment);
                currentSegment = new AirCurrentSegment();
                currentSegment.startOffset = i + toOffset;
                currentSegment.type = type;
            }
            i += searchStep;
        }
        if (currentSegment != null) {
            currentSegment.endOffset = searchEnd + searchStep + toOffset;
            this.segments.add(currentSegment);
        }
        if (this.maxDistance < 0.25f) {
            this.bounds = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        } else {
            float factor = this.maxDistance - 1.0f;
            class_243 scale = directionVec.method_1021((double)factor);
            this.bounds = factor > 0.0f ? new class_238(start.method_10093(this.direction)).method_18804(scale) : new class_238(start.method_10093(this.direction)).method_1002(scale.field_1352, scale.field_1351, scale.field_1350).method_997(scale);
        }
        this.findAffectedHandlers();
    }

    public static float getFlowLimit(class_1937 world, class_2338 start, float max, class_2350 facing) {
        int i = 0;
        while ((float)i < max) {
            class_265 shape;
            class_2338 currentPos = start.method_10079(facing, i + 1);
            if (!world.method_8477(currentPos)) {
                return i;
            }
            class_2680 state = world.method_8320(currentPos);
            class_2680 copycatState = CopycatBlock.getMaterial((class_1922)world, currentPos);
            if (!AirCurrent.shouldAlwaysPass(copycatState.method_26215() ? state : copycatState) && !(shape = state.method_26220((class_1922)world, currentPos)).method_1110()) {
                if (shape == class_259.method_1077()) {
                    return i;
                }
                double shapeDepth = AirCurrent.findMaxDepth(shape, facing);
                if (shapeDepth != Double.POSITIVE_INFINITY) {
                    return Math.min((float)((double)i + shapeDepth + 0.03125), max);
                }
            }
            ++i;
        }
        return max;
    }

    private static double findMaxDepth(class_265 shape, class_2350 direction) {
        class_2350.class_2351 axis = direction.method_10166();
        class_2350.class_2352 axisDirection = direction.method_10171();
        double maxDepth = 0.0;
        for (double[] coordinates : DEPTH_TEST_COORDINATES) {
            double depth;
            if (axisDirection == class_2350.class_2352.field_11056) {
                double min = shape.method_35593(axis, coordinates[0], coordinates[1]);
                if (min == Double.POSITIVE_INFINITY) {
                    return Double.POSITIVE_INFINITY;
                }
                depth = min;
            } else {
                double max = shape.method_1102(axis, coordinates[0], coordinates[1]);
                if (max == Double.NEGATIVE_INFINITY) {
                    return Double.POSITIVE_INFINITY;
                }
                depth = 1.0 - max;
            }
            if (!(depth > maxDepth)) continue;
            maxDepth = depth;
        }
        return maxDepth;
    }

    private static boolean shouldAlwaysPass(class_2680 state) {
        return AllTags.AllBlockTags.FAN_TRANSPARENT.matches(state);
    }

    private int getLimit() {
        if ((float)((int)this.maxDistance) == this.maxDistance) {
            return (int)this.maxDistance;
        }
        return (int)this.maxDistance + 1;
    }

    public void findAffectedHandlers() {
        class_1937 world = this.source.getAirCurrentWorld();
        class_2338 start = this.source.getAirCurrentPos();
        this.affectedItemHandlers.clear();
        int limit = this.getLimit();
        block0: for (int i = 1; i <= limit; ++i) {
            FanProcessingType segmentType = this.getTypeAt(i - 1);
            for (int offset : Iterate.zeroAndOne) {
                class_2338 pos = start.method_10079(this.direction, i).method_10087(offset);
                TransportedItemStackHandlerBehaviour behaviour = BlockEntityBehaviour.get((class_1922)world, pos, TransportedItemStackHandlerBehaviour.TYPE);
                if (behaviour != null) {
                    FanProcessingType type = FanProcessingType.getAt(world, pos);
                    if (type == AllFanProcessingTypes.NONE) {
                        type = segmentType;
                    }
                    this.affectedItemHandlers.add((Pair<TransportedItemStackHandlerBehaviour, FanProcessingType>)Pair.of((Object)behaviour, (Object)type));
                }
                if (this.direction.method_10166().method_10178()) continue block0;
            }
        }
    }

    public void findEntities() {
        this.caughtEntities.clear();
        this.caughtEntities = this.source.getAirCurrentWorld().method_8335(null, this.bounds);
    }

    public FanProcessingType getTypeAt(float offset) {
        block4: {
            if (!(offset >= 0.0f) || !(offset <= this.maxDistance)) break block4;
            if (this.pushing) {
                for (AirCurrentSegment airCurrentSegment : this.segments) {
                    if (!(offset <= (float)airCurrentSegment.endOffset)) continue;
                    return airCurrentSegment.type;
                }
            } else {
                for (AirCurrentSegment airCurrentSegment : this.segments) {
                    if (!(offset >= (float)airCurrentSegment.endOffset)) continue;
                    return airCurrentSegment.type;
                }
            }
        }
        return AllFanProcessingTypes.NONE;
    }

    @Environment(value=EnvType.CLIENT)
    private static void enableClientPlayerSound(class_1297 e, float maxVolume) {
        if (e != class_310.method_1551().method_1560()) {
            return;
        }
        isClientPlayerInAirCurrent = true;
        float pitch = (float)class_3532.method_15350((double)(e.method_18798().method_1033() * 0.5), (double)0.5, (double)2.0);
        if (flyingSound == null || flyingSound.method_4793()) {
            flyingSound = new AirCurrentSound(class_3417.field_14572, pitch);
            class_310.method_1551().method_1483().method_4873((class_1113)flyingSound);
        }
        flyingSound.setPitch(pitch);
        flyingSound.fadeIn(maxVolume);
    }

    @Environment(value=EnvType.CLIENT)
    public static void tickClientPlayerSounds() {
        if (!isClientPlayerInAirCurrent && flyingSound != null) {
            if (flyingSound.isFaded()) {
                flyingSound.stopSound();
            } else {
                flyingSound.fadeOut();
            }
        }
        isClientPlayerInAirCurrent = false;
    }

    private static class AirCurrentSegment {
        private FanProcessingType type;
        private int startOffset;
        private int endOffset;

        private AirCurrentSegment() {
        }
    }
}

