/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.model;

import com.simibubi.create.foundation.block.render.SpriteShiftEntry;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.function.UnaryOperator;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1093;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_806;

public class BakedModelHelper {
    public static void cropAndMove(MutableQuadView quad, class_1058 sprite, class_238 crop, class_243 move) {
        class_243 xyz0 = BakedQuadHelper.getXYZ((QuadView)quad, 0);
        class_243 xyz1 = BakedQuadHelper.getXYZ((QuadView)quad, 1);
        class_243 xyz2 = BakedQuadHelper.getXYZ((QuadView)quad, 2);
        class_243 xyz3 = BakedQuadHelper.getXYZ((QuadView)quad, 3);
        class_243 uAxis = xyz3.method_1019(xyz2).method_1021(0.5);
        class_243 vAxis = xyz1.method_1019(xyz2).method_1021(0.5);
        class_243 center = xyz3.method_1019(xyz2).method_1019(xyz0).method_1019(xyz1).method_1021(0.25);
        float u0 = quad.spriteU(0, 0);
        float u3 = quad.spriteU(3, 0);
        float v0 = quad.spriteV(0, 0);
        float v1 = quad.spriteV(1, 0);
        float uScale = Math.round((double)(SpriteShiftEntry.getUnInterpolatedU(sprite, u3) - SpriteShiftEntry.getUnInterpolatedU(sprite, u0)) / xyz3.method_1022(xyz0));
        float vScale = Math.round((double)(SpriteShiftEntry.getUnInterpolatedV(sprite, v1) - SpriteShiftEntry.getUnInterpolatedV(sprite, v0)) / xyz1.method_1022(xyz0));
        if (uScale == 0.0f) {
            float v3 = quad.spriteV(3, 0);
            float u1 = quad.spriteU(1, 0);
            uAxis = xyz1.method_1019(xyz2).method_1021(0.5);
            vAxis = xyz3.method_1019(xyz2).method_1021(0.5);
            uScale = Math.round((double)(SpriteShiftEntry.getUnInterpolatedU(sprite, u1) - SpriteShiftEntry.getUnInterpolatedU(sprite, u0)) / xyz1.method_1022(xyz0));
            vScale = Math.round((double)(SpriteShiftEntry.getUnInterpolatedV(sprite, v3) - SpriteShiftEntry.getUnInterpolatedV(sprite, v0)) / xyz3.method_1022(xyz0));
        }
        uAxis = uAxis.method_1020(center).method_1029();
        vAxis = vAxis.method_1020(center).method_1029();
        class_243 min = new class_243(crop.field_1323, crop.field_1322, crop.field_1321);
        class_243 max = new class_243(crop.field_1320, crop.field_1325, crop.field_1324);
        for (int vertex = 0; vertex < 4; ++vertex) {
            class_243 xyz = BakedQuadHelper.getXYZ((QuadView)quad, vertex);
            class_243 newXyz = VecHelper.componentMin(max, VecHelper.componentMax(xyz, min));
            class_243 diff = newXyz.method_1020(xyz);
            if (diff.method_1027() > 0.0) {
                float u = quad.spriteU(vertex, 0);
                float v = quad.spriteV(vertex, 0);
                float uDiff = (float)uAxis.method_1026(diff) * uScale;
                float vDiff = (float)vAxis.method_1026(diff) * vScale;
                quad.sprite(vertex, 0, sprite.method_4580((double)(SpriteShiftEntry.getUnInterpolatedU(sprite, u) + uDiff)), sprite.method_4570((double)(SpriteShiftEntry.getUnInterpolatedV(sprite, v) + vDiff)));
            }
            BakedQuadHelper.setXYZ(quad, vertex, newXyz.method_1019(move));
        }
    }

    public static class_1087 generateModel(class_1087 template, UnaryOperator<class_1058> spriteSwapper) {
        class_5819 random = class_5819.method_43047();
        EnumMap<class_2350, List<class_777>> culledFaces = new EnumMap<class_2350, List<class_777>>(class_2350.class);
        for (class_2350 cullFace : Iterate.directions) {
            random.method_43052(42L);
            List quads = template.method_4707(null, cullFace, random);
            culledFaces.put(cullFace, BakedModelHelper.swapSprites(quads, spriteSwapper));
        }
        random.method_43052(42L);
        List quads = template.method_4707(null, null, random);
        List<class_777> unculledFaces = BakedModelHelper.swapSprites(quads, spriteSwapper);
        class_1058 particleSprite = template.method_4711();
        class_1058 swappedParticleSprite = (class_1058)spriteSwapper.apply(particleSprite);
        if (swappedParticleSprite != null) {
            particleSprite = swappedParticleSprite;
        }
        return new class_1093(unculledFaces, culledFaces, template.method_4708(), template.method_24304(), template.method_4712(), particleSprite, template.method_4709(), class_806.field_4292);
    }

    public static List<class_777> swapSprites(List<class_777> quads, UnaryOperator<class_1058> spriteSwapper) {
        ArrayList<class_777> newQuads = new ArrayList<class_777>(quads);
        int size = quads.size();
        for (int i = 0; i < size; ++i) {
            class_777 quad = quads.get(i);
            class_1058 sprite = quad.method_35788();
            class_1058 newSprite = (class_1058)spriteSwapper.apply(sprite);
            if (newSprite == null || sprite == newSprite) continue;
            class_777 newQuad = BakedQuadHelper.clone(quad);
            int[] vertexData = newQuad.method_3357();
            for (int vertex = 0; vertex < 4; ++vertex) {
                float u = BakedQuadHelper.getU(vertexData, vertex);
                float v = BakedQuadHelper.getV(vertexData, vertex);
                BakedQuadHelper.setU(vertexData, vertex, newSprite.method_4580((double)SpriteShiftEntry.getUnInterpolatedU(sprite, u)));
                BakedQuadHelper.setV(vertexData, vertex, newSprite.method_4570((double)SpriteShiftEntry.getUnInterpolatedV(sprite, v)));
            }
            newQuads.set(i, newQuad);
        }
        return newQuads;
    }
}

